/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.lang.invoke.CallSite;
import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.spi.core.security.jaas.PrincipalConversionLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.junit.Assert;
import org.junit.Test;

public class PrincipalConversionLoginModuleTest {
    @Test
    public void loginOk() throws Exception {
        PrincipalConversionLoginModule underTest = new PrincipalConversionLoginModule();
        Subject subject = new Subject();
        underTest.initialize(subject, null, null, new HashMap());
        Assert.assertTrue((boolean)underTest.login());
        Assert.assertFalse((boolean)underTest.commit());
        Assert.assertTrue((boolean)subject.getPrincipals().isEmpty());
    }

    @Test
    public void loginOkOnNullSubject() throws Exception {
        PrincipalConversionLoginModule underTest = new PrincipalConversionLoginModule();
        underTest.initialize(null, null, null, new HashMap());
        Assert.assertTrue((boolean)underTest.login());
        Assert.assertFalse((boolean)underTest.commit());
        Assert.assertTrue((boolean)underTest.logout());
    }

    @Test
    public void loginConvert() throws Exception {
        PrincipalConversionLoginModule underTest = new PrincipalConversionLoginModule();
        Subject subject = new Subject();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principalClassList", RolePrincipal.class.getCanonicalName());
        subject.getPrincipals().add((Principal)new RolePrincipal("BLA"));
        underTest.initialize(subject, null, null, options);
        Assert.assertTrue((boolean)underTest.login());
        Assert.assertTrue((boolean)underTest.commit());
        Assert.assertEquals((long)1L, (long)subject.getPrincipals(UserPrincipal.class).size());
        Assert.assertEquals((Object)"BLA", (Object)((Principal)subject.getPrincipals(UserPrincipal.class).iterator().next()).getName());
        underTest.logout();
        Assert.assertEquals((long)0L, (long)subject.getPrincipals(UserPrincipal.class).size());
    }

    @Test
    public void loginNoOverwriteExistingUserPrincipal() throws Exception {
        PrincipalConversionLoginModule underTest = new PrincipalConversionLoginModule();
        Subject subject = new Subject();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("principalClassList", RolePrincipal.class.getCanonicalName());
        subject.getPrincipals().add((Principal)new RolePrincipal("BLA"));
        subject.getPrincipals().add((Principal)new UserPrincipal("Important"));
        underTest.initialize(subject, null, null, options);
        Assert.assertTrue((boolean)underTest.login());
        Assert.assertFalse((boolean)underTest.commit());
        Assert.assertEquals((long)1L, (long)subject.getPrincipals(UserPrincipal.class).size());
        Assert.assertEquals((Object)"Important", (Object)((Principal)subject.getPrincipals(UserPrincipal.class).iterator().next()).getName());
    }

    @Test
    public void loginConvertList() throws Exception {
        PrincipalConversionLoginModule underTest = new PrincipalConversionLoginModule();
        Subject subject = new Subject();
        HashMap<String, CallSite> options = new HashMap<String, CallSite>();
        String multiOptionList = TestPrincipal.class.getTypeName() + ", " + RolePrincipal.class.getTypeName();
        options.put("principalClassList", (CallSite)((Object)multiOptionList));
        subject.getPrincipals().add(new TestPrincipal());
        underTest.initialize(subject, null, null, options);
        Assert.assertTrue((boolean)underTest.login());
        Assert.assertTrue((boolean)underTest.commit());
        Assert.assertEquals((long)1L, (long)subject.getPrincipals(UserPrincipal.class).size());
        Assert.assertEquals((Object)"TestPrincipal", (Object)((Principal)subject.getPrincipals(UserPrincipal.class).iterator().next()).getName());
    }

    static final class TestPrincipal
    implements Principal {
        TestPrincipal() {
        }

        @Override
        public boolean equals(Object another) {
            return this == another;
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public String getName() {
            return "TestPrincipal";
        }
    }
}

