/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.client;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.client.KubernetesClientImpl;
import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.model.TokenReview;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockserver.configuration.Configuration;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.JsonBody;
import org.mockserver.model.RequestDefinition;
import org.mockserver.socket.PortFactory;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientImplTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String API_PATH = "/apis/authentication.k8s.io/v1/tokenreviews";
    private static ClientAndServer mockServer;
    private static final String host = "localhost";
    private static String port;
    private static final String BOB_REQUEST = "{\"apiVersion\": \"authentication.k8s.io/v1\",\"kind\": \"TokenReview\", \"spec\": {\"token\": \"bob_token\"}}";
    private static final String KERMIT_REQUEST = "{\"apiVersion\": \"authentication.k8s.io/v1\",\"kind\": \"TokenReview\", \"spec\": {\"token\": \"kermit_token\"}}";

    @BeforeClass
    public static void startServer() {
        ConfigurationProperties.dynamicallyCreateCertificateAuthorityCertificate((boolean)true);
        ConfigurationProperties.directoryToSaveDynamicSSLCertificate((String)"target/test-classes");
        ConfigurationProperties.preventCertificateDynamicUpdate((boolean)false);
        ConfigurationProperties.proactivelyInitialiseTLS((boolean)true);
        Configuration configuration = Configuration.configuration();
        mockServer = ClientAndServer.startClientAndServer((Configuration)configuration, (Integer[])new Integer[]{PortFactory.findFreePort()});
        port = Integer.toString(mockServer.getPort());
        Assert.assertNotNull((Object)mockServer);
        Assert.assertTrue((boolean)mockServer.hasStarted());
        System.setProperty("KUBERNETES_SERVICE_HOST", host);
        System.setProperty("KUBERNETES_SERVICE_PORT", port);
        System.setProperty("KUBERNETES_TOKEN_PATH", KubernetesClientImplTest.class.getClassLoader().getResource("client_token").getPath());
        URL caPath = KubernetesClientImplTest.class.getClassLoader().getResource("CertificateAuthorityCertificate.pem");
        Assert.assertNotNull((Object)caPath);
        logger.info("Setting KUBERNETES_CA_PATH {}", (Object)caPath.getPath());
        System.setProperty("KUBERNETES_CA_PATH", caPath.getPath());
    }

    @AfterClass
    public static void stopServer() {
        System.clearProperty("KUBERNETES_SERVICE_HOST");
        System.clearProperty("KUBERNETES_SERVICE_PORT");
        System.clearProperty("KUBERNETES_TOKEN_PATH");
        System.clearProperty("KUBERNETES_CA_PATH");
        mockServer.stop();
    }

    @Before
    public void reset() {
        mockServer.reset();
    }

    @Test
    public void testGetTokenReview() {
        mockServer.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(API_PATH).withBody((Body)JsonBody.json((String)BOB_REQUEST, (MatchType)MatchType.STRICT))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(201)).withBody("{\"status\": {\"authenticated\": false }}"));
        mockServer.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(API_PATH).withBody((Body)JsonBody.json((String)KERMIT_REQUEST, (MatchType)MatchType.STRICT))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(201)).withBody("{\"status\": {\"authenticated\": true, \"user\": {  \"username\": \"system:serviceaccounts:some-ns:kermit\"}}}"));
        mockServer.when((RequestDefinition)HttpRequest.request().withMethod("POST").withPath(API_PATH)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(500)));
        KubernetesClientImpl client = new KubernetesClientImpl();
        TokenReview tr = client.getTokenReview("bob_token");
        Assert.assertNotNull((Object)tr);
        Assert.assertFalse((boolean)tr.isAuthenticated());
        Assert.assertNull((Object)tr.getUser());
        Assert.assertNull((Object)tr.getUsername());
        tr = client.getTokenReview("kermit_token");
        Assert.assertNotNull((Object)tr);
        Assert.assertNotNull((Object)tr.getUser());
        MatcherAssert.assertThat((Object)tr.getUsername(), (Matcher)Matchers.is((Object)"system:serviceaccounts:some-ns:kermit"));
        MatcherAssert.assertThat((Object)tr.getUser().getUsername(), (Matcher)Matchers.is((Object)"system:serviceaccounts:some-ns:kermit"));
        tr = client.getTokenReview("other");
        Assert.assertNotNull((Object)tr);
        Assert.assertFalse((boolean)tr.isAuthenticated());
        mockServer.verify((RequestDefinition)HttpRequest.request().withPath(API_PATH), VerificationTimes.exactly((int)3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetParam() throws Exception {
        Set<Map.Entry<String, String>> env = System.getenv().entrySet();
        block3: for (Map.Entry<String, String> envKv : env) {
            if (System.getProperty(envKv.getKey()) != null) continue;
            KubernetesClientImpl clientImpl = new KubernetesClientImpl();
            Assert.assertEquals((Object)envKv.getValue(), (Object)clientImpl.getParam(envKv.getKey(), null));
            String valFromProp = "bla";
            try {
                System.setProperty(envKv.getKey(), "bla");
                Assert.assertEquals((Object)"bla", (Object)clientImpl.getParam(envKv.getKey(), null));
            }
            finally {
                System.clearProperty(envKv.getKey());
            }
            Object candidate = "bla";
            for (int i = 0; i < 10; ++i) {
                if (System.getenv((String)candidate) == null && System.getProperty((String)candidate) == null) {
                    Assert.assertEquals((Object)candidate, (Object)clientImpl.getParam((String)candidate, (String)candidate));
                    break block3;
                }
                candidate = (String)candidate + i;
            }
        }
    }
}

