/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.model;

import org.apache.activemq.artemis.spi.core.security.jaas.kubernetes.model.TokenReview;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class TokenReviewTest {
    @Test
    public void testEmpty() {
        String json = "{}";
        TokenReview tr = TokenReview.fromJsonString((String)json);
        Assert.assertFalse((boolean)tr.isAuthenticated());
        Assert.assertNull((Object)tr.getUser());
        Assert.assertNull((Object)tr.getUsername());
    }

    @Test
    public void testSimple() {
        String json = "{\"status\": {\"authenticated\": true, \"user\": {\"username\": \"system:serviceaccounts:some-ns:kermit\"}}}";
        TokenReview tr = TokenReview.fromJsonString((String)json);
        Assert.assertNotNull((Object)tr);
        Assert.assertTrue((boolean)tr.isAuthenticated());
        MatcherAssert.assertThat((Object)tr.getUsername(), (Matcher)Matchers.is((Object)"system:serviceaccounts:some-ns:kermit"));
        Assert.assertNotNull((Object)tr.getUser());
        MatcherAssert.assertThat((Object)tr.getUser().getUsername(), (Matcher)Matchers.is((Object)"system:serviceaccounts:some-ns:kermit"));
        MatcherAssert.assertThat((Object)tr.getAudiences(), (Matcher)Matchers.empty());
        Assert.assertNull((Object)tr.getUser().getExtra());
    }

    @Test
    public void testCompleteObject() {
        String json = "{\"status\": {\"authenticated\": true, \"user\": {  \"username\": \"system:serviceaccounts:some-ns:kermit\",  \"uid\": \"kermit-uid\",  \"groups\": [    \"group-1\",    \"group-2\"  ],  \"extra\": {    \"authentication.kubernetes.io/pod-name\": [      \"pod-1\",      \"pod-2\"    ],    \"authentication.kubernetes.io/pod-uid\": [      \"pod-uid-1\",      \"pod-uid-2\"    ]  }},\"audiences\": [  \"audience-1\",  \"audience-2\"]}}";
        TokenReview tr = TokenReview.fromJsonString((String)json);
        Assert.assertNotNull((Object)tr);
        Assert.assertTrue((boolean)tr.isAuthenticated());
        MatcherAssert.assertThat((Object)tr.getUsername(), (Matcher)Matchers.is((Object)"system:serviceaccounts:some-ns:kermit"));
        Assert.assertNotNull((Object)tr.getUser());
        MatcherAssert.assertThat((Object)tr.getUser().getUsername(), (Matcher)Matchers.is((Object)"system:serviceaccounts:some-ns:kermit"));
        MatcherAssert.assertThat((Object)tr.getAudiences(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"audience-1", "audience-2"}));
        MatcherAssert.assertThat((Object)tr.getUser().getGroups(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group-1", "group-2"}));
        MatcherAssert.assertThat((Object)tr.getUser().getUid(), (Matcher)Matchers.is((Object)"kermit-uid"));
        Assert.assertNotNull((Object)tr.getUser().getExtra());
        MatcherAssert.assertThat((Object)tr.getUser().getExtra().getPodNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"pod-1", "pod-2"}));
        MatcherAssert.assertThat((Object)tr.getUser().getExtra().getPodUids(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"pod-uid-1", "pod-uid-2"}));
    }
}

