/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import java.io.File;
import org.apache.activemq.artemis.utils.FileUtil;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class NoFilesBehind
extends TestWatcher {
    private final String[] filesToCheck;

    public NoFilesBehind(String ... filesToCheck) {
        this.filesToCheck = filesToCheck;
    }

    private File checkFiles() {
        for (String f : this.filesToCheck) {
            File fileCheck = new File(f);
            if (!fileCheck.exists()) continue;
            return fileCheck;
        }
        return null;
    }

    protected void starting(Description description) {
        File leaked = this.checkFiles();
        if (leaked != null) {
            Assert.fail((String)("A previous test left a folder around:: " + leaked.getAbsolutePath()));
        }
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void succeeded(Description description) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finished(Description description) {
        File leaked = this.checkFiles();
        if (leaked != null) {
            try {
                Assert.fail((String)(leaked.getAbsolutePath() + " is being left behind"));
            }
            finally {
                try {
                    FileUtil.deleteDirectory((File)leaked);
                }
                catch (Throwable almostIgnored) {
                    almostIgnored.printStackTrace();
                }
            }
        }
    }
}

