/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptorParserTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testAcceptor() throws Exception {
        List configs = ConfigurationUtils.parseAcceptorURI((String)"test", (String)"tcp://localhost:8080?tcpSendBufferSize=1048576&tcpReceiveBufferSize=1048576&protocols=openwire&banana=x");
        for (TransportConfiguration config : configs) {
            logger.debug("config: {}", (Object)config);
            Assert.assertTrue((boolean)config.getExtraParams().get("banana").equals("x"));
        }
    }

    @Test
    public void testAcceptorShutdownTimeout() {
        List configs = ConfigurationUtils.parseAcceptorURI((String)"test", (String)"tcp://localhost:8080?quietPeriod=33;shutdownTimeout=55");
        Assert.assertEquals((long)1L, (long)configs.size());
        Assert.assertEquals((long)33L, (long)ConfigurationHelper.getIntProperty((String)"quietPeriod", (int)-1, (Map)((TransportConfiguration)configs.get(0)).getParams()));
        Assert.assertEquals((long)55L, (long)ConfigurationHelper.getIntProperty((String)"shutdownTimeout", (int)-1, (Map)((TransportConfiguration)configs.get(0)).getParams()));
        NettyAcceptor nettyAcceptor = new NettyAcceptor("name", null, ((TransportConfiguration)configs.get(0)).getParams(), null, null, null, null, new HashMap());
        Assert.assertEquals((long)33L, (long)nettyAcceptor.getQuietPeriod());
        Assert.assertEquals((long)55L, (long)nettyAcceptor.getShutdownTimeout());
    }

    @Test
    public void testAcceptorWithQueryParamEscapes() throws Exception {
        List configs = ConfigurationUtils.parseAcceptorURI((String)"test", (String)"tcp://0.0.0.0:5672?tcpSendBufferSize=1048576;tcpReceiveBufferSize=1048576;virtualTopicConsumerWildcards=Consumer.*.%3E%3B2");
        for (TransportConfiguration config : configs) {
            logger.debug("config: {}", (Object)config);
            logger.debug("{}", config.getExtraParams().get("virtualTopicConsumerWildcards"));
            Assert.assertTrue((boolean)config.getExtraParams().get("virtualTopicConsumerWildcards").equals("Consumer.*.>;2"));
        }
    }
}

