/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.uri.ClusterConnectionConfigurationParser;
import org.junit.Assert;
import org.junit.Test;

public class ClusterConnectionConfigurationTest {
    @Test
    public void testClusterConnectionStatic() throws Exception {
        ClusterConnectionConfigurationParser parser = new ClusterConnectionConfigurationParser();
        ClusterConnectionConfiguration configuration = (ClusterConnectionConfiguration)parser.newObject(new URI("static:(tcp://localhost:6556,tcp://localhost:6557)?minLargeMessageSize=132;s&messageLoadBalancingType=OFF"), null);
        Assert.assertEquals((Object)MessageLoadBalancingType.OFF, (Object)configuration.getMessageLoadBalancingType());
        Assert.assertEquals((long)132L, (long)configuration.getMinLargeMessageSize());
        Assert.assertEquals((Object)"tcp://localhost:6556", (Object)configuration.getCompositeMembers().getComponents()[0].toString());
        Assert.assertEquals((Object)"tcp://localhost:6557", (Object)configuration.getCompositeMembers().getComponents()[1].toString());
    }

    @Test
    public void testClusterConnectionStaticOffWithRedistribution() throws Exception {
        ClusterConnectionConfigurationParser parser = new ClusterConnectionConfigurationParser();
        ClusterConnectionConfiguration configuration = (ClusterConnectionConfiguration)parser.newObject(new URI("static:(tcp://localhost:6556,tcp://localhost:6557)?minLargeMessageSize=132;s&messageLoadBalancingType=OFF_WITH_REDISTRIBUTION"), null);
        Assert.assertEquals((Object)MessageLoadBalancingType.OFF_WITH_REDISTRIBUTION, (Object)configuration.getMessageLoadBalancingType());
    }

    @Test
    public void testClusterConnectionStatic2() throws Exception {
        ClusterConnectionConfigurationParser parser = new ClusterConnectionConfigurationParser();
        ClusterConnectionConfiguration configuration = (ClusterConnectionConfiguration)parser.newObject(new URI("static://(tcp://localhost:6556,tcp://localhost:6557)?minLargeMessageSize=132;messageLoadBalancingType=OFF"), null);
        Assert.assertEquals((long)132L, (long)configuration.getMinLargeMessageSize());
        Assert.assertEquals((long)2L, (long)configuration.getCompositeMembers().getComponents().length);
        Assert.assertEquals((Object)"tcp://localhost:6556", (Object)configuration.getCompositeMembers().getComponents()[0].toString());
        Assert.assertEquals((Object)"tcp://localhost:6557", (Object)configuration.getCompositeMembers().getComponents()[1].toString());
    }

    @Test
    public void testClusterConnectionStaticOnConstrcutor() throws Exception {
        ClusterConnectionConfiguration configuration = new ClusterConnectionConfiguration(new URI("static:(tcp://localhost:6556,tcp://localhost:6557)?minLargeMessageSize=132"));
        Assert.assertEquals((long)132L, (long)configuration.getMinLargeMessageSize());
        Assert.assertEquals((Object)"tcp://localhost:6556", (Object)configuration.getCompositeMembers().getComponents()[0].toString());
        Assert.assertEquals((Object)"tcp://localhost:6557", (Object)configuration.getCompositeMembers().getComponents()[1].toString());
    }

    @Test
    public void testClusterConnectionMulticast() throws Exception {
        ClusterConnectionConfigurationParser parser = new ClusterConnectionConfigurationParser();
        ClusterConnectionConfiguration configuration = (ClusterConnectionConfiguration)parser.newObject(new URI("multicast://myGroup?minLargeMessageSize=132"), null);
        Assert.assertEquals((Object)"myGroup", (Object)configuration.getDiscoveryGroupName());
        Assert.assertEquals((long)132L, (long)configuration.getMinLargeMessageSize());
    }

    @Test
    public void testClusterConnectionProducerWindowSize() throws Exception {
        ClusterConnectionConfigurationParser parser = new ClusterConnectionConfigurationParser();
        ClusterConnectionConfiguration configuration = (ClusterConnectionConfiguration)parser.newObject(new URI("static:(tcp://localhost:6556)?producerWindowSize=1234"), null);
        Assert.assertEquals((long)1234L, (long)configuration.getProducerWindowSize());
    }
}

