/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.json.JsonObjectBuilder;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ConnectionFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.StringUtil;

public class ConnectionView
extends ActiveMQAbstractView<RemotingConnection> {
    private static final String defaultSortColumn = "creationTime";
    private final ActiveMQServer server;

    public ConnectionView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ConnectionFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return RemotingConnection.class;
    }

    @Override
    public JsonObjectBuilder toJson(RemotingConnection connection) {
        List<ServerSession> sessions = this.server.getSessions(connection.getID().toString());
        HashSet<String> users = new HashSet<String>();
        for (ServerSession session : sessions) {
            String username = session.getUsername() == null ? "" : session.getUsername();
            users.add(username);
        }
        return JsonLoader.createObjectBuilder().add("connectionID", this.toString(connection.getID())).add("remoteAddress", this.toString(connection.getRemoteAddress())).add("users", StringUtil.joinStringList(users, (String)",")).add(defaultSortColumn, new Date(connection.getCreationTime()).toString()).add("implementation", this.toString(this.toString(connection.getClass().getSimpleName()))).add("protocol", this.toString(connection.getProtocolName())).add("clientID", this.toString(connection.getClientID())).add("localAddress", this.toString(connection.getTransportConnection().getLocalAddress())).add("sessionCount", this.server.getSessions(connection.getID().toString()).size());
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

