/* This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
   and it inherits whatever license is declared at org.apache.activemq.artemis.core.server.ActiveMQMessageBundle */

package org.apache.activemq.artemis.core.server;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(retiredIDs={229001, 229003, 229008, 229010, 229060, 229064, 229075, 229100, 229101, 229118, 229201, 229202, 229246}, regexID="229[0-9]{3}", projectCode="AMQ")
public class ActiveMQMessageBundle_impl implements ActiveMQMessageBundle
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQMessageBundle_impl(Logger logger) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229000, value=\"Activation for server {}\")
   @Override
   public java.lang.String activationForServer(org.apache.activemq.artemis.core.server.ActiveMQServer server) {
      String returnString = MessageFormatter.arrayFormat("AMQ229000: Activation for server {}", new Object[]{server}).getMessage();
      return returnString;
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229002, value=\"Thread {} name = {} id = {} group = {}\")
   @Override
   public java.lang.String threadDump(java.lang.Thread key, java.lang.String name, java.lang.Long id, java.lang.ThreadGroup threadGroup) {
      String returnString = MessageFormatter.arrayFormat("AMQ229002: Thread {} name = {} id = {} group = {}", new Object[]{key, name, id, threadGroup}).getMessage();
      return returnString;
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229004, value=\"Information about server {}\nCluster Connection:{}\")
   @Override
   public java.lang.String serverDescribe(java.lang.String identity, java.lang.String describe) {
      String returnString = MessageFormatter.arrayFormat("AMQ229004: Information about server {}\nCluster Connection:{}", new Object[]{identity, describe}).getMessage();
      return returnString;
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229005, value=\"connections for {} closed by management\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException connectionsClosedByManagement(java.lang.String ipAddress) {
      String returnString = MessageFormatter.arrayFormat("AMQ229005: connections for {} closed by management", new Object[]{ipAddress}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_connectionsClosedByManagement = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_connectionsClosedByManagement);
         return objReturn_connectionsClosedByManagement;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229006, value=\"journals are not JournalImpl. You can\'t set a replicator!\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException notJournalImpl() {
      String returnString = "AMQ229006: journals are not JournalImpl. You can't set a replicator!";

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_notJournalImpl = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_notJournalImpl);
         return objReturn_notJournalImpl;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229007, value=\"unhandled error during replication\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException replicationUnhandledError(java.lang.Exception e) {
      String returnString = MessageFormatter.arrayFormat("AMQ229007: unhandled error during replication", new Object[]{e}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_replicationUnhandledError = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         objReturn_replicationUnhandledError.initCause(e);
         _copyStackTraceMinusOne(objReturn_replicationUnhandledError);
         return objReturn_replicationUnhandledError;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229009, value=\"Unhandled file type {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException replicationUnhandledFileType(org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage.FileType fileType) {
      String returnString = MessageFormatter.arrayFormat("AMQ229009: Unhandled file type {}", new Object[]{fileType}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_replicationUnhandledFileType = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_replicationUnhandledFileType);
         return objReturn_replicationUnhandledFileType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229011, value=\"unhandled data type!\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException replicationUnhandledDataType() {
      String returnString = "AMQ229011: unhandled data type!";

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_replicationUnhandledDataType = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_replicationUnhandledDataType);
         return objReturn_replicationUnhandledDataType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229012, value=\"No binding for divert {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException noBindingForDivert(org.apache.activemq.artemis.api.core.SimpleString name) {
      String returnString = MessageFormatter.arrayFormat("AMQ229012: No binding for divert {}", new Object[]{name}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_noBindingForDivert = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_noBindingForDivert);
         return objReturn_noBindingForDivert;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229013, value=\"Binding {} is not a divert\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException bindingNotDivert(org.apache.activemq.artemis.api.core.SimpleString name) {
      String returnString = MessageFormatter.arrayFormat("AMQ229013: Binding {} is not a divert", new Object[]{name}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_bindingNotDivert = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_bindingNotDivert);
         return objReturn_bindingNotDivert;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229014, value=\"Did not receive data from {} within the {}ms connection TTL. The connection will now be closed.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException clientExited(java.lang.String remoteAddress, long ttl) {
      String returnString = MessageFormatter.arrayFormat("AMQ229014: Did not receive data from {} within the {}ms connection TTL. The connection will now be closed.", new Object[]{remoteAddress, ttl}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException objReturn_clientExited = new org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException(returnString);
         _copyStackTraceMinusOne(objReturn_clientExited);
         return objReturn_clientExited;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229015, value=\"Must specify a name for each divert. This one will not be deployed.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException divertWithNoName() {
      String returnString = "AMQ229015: Must specify a name for each divert. This one will not be deployed.";

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_divertWithNoName = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_divertWithNoName);
         return objReturn_divertWithNoName;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229017, value=\"Queue {} does not exist\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException noSuchQueue(org.apache.activemq.artemis.api.core.SimpleString queueName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229017: Queue {} does not exist", new Object[]{queueName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException objReturn_noSuchQueue = new org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException(returnString);
         _copyStackTraceMinusOne(objReturn_noSuchQueue);
         return objReturn_noSuchQueue;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229018, value=\"Binding already exists {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException bindingAlreadyExists(org.apache.activemq.artemis.core.postoffice.Binding binding) {
      String returnString = MessageFormatter.arrayFormat("AMQ229018: Binding already exists {}", new Object[]{binding}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException objReturn_bindingAlreadyExists = new org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException(returnString);
         _copyStackTraceMinusOne(objReturn_bindingAlreadyExists);
         return objReturn_bindingAlreadyExists;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229019, value=\"Queue {} already exists on address {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException queueAlreadyExists(org.apache.activemq.artemis.api.core.SimpleString queueName, org.apache.activemq.artemis.api.core.SimpleString addressName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229019: Queue {} already exists on address {}", new Object[]{queueName, addressName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException objReturn_queueAlreadyExists = new org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException(returnString);
         _copyStackTraceMinusOne(objReturn_queueAlreadyExists);
         return objReturn_queueAlreadyExists;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229020, value=\"Invalid filter: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException invalidFilter(org.apache.activemq.artemis.api.core.SimpleString filter, java.lang.Throwable e) {
      String returnString = MessageFormatter.arrayFormat("AMQ229020: Invalid filter: {}", new Object[]{filter, e}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException objReturn_invalidFilter = new org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException(returnString);
         objReturn_invalidFilter.initCause(e);
         _copyStackTraceMinusOne(objReturn_invalidFilter);
         return objReturn_invalidFilter;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229021, value=\"MessageId was not assigned to Message\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException messageIdNotAssigned() {
      String returnString = "AMQ229021: MessageId was not assigned to Message";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_messageIdNotAssigned = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_messageIdNotAssigned);
         return objReturn_messageIdNotAssigned;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229022, value=\"Cannot compare journals if not in sync!\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException journalsNotInSync() {
      String returnString = "AMQ229022: Cannot compare journals if not in sync!";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_journalsNotInSync = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_journalsNotInSync);
         return objReturn_journalsNotInSync;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229023, value=\"Connected server is not a backup server\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException serverNotBackupServer() {
      String returnString = "AMQ229023: Connected server is not a backup server";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_serverNotBackupServer = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_serverNotBackupServer);
         return objReturn_serverNotBackupServer;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229024, value=\"Backup replication server is already connected to another server\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException alreadyHaveReplicationServer() {
      String returnString = "AMQ229024: Backup replication server is already connected to another server";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_alreadyHaveReplicationServer = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_alreadyHaveReplicationServer);
         return objReturn_alreadyHaveReplicationServer;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229025, value=\"Cannot delete queue {} on binding {} - it has consumers = {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException cannotDeleteQueueWithConsumers(org.apache.activemq.artemis.api.core.SimpleString name, org.apache.activemq.artemis.api.core.SimpleString queueName, java.lang.String s) {
      String returnString = MessageFormatter.arrayFormat("AMQ229025: Cannot delete queue {} on binding {} - it has consumers = {}", new Object[]{name, queueName, s}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_cannotDeleteQueueWithConsumers = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotDeleteQueueWithConsumers);
         return objReturn_cannotDeleteQueueWithConsumers;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229026, value=\"Backup Server was not yet in sync with live\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException backupServerNotInSync() {
      String returnString = "AMQ229026: Backup Server was not yet in sync with live";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_backupServerNotInSync = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_backupServerNotInSync);
         return objReturn_backupServerNotInSync;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229027, value=\"Could not find reference on consumer ID={}, messageId = {} queue = {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException consumerNoReference(java.lang.Long id, java.lang.Long messageID, org.apache.activemq.artemis.api.core.SimpleString name) {
      String returnString = MessageFormatter.arrayFormat("AMQ229027: Could not find reference on consumer ID={}, messageId = {} queue = {}", new Object[]{id, messageID, name}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_consumerNoReference = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_consumerNoReference);
         return objReturn_consumerNoReference;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229028, value=\"Consumer {} doesn\'t exist on the server\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException consumerDoesntExist(long consumerID) {
      String returnString = MessageFormatter.arrayFormat("AMQ229028: Consumer {} doesn't exist on the server", new Object[]{consumerID}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_consumerDoesntExist = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_consumerDoesntExist);
         return objReturn_consumerDoesntExist;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229029, value=\"No address configured on the Server\'s Session\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException noAddress() {
      String returnString = "AMQ229029: No address configured on the Server's Session";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_noAddress = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_noAddress);
         return objReturn_noAddress;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229030, value=\"large-message not initialized on server\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException largeMessageNotInitialised() {
      String returnString = "AMQ229030: large-message not initialized on server";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_largeMessageNotInitialised = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_largeMessageNotInitialised);
         return objReturn_largeMessageNotInitialised;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229031, value=\"Unable to validate user from {}. Username: {}; SSL certificate subject DN: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQSecurityException unableToValidateUser(java.lang.String remoteAddress, java.lang.String user, java.lang.String certMessage) {
      String returnString = MessageFormatter.arrayFormat("AMQ229031: Unable to validate user from {}. Username: {}; SSL certificate subject DN: {}", new Object[]{remoteAddress, user, certMessage}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQSecurityException objReturn_unableToValidateUser = new org.apache.activemq.artemis.api.core.ActiveMQSecurityException(returnString);
         _copyStackTraceMinusOne(objReturn_unableToValidateUser);
         return objReturn_unableToValidateUser;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229032, value=\"User: {} does not have permission=\'{}\' on address {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQSecurityException userNoPermissions(java.lang.String username, org.apache.activemq.artemis.core.security.CheckType checkType, org.apache.activemq.artemis.api.core.SimpleString address) {
      String returnString = MessageFormatter.arrayFormat("AMQ229032: User: {} does not have permission='{}' on address {}", new Object[]{username, checkType, address}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQSecurityException objReturn_userNoPermissions = new org.apache.activemq.artemis.api.core.ActiveMQSecurityException(returnString);
         _copyStackTraceMinusOne(objReturn_userNoPermissions);
         return objReturn_userNoPermissions;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229033, value=\"Server and client versions incompatible\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException incompatibleClientServer() {
      String returnString = "AMQ229033: Server and client versions incompatible";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException objReturn_incompatibleClientServer = new org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException(returnString);
         _copyStackTraceMinusOne(objReturn_incompatibleClientServer);
         return objReturn_incompatibleClientServer;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229034, value=\"Server not started\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException serverNotStarted() {
      String returnString = "AMQ229034: Server not started";

      {
         org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException objReturn_serverNotStarted = new org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException(returnString);
         _copyStackTraceMinusOne(objReturn_serverNotStarted);
         return objReturn_serverNotStarted;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229035, value=\"Metadata {}={} had been set already\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException duplicateMetadata(java.lang.String key, java.lang.String data) {
      String returnString = MessageFormatter.arrayFormat("AMQ229035: Metadata {}={} had been set already", new Object[]{key, data}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException objReturn_duplicateMetadata = new org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException(returnString);
         _copyStackTraceMinusOne(objReturn_duplicateMetadata);
         return objReturn_duplicateMetadata;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229036, value=\"Invalid type: {}\")
   @Override
   public java.lang.IllegalArgumentException invalidType(java.lang.Object type) {
      String returnString = MessageFormatter.arrayFormat("AMQ229036: Invalid type: {}", new Object[]{type}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidType = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidType);
         return objReturn_invalidType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229038, value=\"{} must neither be null nor empty\")
   @Override
   public java.lang.IllegalArgumentException emptyOrNull(java.lang.String name) {
      String returnString = MessageFormatter.arrayFormat("AMQ229038: {} must neither be null nor empty", new Object[]{name}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_emptyOrNull = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_emptyOrNull);
         return objReturn_emptyOrNull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229039, value=\"{}  must be greater than 0 (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException greaterThanZero(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229039: {}  must be greater than 0 (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_greaterThanZero = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_greaterThanZero);
         return objReturn_greaterThanZero;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229040, value=\"{} must be a valid percentual value between 0 and 100 (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException notPercent(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229040: {} must be a valid percentual value between 0 and 100 (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_notPercent = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_notPercent);
         return objReturn_notPercent;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229041, value=\"{}  must be equals to -1 or greater than 0 (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException greaterThanMinusOne(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229041: {}  must be equals to -1 or greater than 0 (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_greaterThanMinusOne = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_greaterThanMinusOne);
         return objReturn_greaterThanMinusOne;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229042, value=\"{}  must be equals to -1 or greater or equals to 0 (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException greaterThanZeroOrMinusOne(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229042: {}  must be equals to -1 or greater or equals to 0 (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_greaterThanZeroOrMinusOne = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_greaterThanZeroOrMinusOne);
         return objReturn_greaterThanZeroOrMinusOne;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229043, value=\"{} must be between {} and {} inclusive (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException mustbeBetween(java.lang.String name, java.lang.Integer minPriority, java.lang.Integer maxPriority, java.lang.Object value) {
      String returnString = MessageFormatter.arrayFormat("AMQ229043: {} must be between {} and {} inclusive (actual value: {})", new Object[]{name, minPriority, maxPriority, value}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_mustbeBetween = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_mustbeBetween);
         return objReturn_mustbeBetween;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229044, value=\"Invalid journal type {}\")
   @Override
   public java.lang.IllegalArgumentException invalidJournalType(java.lang.String val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229044: Invalid journal type {}", new Object[]{val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidJournalType = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidJournalType);
         return objReturn_invalidJournalType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229045, value=\"Invalid address full message policy type {}\")
   @Override
   public java.lang.IllegalArgumentException invalidAddressFullPolicyType(java.lang.String val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229045: Invalid address full message policy type {}", new Object[]{val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidAddressFullPolicyType = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidAddressFullPolicyType);
         return objReturn_invalidAddressFullPolicyType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229046, value=\"invalid value: {} count must be greater than 0\")
   @Override
   public java.lang.IllegalArgumentException greaterThanZero(java.lang.Integer count) {
      String returnString = MessageFormatter.arrayFormat("AMQ229046: invalid value: {} count must be greater than 0", new Object[]{count}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_greaterThanZero = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_greaterThanZero);
         return objReturn_greaterThanZero;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229047, value=\"invalid value: {} sample period must be greater than 0\")
   @Override
   public java.lang.IllegalArgumentException periodMustGreaterThanZero(java.lang.Long newPeriod) {
      String returnString = MessageFormatter.arrayFormat("AMQ229047: invalid value: {} sample period must be greater than 0", new Object[]{newPeriod}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_periodMustGreaterThanZero = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_periodMustGreaterThanZero);
         return objReturn_periodMustGreaterThanZero;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229048, value=\"invalid new Priority value: {}. It must be between 0 and 9 (both included)\")
   @Override
   public java.lang.IllegalArgumentException invalidNewPriority(java.lang.Integer period) {
      String returnString = MessageFormatter.arrayFormat("AMQ229048: invalid new Priority value: {}. It must be between 0 and 9 (both included)", new Object[]{period}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidNewPriority = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidNewPriority);
         return objReturn_invalidNewPriority;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229049, value=\"No queue found for {}\")
   @Override
   public java.lang.IllegalArgumentException noQueueFound(java.lang.String otherQueueName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229049: No queue found for {}", new Object[]{otherQueueName}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_noQueueFound = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_noQueueFound);
         return objReturn_noQueueFound;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229050, value=\"Only NIO and AsyncIO are supported journals\")
   @Override
   public java.lang.IllegalArgumentException invalidJournal() {
      String returnString = "AMQ229050: Only NIO and AsyncIO are supported journals";

      {
         java.lang.IllegalArgumentException objReturn_invalidJournal = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidJournal);
         return objReturn_invalidJournal;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229051, value=\"Invalid journal type {}\")
   @Override
   public java.lang.IllegalArgumentException invalidJournalType2(org.apache.activemq.artemis.core.server.JournalType journalType) {
      String returnString = MessageFormatter.arrayFormat("AMQ229051: Invalid journal type {}", new Object[]{journalType}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidJournalType2 = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidJournalType2);
         return objReturn_invalidJournalType2;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229052, value=\"Directory {} does not exist and cannot be created\")
   @Override
   public java.lang.IllegalArgumentException cannotCreateDir(java.lang.String dir) {
      String returnString = MessageFormatter.arrayFormat("AMQ229052: Directory {} does not exist and cannot be created", new Object[]{dir}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_cannotCreateDir = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotCreateDir);
         return objReturn_cannotCreateDir;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229054, value=\"Cannot convert to int\")
   @Override
   public java.lang.IllegalArgumentException cannotConvertToInt() {
      String returnString = "AMQ229054: Cannot convert to int";

      {
         java.lang.IllegalArgumentException objReturn_cannotConvertToInt = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotConvertToInt);
         return objReturn_cannotConvertToInt;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229055, value=\"Routing name is null\")
   @Override
   public java.lang.IllegalArgumentException routeNameIsNull() {
      String returnString = "AMQ229055: Routing name is null";

      {
         java.lang.IllegalArgumentException objReturn_routeNameIsNull = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_routeNameIsNull);
         return objReturn_routeNameIsNull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229056, value=\"Cluster name is null\")
   @Override
   public java.lang.IllegalArgumentException clusterNameIsNull() {
      String returnString = "AMQ229056: Cluster name is null";

      {
         java.lang.IllegalArgumentException objReturn_clusterNameIsNull = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_clusterNameIsNull);
         return objReturn_clusterNameIsNull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229057, value=\"Address is null\")
   @Override
   public java.lang.IllegalArgumentException addressIsNull() {
      String returnString = "AMQ229057: Address is null";

      {
         java.lang.IllegalArgumentException objReturn_addressIsNull = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_addressIsNull);
         return objReturn_addressIsNull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229058, value=\"Binding type not specified\")
   @Override
   public java.lang.IllegalArgumentException bindingTypeNotSpecified() {
      String returnString = "AMQ229058: Binding type not specified";

      {
         java.lang.IllegalArgumentException objReturn_bindingTypeNotSpecified = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_bindingTypeNotSpecified);
         return objReturn_bindingTypeNotSpecified;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229059, value=\"Binding ID is null\")
   @Override
   public java.lang.IllegalArgumentException bindingIdNotSpecified() {
      String returnString = "AMQ229059: Binding ID is null";

      {
         java.lang.IllegalArgumentException objReturn_bindingIdNotSpecified = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_bindingIdNotSpecified);
         return objReturn_bindingIdNotSpecified;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229061, value=\"Connection already exists with id {}\")
   @Override
   public java.lang.IllegalArgumentException connectionExists(java.lang.Object id) {
      String returnString = MessageFormatter.arrayFormat("AMQ229061: Connection already exists with id {}", new Object[]{id}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_connectionExists = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_connectionExists);
         return objReturn_connectionExists;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229062, value=\"Acceptor with id {} already registered\")
   @Override
   public java.lang.IllegalArgumentException acceptorExists(java.lang.Integer id) {
      String returnString = MessageFormatter.arrayFormat("AMQ229062: Acceptor with id {} already registered", new Object[]{id}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_acceptorExists = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_acceptorExists);
         return objReturn_acceptorExists;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229063, value=\"Acceptor with id {} not registered\")
   @Override
   public java.lang.IllegalArgumentException acceptorNotExists(java.lang.Integer id) {
      String returnString = MessageFormatter.arrayFormat("AMQ229063: Acceptor with id {} not registered", new Object[]{id}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_acceptorNotExists = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_acceptorNotExists);
         return objReturn_acceptorNotExists;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229065, value=\"node id is null\")
   @Override
   public java.lang.IllegalArgumentException nodeIdNull() {
      String returnString = "AMQ229065: node id is null";

      {
         java.lang.IllegalArgumentException objReturn_nodeIdNull = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_nodeIdNull);
         return objReturn_nodeIdNull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229066, value=\"Queue name is null\")
   @Override
   public java.lang.IllegalArgumentException queueNameIsNull() {
      String returnString = "AMQ229066: Queue name is null";

      {
         java.lang.IllegalArgumentException objReturn_queueNameIsNull = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_queueNameIsNull);
         return objReturn_queueNameIsNull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229067, value=\"Cannot find resource with name {}\")
   @Override
   public java.lang.IllegalArgumentException cannotFindResource(java.lang.String resourceName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229067: Cannot find resource with name {}", new Object[]{resourceName}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_cannotFindResource = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotFindResource);
         return objReturn_cannotFindResource;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229068, value=\"no getter method for {}\")
   @Override
   public java.lang.IllegalArgumentException noGetterMethod(java.lang.String resourceName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229068: no getter method for {}", new Object[]{resourceName}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_noGetterMethod = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_noGetterMethod);
         return objReturn_noGetterMethod;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229069, value=\"no operation {}/{}\")
   @Override
   public java.lang.IllegalArgumentException noOperation(java.lang.String operation, java.lang.Integer length) {
      String returnString = MessageFormatter.arrayFormat("AMQ229069: no operation {}/{}", new Object[]{operation, length}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_noOperation = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_noOperation);
         return objReturn_noOperation;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229070, value=\"match can not be null\")
   @Override
   public java.lang.IllegalArgumentException nullMatch() {
      String returnString = "AMQ229070: match can not be null";

      {
         java.lang.IllegalArgumentException objReturn_nullMatch = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_nullMatch);
         return objReturn_nullMatch;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229071, value=\"# can only be at end of match\")
   @Override
   public java.lang.IllegalArgumentException invalidMatch() {
      String returnString = "AMQ229071: # can only be at end of match";

      {
         java.lang.IllegalArgumentException objReturn_invalidMatch = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidMatch);
         return objReturn_invalidMatch;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229072, value=\"User cannot be null\")
   @Override
   public java.lang.IllegalArgumentException nullUser() {
      String returnString = "AMQ229072: User cannot be null";

      {
         java.lang.IllegalArgumentException objReturn_nullUser = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_nullUser);
         return objReturn_nullUser;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229073, value=\"Password cannot be null\")
   @Override
   public java.lang.IllegalArgumentException nullPassword() {
      String returnString = "AMQ229073: Password cannot be null";

      {
         java.lang.IllegalArgumentException objReturn_nullPassword = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_nullPassword);
         return objReturn_nullPassword;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229074, value=\"Error instantiating transformer class {}\")
   @Override
   public java.lang.IllegalArgumentException errorCreatingTransformerClass(java.lang.String transformerClassName, java.lang.Exception e) {
      String returnString = MessageFormatter.arrayFormat("AMQ229074: Error instantiating transformer class {}", new Object[]{transformerClassName, e}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_errorCreatingTransformerClass = new java.lang.IllegalArgumentException(returnString);
         objReturn_errorCreatingTransformerClass.initCause(e);
         _copyStackTraceMinusOne(objReturn_errorCreatingTransformerClass);
         return objReturn_errorCreatingTransformerClass;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229076, value=\"Executing destroyConnection with {}={} through management\'s request\")
   @Override
   public java.lang.String destroyConnectionWithSessionMetadataHeader(java.lang.String key, java.lang.String value) {
      String returnString = MessageFormatter.arrayFormat("AMQ229076: Executing destroyConnection with {}={} through management's request", new Object[]{key, value}).getMessage();
      return returnString;
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229077, value=\"Closing connection {}\")
   @Override
   public java.lang.String destroyConnectionWithSessionMetadataClosingConnection(java.lang.String serverSessionString) {
      String returnString = MessageFormatter.arrayFormat("AMQ229077: Closing connection {}", new Object[]{serverSessionString}).getMessage();
      return returnString;
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229078, value=\"Disconnected per admin\'s request on {}={}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException destroyConnectionWithSessionMetadataSendException(java.lang.String key, java.lang.String value) {
      String returnString = MessageFormatter.arrayFormat("AMQ229078: Disconnected per admin's request on {}={}", new Object[]{key, value}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException objReturn_destroyConnectionWithSessionMetadataSendException = new org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException(returnString);
         _copyStackTraceMinusOne(objReturn_destroyConnectionWithSessionMetadataSendException);
         return objReturn_destroyConnectionWithSessionMetadataSendException;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229079, value=\"No session found with {}={}\")
   @Override
   public java.lang.String destroyConnectionWithSessionMetadataNoSessionFound(java.lang.String key, java.lang.String value) {
      String returnString = MessageFormatter.arrayFormat("AMQ229079: No session found with {}={}", new Object[]{key, value}).getMessage();
      return returnString;
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229080, value=\"Invalid Page IO, PagingManager was stopped or closed\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException invalidPageIO() {
      String returnString = "AMQ229080: Invalid Page IO, PagingManager was stopped or closed";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_invalidPageIO = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidPageIO);
         return objReturn_invalidPageIO;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229081, value=\"No Discovery Group configuration named {} found\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQException noDiscoveryGroupFound(org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration dg) {
      String returnString = MessageFormatter.arrayFormat("AMQ229081: No Discovery Group configuration named {} found", new Object[]{dg}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQException objReturn_noDiscoveryGroupFound = new org.apache.activemq.artemis.api.core.ActiveMQException(returnString);
         _copyStackTraceMinusOne(objReturn_noDiscoveryGroupFound);
         return objReturn_noDiscoveryGroupFound;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229082, value=\"Queue {} already exists on another subscription\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentAddress(org.apache.activemq.artemis.api.core.SimpleString queueName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229082: Queue {} already exists on another subscription", new Object[]{queueName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException objReturn_queueSubscriptionBelongsToDifferentAddress = new org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException(returnString);
         _copyStackTraceMinusOne(objReturn_queueSubscriptionBelongsToDifferentAddress);
         return objReturn_queueSubscriptionBelongsToDifferentAddress;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229083, value=\"Queue {} has a different filter than requested\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentFilter(org.apache.activemq.artemis.api.core.SimpleString queueName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229083: Queue {} has a different filter than requested", new Object[]{queueName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException objReturn_queueSubscriptionBelongsToDifferentFilter = new org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException(returnString);
         _copyStackTraceMinusOne(objReturn_queueSubscriptionBelongsToDifferentFilter);
         return objReturn_queueSubscriptionBelongsToDifferentFilter;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229099, value=\"Unable to authenticate cluster user: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException unableToValidateClusterUser(java.lang.String user) {
      String returnString = MessageFormatter.arrayFormat("AMQ229099: Unable to authenticate cluster user: {}", new Object[]{user}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException objReturn_unableToValidateClusterUser = new org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException(returnString);
         _copyStackTraceMinusOne(objReturn_unableToValidateClusterUser);
         return objReturn_unableToValidateClusterUser;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229102, value=\"Address \\"{}\\" is full.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQAddressFullException addressIsFull(java.lang.String addressName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229102: Address \"{}\" is full.", new Object[]{addressName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQAddressFullException objReturn_addressIsFull = new org.apache.activemq.artemis.api.core.ActiveMQAddressFullException(returnString);
         _copyStackTraceMinusOne(objReturn_addressIsFull);
         return objReturn_addressIsFull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229103, value=\"No Connectors or Discovery Groups configured for Scale Down\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQException noConfigurationFoundForScaleDown() {
      String returnString = "AMQ229103: No Connectors or Discovery Groups configured for Scale Down";

      {
         org.apache.activemq.artemis.api.core.ActiveMQException objReturn_noConfigurationFoundForScaleDown = new org.apache.activemq.artemis.api.core.ActiveMQException(returnString);
         _copyStackTraceMinusOne(objReturn_noConfigurationFoundForScaleDown);
         return objReturn_noConfigurationFoundForScaleDown;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229104, value=\"Server is stopping. Message grouping not allowed\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQException groupWhileStopping() {
      String returnString = "AMQ229104: Server is stopping. Message grouping not allowed";

      {
         org.apache.activemq.artemis.api.core.ActiveMQException objReturn_groupWhileStopping = new org.apache.activemq.artemis.api.core.ActiveMQException(returnString);
         _copyStackTraceMinusOne(objReturn_groupWhileStopping);
         return objReturn_groupWhileStopping;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229106, value=\"Invalid slow consumer policy type {}\")
   @Override
   public java.lang.IllegalArgumentException invalidSlowConsumerPolicyType(java.lang.String val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229106: Invalid slow consumer policy type {}", new Object[]{val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidSlowConsumerPolicyType = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidSlowConsumerPolicyType);
         return objReturn_invalidSlowConsumerPolicyType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229107, value=\"consumer connections for address {} closed by management\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException consumerConnectionsClosedByManagement(java.lang.String address) {
      String returnString = MessageFormatter.arrayFormat("AMQ229107: consumer connections for address {} closed by management", new Object[]{address}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_consumerConnectionsClosedByManagement = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_consumerConnectionsClosedByManagement);
         return objReturn_consumerConnectionsClosedByManagement;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229108, value=\"connections for user {} closed by management\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException connectionsForUserClosedByManagement(java.lang.String userName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229108: connections for user {} closed by management", new Object[]{userName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_connectionsForUserClosedByManagement = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_connectionsForUserClosedByManagement);
         return objReturn_connectionsForUserClosedByManagement;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229109, value=\"unsupported HA Policy Configuration {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException unsupportedHAPolicyConfiguration(java.lang.Object o) {
      String returnString = MessageFormatter.arrayFormat("AMQ229109: unsupported HA Policy Configuration {}", new Object[]{o}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_unsupportedHAPolicyConfiguration = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_unsupportedHAPolicyConfiguration);
         return objReturn_unsupportedHAPolicyConfiguration;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229110, value=\"Too many sessions for user \'{}\'. Sessions allowed: {}.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException sessionLimitReached(java.lang.String username, int limit) {
      String returnString = MessageFormatter.arrayFormat("AMQ229110: Too many sessions for user '{}'. Sessions allowed: {}.", new Object[]{username, limit}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException objReturn_sessionLimitReached = new org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException(returnString);
         _copyStackTraceMinusOne(objReturn_sessionLimitReached);
         return objReturn_sessionLimitReached;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229111, value=\"Too many queues created by user \'{}\'. Queues allowed: {}.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQSecurityException queueLimitReached(java.lang.String username, int limit) {
      String returnString = MessageFormatter.arrayFormat("AMQ229111: Too many queues created by user '{}'. Queues allowed: {}.", new Object[]{username, limit}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQSecurityException objReturn_queueLimitReached = new org.apache.activemq.artemis.api.core.ActiveMQSecurityException(returnString);
         _copyStackTraceMinusOne(objReturn_queueLimitReached);
         return objReturn_queueLimitReached;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229112, value=\"Cannot set MBeanServer during startup or while started\")
   @Override
   public java.lang.IllegalStateException cannotSetMBeanserver() {
      String returnString = "AMQ229112: Cannot set MBeanServer during startup or while started";

      {
         java.lang.IllegalStateException objReturn_cannotSetMBeanserver = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotSetMBeanserver);
         return objReturn_cannotSetMBeanserver;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229113, value=\"Invalid message load balancing type {}\")
   @Override
   public java.lang.IllegalArgumentException invalidMessageLoadBalancingType(java.lang.String val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229113: Invalid message load balancing type {}", new Object[]{val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidMessageLoadBalancingType = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidMessageLoadBalancingType);
         return objReturn_invalidMessageLoadBalancingType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229114, value=\"Replication synchronization process timed out after waiting {} milliseconds\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQReplicationTimeooutException replicationSynchronizationTimeout(long timeout) {
      String returnString = MessageFormatter.arrayFormat("AMQ229114: Replication synchronization process timed out after waiting {} milliseconds", new Object[]{timeout}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQReplicationTimeooutException objReturn_replicationSynchronizationTimeout = new org.apache.activemq.artemis.api.core.ActiveMQReplicationTimeooutException(returnString);
         _copyStackTraceMinusOne(objReturn_replicationSynchronizationTimeout);
         return objReturn_replicationSynchronizationTimeout;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229115, value=\"Colocated Policy hasn\'t different type primary and backup\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException primaryBackupMismatch() {
      String returnString = "AMQ229115: Colocated Policy hasn't different type primary and backup";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_primaryBackupMismatch = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_primaryBackupMismatch);
         return objReturn_primaryBackupMismatch;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229116, value=\"Netty Acceptor unavailable\")
   @Override
   public java.lang.IllegalStateException acceptorUnavailable() {
      String returnString = "AMQ229116: Netty Acceptor unavailable";

      {
         java.lang.IllegalStateException objReturn_acceptorUnavailable = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_acceptorUnavailable);
         return objReturn_acceptorUnavailable;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229117, value=\"Replicator is null. Replication was likely terminated.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException replicatorIsNull() {
      String returnString = "AMQ229117: Replicator is null. Replication was likely terminated.";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_replicatorIsNull = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_replicatorIsNull);
         return objReturn_replicatorIsNull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229119, value=\"Free storage space is at {} of {} total. Usage rate is {} which is beyond the configured <max-disk-usage>. System will start blocking producers.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIOErrorException diskBeyondLimit(java.lang.String usableSpace, java.lang.String totalSpace, java.lang.String usage) {
      String returnString = MessageFormatter.arrayFormat("AMQ229119: Free storage space is at {} of {} total. Usage rate is {} which is beyond the configured <max-disk-usage>. System will start blocking producers.", new Object[]{usableSpace, totalSpace, usage}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIOErrorException objReturn_diskBeyondLimit = new org.apache.activemq.artemis.api.core.ActiveMQIOErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_diskBeyondLimit);
         return objReturn_diskBeyondLimit;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229120, value=\"connection with ID {} closed by management\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException connectionWithIDClosedByManagement(java.lang.String ID) {
      String returnString = MessageFormatter.arrayFormat("AMQ229120: connection with ID {} closed by management", new Object[]{ID}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException objReturn_connectionWithIDClosedByManagement = new org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_connectionWithIDClosedByManagement);
         return objReturn_connectionWithIDClosedByManagement;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229200, value=\"Maximum Consumer Limit Reached on Queue:(address={},queue={})\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached maxConsumerLimitReachedForQueue(org.apache.activemq.artemis.api.core.SimpleString address, org.apache.activemq.artemis.api.core.SimpleString queueName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229200: Maximum Consumer Limit Reached on Queue:(address={},queue={})", new Object[]{address, queueName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached objReturn_maxConsumerLimitReachedForQueue = new org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached(returnString);
         _copyStackTraceMinusOne(objReturn_maxConsumerLimitReachedForQueue);
         return objReturn_maxConsumerLimitReachedForQueue;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229203, value=\"Address Does Not Exist: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException addressDoesNotExist(org.apache.activemq.artemis.api.core.SimpleString address) {
      String returnString = MessageFormatter.arrayFormat("AMQ229203: Address Does Not Exist: {}", new Object[]{address}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException objReturn_addressDoesNotExist = new org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException(returnString);
         _copyStackTraceMinusOne(objReturn_addressDoesNotExist);
         return objReturn_addressDoesNotExist;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229204, value=\"Address already exists: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException addressAlreadyExists(org.apache.activemq.artemis.api.core.SimpleString address) {
      String returnString = MessageFormatter.arrayFormat("AMQ229204: Address already exists: {}", new Object[]{address}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException objReturn_addressAlreadyExists = new org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException(returnString);
         _copyStackTraceMinusOne(objReturn_addressAlreadyExists);
         return objReturn_addressAlreadyExists;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229205, value=\"Address {} has bindings\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException addressHasBindings(org.apache.activemq.artemis.api.core.SimpleString address) {
      String returnString = MessageFormatter.arrayFormat("AMQ229205: Address {} has bindings", new Object[]{address}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException objReturn_addressHasBindings = new org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException(returnString);
         _copyStackTraceMinusOne(objReturn_addressHasBindings);
         return objReturn_addressHasBindings;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229206, value=\"Queue {} has invalid max consumer setting: {}\")
   @Override
   public java.lang.IllegalArgumentException invalidMaxConsumers(java.lang.String queueName, int value) {
      String returnString = MessageFormatter.arrayFormat("AMQ229206: Queue {} has invalid max consumer setting: {}", new Object[]{queueName, value}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidMaxConsumers = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidMaxConsumers);
         return objReturn_invalidMaxConsumers;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229207, value=\"Can not create queue with routing type: {}, Supported routing types for address: {} are {}\")
   @Override
   public java.lang.IllegalArgumentException invalidRoutingTypeForAddress(org.apache.activemq.artemis.api.core.RoutingType routingType, java.lang.String address, java.util.Set<org.apache.activemq.artemis.api.core.RoutingType> supportedRoutingTypes) {
      String returnString = MessageFormatter.arrayFormat("AMQ229207: Can not create queue with routing type: {}, Supported routing types for address: {} are {}", new Object[]{routingType, address, supportedRoutingTypes}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidRoutingTypeForAddress = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidRoutingTypeForAddress);
         return objReturn_invalidRoutingTypeForAddress;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229208, value=\"Invalid routing type {}\")
   @Override
   public java.lang.IllegalArgumentException invalidRoutingType(java.lang.String val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229208: Invalid routing type {}", new Object[]{val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidRoutingType = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidRoutingType);
         return objReturn_invalidRoutingType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229209, value=\"Can\'t remove routing type {}, queues exists for address: {}. Please delete queues before removing this routing type.\")
   @Override
   public java.lang.IllegalStateException invalidRoutingTypeDelete(org.apache.activemq.artemis.api.core.RoutingType routingType, java.lang.String address) {
      String returnString = MessageFormatter.arrayFormat("AMQ229209: Can't remove routing type {}, queues exists for address: {}. Please delete queues before removing this routing type.", new Object[]{routingType, address}).getMessage();

      {
         java.lang.IllegalStateException objReturn_invalidRoutingTypeDelete = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidRoutingTypeDelete);
         return objReturn_invalidRoutingTypeDelete;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229210, value=\"Can\'t update queue {} with maxConsumers: {}. Current consumers are {}.\")
   @Override
   public java.lang.IllegalStateException invalidMaxConsumersUpdate(java.lang.String queueName, int maxConsumers, int consumers) {
      String returnString = MessageFormatter.arrayFormat("AMQ229210: Can't update queue {} with maxConsumers: {}. Current consumers are {}.", new Object[]{queueName, maxConsumers, consumers}).getMessage();

      {
         java.lang.IllegalStateException objReturn_invalidMaxConsumersUpdate = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidMaxConsumersUpdate);
         return objReturn_invalidMaxConsumersUpdate;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229211, value=\"Can\'t update queue {} with routing type: {}, Supported routing types for address: {} are {}\")
   @Override
   public java.lang.IllegalStateException invalidRoutingTypeUpdate(java.lang.String queueName, org.apache.activemq.artemis.api.core.RoutingType routingType, java.lang.String address, java.util.Set<org.apache.activemq.artemis.api.core.RoutingType> supportedRoutingTypes) {
      String returnString = MessageFormatter.arrayFormat("AMQ229211: Can't update queue {} with routing type: {}, Supported routing types for address: {} are {}", new Object[]{queueName, routingType, address, supportedRoutingTypes}).getMessage();

      {
         java.lang.IllegalStateException objReturn_invalidRoutingTypeUpdate = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidRoutingTypeUpdate);
         return objReturn_invalidRoutingTypeUpdate;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229212, value=\"Invalid deletion policy type {}\")
   @Override
   public java.lang.IllegalArgumentException invalidDeletionPolicyType(java.lang.String val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229212: Invalid deletion policy type {}", new Object[]{val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidDeletionPolicyType = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidDeletionPolicyType);
         return objReturn_invalidDeletionPolicyType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229213, value=\"User: {} does not have permission=\'{}\' for queue {} on address {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQSecurityException userNoPermissionsQueue(java.lang.String username, org.apache.activemq.artemis.core.security.CheckType checkType, org.apache.activemq.artemis.api.core.SimpleString queue, org.apache.activemq.artemis.api.core.SimpleString address) {
      String returnString = MessageFormatter.arrayFormat("AMQ229213: User: {} does not have permission='{}' for queue {} on address {}", new Object[]{username, checkType, queue, address}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQSecurityException objReturn_userNoPermissionsQueue = new org.apache.activemq.artemis.api.core.ActiveMQSecurityException(returnString);
         _copyStackTraceMinusOne(objReturn_userNoPermissionsQueue);
         return objReturn_userNoPermissionsQueue;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229214, value=\"{} must be a valid percentage value between 0 and 100 or -1 (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException notPercentOrMinusOne(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229214: {} must be a valid percentage value between 0 and 100 or -1 (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_notPercentOrMinusOne = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_notPercentOrMinusOne);
         return objReturn_notPercentOrMinusOne;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229215, value=\"Cannot delete queue {} on binding {} - it has {} messages\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException cannotDeleteQueueWithMessages(org.apache.activemq.artemis.api.core.SimpleString name, org.apache.activemq.artemis.api.core.SimpleString queueName, long messageCount) {
      String returnString = MessageFormatter.arrayFormat("AMQ229215: Cannot delete queue {} on binding {} - it has {} messages", new Object[]{name, queueName, messageCount}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_cannotDeleteQueueWithMessages = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotDeleteQueueWithMessages);
         return objReturn_cannotDeleteQueueWithMessages;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229216, value=\"Invalid queue name: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException invalidQueueName(org.apache.activemq.artemis.api.core.SimpleString queueName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229216: Invalid queue name: {}", new Object[]{queueName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_invalidQueueName = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidQueueName);
         return objReturn_invalidQueueName;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229217, value=\"Cannot write to closed file: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIOErrorException cannotWriteToClosedFile(org.apache.activemq.artemis.core.io.SequentialFile file) {
      String returnString = MessageFormatter.arrayFormat("AMQ229217: Cannot write to closed file: {}", new Object[]{file}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIOErrorException objReturn_cannotWriteToClosedFile = new org.apache.activemq.artemis.api.core.ActiveMQIOErrorException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotWriteToClosedFile);
         return objReturn_cannotWriteToClosedFile;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229218, value=\"Failed to locate broker configuration URL\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException failedToLocateConfigURL() {
      String returnString = "AMQ229218: Failed to locate broker configuration URL";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_failedToLocateConfigURL = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_failedToLocateConfigURL);
         return objReturn_failedToLocateConfigURL;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229219, value=\"Failed to load security configuration\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException failedToLoadSecurityConfig() {
      String returnString = "AMQ229219: Failed to load security configuration";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_failedToLoadSecurityConfig = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_failedToLoadSecurityConfig);
         return objReturn_failedToLoadSecurityConfig;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229220, value=\"Failed to load user file: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException failedToLoadUserFile(java.lang.String path) {
      String returnString = MessageFormatter.arrayFormat("AMQ229220: Failed to load user file: {}", new Object[]{path}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_failedToLoadUserFile = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_failedToLoadUserFile);
         return objReturn_failedToLoadUserFile;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229221, value=\"Failed to load role file: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException failedToLoadRoleFile(java.lang.String path) {
      String returnString = MessageFormatter.arrayFormat("AMQ229221: Failed to load role file: {}", new Object[]{path}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_failedToLoadRoleFile = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_failedToLoadRoleFile);
         return objReturn_failedToLoadRoleFile;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229222, value=\"Failed to find login module entry {} from JAAS configuration\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException failedToFindLoginModuleEntry(java.lang.String entry) {
      String returnString = MessageFormatter.arrayFormat("AMQ229222: Failed to find login module entry {} from JAAS configuration", new Object[]{entry}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_failedToFindLoginModuleEntry = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_failedToFindLoginModuleEntry);
         return objReturn_failedToFindLoginModuleEntry;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229223, value=\"User {} already exists\")
   @Override
   public java.lang.IllegalArgumentException userAlreadyExists(java.lang.String user) {
      String returnString = MessageFormatter.arrayFormat("AMQ229223: User {} already exists", new Object[]{user}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_userAlreadyExists = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_userAlreadyExists);
         return objReturn_userAlreadyExists;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229224, value=\"User {} does not exist\")
   @Override
   public java.lang.IllegalArgumentException userDoesNotExist(java.lang.String user) {
      String returnString = MessageFormatter.arrayFormat("AMQ229224: User {} does not exist", new Object[]{user}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_userDoesNotExist = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_userDoesNotExist);
         return objReturn_userDoesNotExist;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229225, value=\"Validated User is not set\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException rejectEmptyValidatedUser() {
      String returnString = "AMQ229225: Validated User is not set";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_rejectEmptyValidatedUser = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_rejectEmptyValidatedUser);
         return objReturn_rejectEmptyValidatedUser;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229226, value=\"{}  must be greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException inRangeOfPositiveInt(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229226: {}  must be greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_inRangeOfPositiveInt = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_inRangeOfPositiveInt);
         return objReturn_inRangeOfPositiveInt;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229227, value=\"{}  must be equals to -1 or greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException inRangeOfPositiveIntThanMinusOne(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229227: {}  must be equals to -1 or greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_inRangeOfPositiveIntThanMinusOne = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_inRangeOfPositiveIntThanMinusOne);
         return objReturn_inRangeOfPositiveIntThanMinusOne;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229228, value=\"{} must be less than or equal to 1 (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException lessThanOrEqualToOne(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229228: {} must be less than or equal to 1 (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_lessThanOrEqualToOne = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_lessThanOrEqualToOne);
         return objReturn_lessThanOrEqualToOne;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229229, value=\"Failed to parse JSON queue configuration: {}\")
   @Override
   public java.lang.IllegalArgumentException failedToParseJson(java.lang.String json) {
      String returnString = MessageFormatter.arrayFormat("AMQ229229: Failed to parse JSON queue configuration: {}", new Object[]{json}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_failedToParseJson = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_failedToParseJson);
         return objReturn_failedToParseJson;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229230, value=\"Failed to bind acceptor {} to {}\")
   @Override
   public java.lang.IllegalStateException failedToBind(java.lang.String acceptor, java.lang.String hostPort, java.lang.Exception e) {
      String returnString = MessageFormatter.arrayFormat("AMQ229230: Failed to bind acceptor {} to {}", new Object[]{acceptor, hostPort, e}).getMessage();

      {
         java.lang.IllegalStateException objReturn_failedToBind = new java.lang.IllegalStateException(returnString);
         objReturn_failedToBind.initCause(e);
         _copyStackTraceMinusOne(objReturn_failedToBind);
         return objReturn_failedToBind;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229231, value=\"Divert Does Not Exist: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQDivertDoesNotExistException divertDoesNotExist(java.lang.String divert) {
      String returnString = MessageFormatter.arrayFormat("AMQ229231: Divert Does Not Exist: {}", new Object[]{divert}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQDivertDoesNotExistException objReturn_divertDoesNotExist = new org.apache.activemq.artemis.api.core.ActiveMQDivertDoesNotExistException(returnString);
         _copyStackTraceMinusOne(objReturn_divertDoesNotExist);
         return objReturn_divertDoesNotExist;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229232, value=\"Cannot create consumer on {}. Session is closed.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException cannotCreateConsumerOnClosedSession(org.apache.activemq.artemis.api.core.SimpleString queueName) {
      String returnString = MessageFormatter.arrayFormat("AMQ229232: Cannot create consumer on {}. Session is closed.", new Object[]{queueName}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_cannotCreateConsumerOnClosedSession = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotCreateConsumerOnClosedSession);
         return objReturn_cannotCreateConsumerOnClosedSession;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229233, value=\"Cannot set ActiveMQSecurityManager during startup or while started\")
   @Override
   public java.lang.IllegalStateException cannotSetSecurityManager() {
      String returnString = "AMQ229233: Cannot set ActiveMQSecurityManager during startup or while started";

      {
         java.lang.IllegalStateException objReturn_cannotSetSecurityManager = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_cannotSetSecurityManager);
         return objReturn_cannotSetSecurityManager;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229234, value=\"Invalid slow consumer threshold measurement unit {}\")
   @Override
   public java.lang.IllegalArgumentException invalidSlowConsumerThresholdMeasurementUnit(java.lang.String val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229234: Invalid slow consumer threshold measurement unit {}", new Object[]{val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidSlowConsumerThresholdMeasurementUnit = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidSlowConsumerThresholdMeasurementUnit);
         return objReturn_invalidSlowConsumerThresholdMeasurementUnit;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229235, value=\"Incompatible binding with name {} already exists: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException bindingAlreadyExists(java.lang.String name, java.lang.String binding) {
      String returnString = MessageFormatter.arrayFormat("AMQ229235: Incompatible binding with name {} already exists: {}", new Object[]{name, binding}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_bindingAlreadyExists = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_bindingAlreadyExists);
         return objReturn_bindingAlreadyExists;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229236, value=\"Invalid connection router key {}\")
   @Override
   public java.lang.IllegalArgumentException invalidConnectionRouterKey(java.lang.String val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229236: Invalid connection router key {}", new Object[]{val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_invalidConnectionRouterKey = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidConnectionRouterKey);
         return objReturn_invalidConnectionRouterKey;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229237, value=\"Connection router {} redirected the connection to {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQRoutingException connectionRedirected(java.lang.String connectionRouter, org.apache.activemq.artemis.api.core.TransportConfiguration connector) {
      String returnString = MessageFormatter.arrayFormat("AMQ229237: Connection router {} redirected the connection to {}", new Object[]{connectionRouter, connector}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQRoutingException objReturn_connectionRedirected = new org.apache.activemq.artemis.api.core.ActiveMQRoutingException(returnString);
         _copyStackTraceMinusOne(objReturn_connectionRedirected);
         return objReturn_connectionRedirected;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229238, value=\"Connection router {} not ready\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQRoutingException connectionRouterNotReady(java.lang.String connectionRouter) {
      String returnString = MessageFormatter.arrayFormat("AMQ229238: Connection router {} not ready", new Object[]{connectionRouter}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQRoutingException objReturn_connectionRouterNotReady = new org.apache.activemq.artemis.api.core.ActiveMQRoutingException(returnString);
         _copyStackTraceMinusOne(objReturn_connectionRouterNotReady);
         return objReturn_connectionRouterNotReady;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229239, value=\"There is no retention configured. In order to use the replay method you must specify journal-retention-directory element on the broker.xml\")
   @Override
   public java.lang.IllegalArgumentException noRetention() {
      String returnString = "AMQ229239: There is no retention configured. In order to use the replay method you must specify journal-retention-directory element on the broker.xml";

      {
         java.lang.IllegalArgumentException objReturn_noRetention = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_noRetention);
         return objReturn_noRetention;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229240, value=\"Connection router {} rejected the connection\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException connectionRejected(java.lang.String connectionRouter) {
      String returnString = MessageFormatter.arrayFormat("AMQ229240: Connection router {} rejected the connection", new Object[]{connectionRouter}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException objReturn_connectionRejected = new org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException(returnString);
         _copyStackTraceMinusOne(objReturn_connectionRejected);
         return objReturn_connectionRejected;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229241, value=\"Embedded web server not found\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException embeddedWebServerNotFound() {
      String returnString = "AMQ229241: Embedded web server not found";

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_embeddedWebServerNotFound = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_embeddedWebServerNotFound);
         return objReturn_embeddedWebServerNotFound;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229242, value=\"Embedded web server not restarted in {} milliseconds\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQTimeoutException embeddedWebServerRestartTimeout(long timeout) {
      String returnString = MessageFormatter.arrayFormat("AMQ229242: Embedded web server not restarted in {} milliseconds", new Object[]{timeout}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQTimeoutException objReturn_embeddedWebServerRestartTimeout = new org.apache.activemq.artemis.api.core.ActiveMQTimeoutException(returnString);
         _copyStackTraceMinusOne(objReturn_embeddedWebServerRestartTimeout);
         return objReturn_embeddedWebServerRestartTimeout;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229243, value=\"Embedded web server restart failed\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQException embeddedWebServerRestartFailed(java.lang.Exception e) {
      String returnString = MessageFormatter.arrayFormat("AMQ229243: Embedded web server restart failed", new Object[]{e}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQException objReturn_embeddedWebServerRestartFailed = new org.apache.activemq.artemis.api.core.ActiveMQException(returnString);
         objReturn_embeddedWebServerRestartFailed.initCause(e);
         _copyStackTraceMinusOne(objReturn_embeddedWebServerRestartFailed);
         return objReturn_embeddedWebServerRestartFailed;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229244, value=\"Meters already registered for {}\")
   @Override
   public java.lang.IllegalStateException metersAlreadyRegistered(java.lang.String resource) {
      String returnString = MessageFormatter.arrayFormat("AMQ229244: Meters already registered for {}", new Object[]{resource}).getMessage();

      {
         java.lang.IllegalStateException objReturn_metersAlreadyRegistered = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_metersAlreadyRegistered);
         return objReturn_metersAlreadyRegistered;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229245, value=\"Management controller is busy with another task. Please try again\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQTimeoutException managementBusy() {
      String returnString = "AMQ229245: Management controller is busy with another task. Please try again";

      {
         org.apache.activemq.artemis.api.core.ActiveMQTimeoutException objReturn_managementBusy = new org.apache.activemq.artemis.api.core.ActiveMQTimeoutException(returnString);
         _copyStackTraceMinusOne(objReturn_managementBusy);
         return objReturn_managementBusy;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229247, value=\"Invalid address configuration for \'{}\'. Address must support multicast and/or anycast.\")
   @Override
   public java.lang.IllegalArgumentException addressWithNoRoutingType(java.lang.String address) {
      String returnString = MessageFormatter.arrayFormat("AMQ229247: Invalid address configuration for '{}'. Address must support multicast and/or anycast.", new Object[]{address}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_addressWithNoRoutingType = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_addressWithNoRoutingType);
         return objReturn_addressWithNoRoutingType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229248, value=\"Invalid value for webSocketEncoderType: \'{}\'. Supported values: \'binary\', \'text\'.\")
   @Override
   public java.lang.IllegalStateException invalidWebSocketEncoderType(java.lang.String webSocketEncoderType) {
      String returnString = MessageFormatter.arrayFormat("AMQ229248: Invalid value for webSocketEncoderType: '{}'. Supported values: 'binary', 'text'.", new Object[]{webSocketEncoderType}).getMessage();

      {
         java.lang.IllegalStateException objReturn_invalidWebSocketEncoderType = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_invalidWebSocketEncoderType);
         return objReturn_invalidWebSocketEncoderType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229249, value=\"Invalid Store property, only DATABASE property is supported\")
   @Override
   public java.lang.RuntimeException unsupportedStorePropertyType() {
      String returnString = "AMQ229249: Invalid Store property, only DATABASE property is supported";

      {
         java.lang.RuntimeException objReturn_unsupportedStorePropertyType = new java.lang.RuntimeException(returnString);
         _copyStackTraceMinusOne(objReturn_unsupportedStorePropertyType);
         return objReturn_unsupportedStorePropertyType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229250, value=\"Connection has been marked as destroyed for remote connection {}.\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQException connectionDestroyed(java.lang.String remoteAddress) {
      String returnString = MessageFormatter.arrayFormat("AMQ229250: Connection has been marked as destroyed for remote connection {}.", new Object[]{remoteAddress}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQException objReturn_connectionDestroyed = new org.apache.activemq.artemis.api.core.ActiveMQException(returnString);
         _copyStackTraceMinusOne(objReturn_connectionDestroyed);
         return objReturn_connectionDestroyed;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229251, value=\"{} value \'{}\' is too long. It is {} characters but must be {} characters.\")
   @Override
   public java.lang.IllegalArgumentException wrongLength(java.lang.String name, java.lang.String val, int actualLength, int requiredLength) {
      String returnString = MessageFormatter.arrayFormat("AMQ229251: {} value '{}' is too long. It is {} characters but must be {} characters.", new Object[]{name, val, actualLength, requiredLength}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_wrongLength = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_wrongLength);
         return objReturn_wrongLength;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229252, value=\"Invalid HAPolicy property: {}\")
   @Override
   public java.lang.RuntimeException unsupportedHAPolicyPropertyType(java.lang.String invalidHAPolicy) {
      String returnString = MessageFormatter.arrayFormat("AMQ229252: Invalid HAPolicy property: {}", new Object[]{invalidHAPolicy}).getMessage();

      {
         java.lang.RuntimeException objReturn_unsupportedHAPolicyPropertyType = new java.lang.RuntimeException(returnString);
         _copyStackTraceMinusOne(objReturn_unsupportedHAPolicyPropertyType);
         return objReturn_unsupportedHAPolicyPropertyType;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229253, value=\"Unable to acquire OperationContext when replicating packet: {}. ExecutorFactory: {}\")
   @Override
   public java.lang.IllegalStateException replicationFailureRepliTokenNull(java.lang.String packet, java.lang.String executorFactory) {
      String returnString = MessageFormatter.arrayFormat("AMQ229253: Unable to acquire OperationContext when replicating packet: {}. ExecutorFactory: {}", new Object[]{packet, executorFactory}).getMessage();

      {
         java.lang.IllegalStateException objReturn_replicationFailureRepliTokenNull = new java.lang.IllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_replicationFailureRepliTokenNull);
         return objReturn_replicationFailureRepliTokenNull;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229254, value=\"Already replicating, started={}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException alreadyReplicating(boolean status) {
      String returnString = MessageFormatter.arrayFormat("AMQ229254: Already replicating, started={}", new Object[]{status}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_alreadyReplicating = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_alreadyReplicating);
         return objReturn_alreadyReplicating;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229255, value=\"Bridge {} cannot be {}. Current state: {}\")
   @Override
   public org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException bridgeOperationCannotBeExecuted(java.lang.String bridgeName, java.lang.String failedOp, org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl.State currentState) {
      String returnString = MessageFormatter.arrayFormat("AMQ229255: Bridge {} cannot be {}. Current state: {}", new Object[]{bridgeName, failedOp, currentState}).getMessage();

      {
         org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException objReturn_bridgeOperationCannotBeExecuted = new org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException(returnString);
         _copyStackTraceMinusOne(objReturn_bridgeOperationCannotBeExecuted);
         return objReturn_bridgeOperationCannotBeExecuted;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229256, value=\"{} must be a positive power of 2 (actual value: {})\")
   @Override
   public java.lang.IllegalArgumentException positivePowerOfTwo(java.lang.String name, java.lang.Number val) {
      String returnString = MessageFormatter.arrayFormat("AMQ229256: {} must be a positive power of 2 (actual value: {})", new Object[]{name, val}).getMessage();

      {
         java.lang.IllegalArgumentException objReturn_positivePowerOfTwo = new java.lang.IllegalArgumentException(returnString);
         _copyStackTraceMinusOne(objReturn_positivePowerOfTwo);
         return objReturn_positivePowerOfTwo;
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.Message(id=229257, value=\"IDGenerator has been stopped\")
   @Override
   public java.lang.RuntimeException idGeneratorStopped() {
      String returnString = "AMQ229257: IDGenerator has been stopped";

      {
         java.lang.RuntimeException objReturn_idGeneratorStopped = new java.lang.RuntimeException(returnString);
         _copyStackTraceMinusOne(objReturn_idGeneratorStopped);
         return objReturn_idGeneratorStopped;
      }
   }

}
