/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNullRefException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.QueueStatus;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ScheduledDeliveryHandler;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.Redistributor;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueuePendingMessageMetrics;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.impl.ScheduledDeliveryHandlerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.BindingsTransactionImpl;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedList;
import org.apache.activemq.artemis.utils.collections.PriorityLinkedListImpl;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponentImpl;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.jboss.logging.Logger;

public class QueueImpl
extends CriticalComponentImpl
implements Queue {
    protected static final int CRITICAL_PATHS = 4;
    protected static final int CRITICAL_PATH_ADD_TAIL = 0;
    protected static final int CRITICAL_PATH_ADD_HEAD = 1;
    protected static final int CRITICAL_DELIVER = 2;
    protected static final int CRITICAL_CONSUMER = 3;
    private static final Logger logger = Logger.getLogger(QueueImpl.class);
    public static final int REDISTRIBUTOR_BATCH_SIZE = 100;
    public static final int NUM_PRIORITIES = 10;
    public static final int MAX_DELIVERIES_IN_LOOP = 1000;
    public static final int CHECK_QUEUE_SIZE_PERIOD = 1000;
    public static final int DELIVERY_TIMEOUT = 1000;
    private static final int FLUSH_TIMEOUT = 10000;
    public static final int DEFAULT_FLUSH_LIMIT = 500;
    private final long id;
    private final SimpleString name;
    private final SimpleString user;
    private volatile Filter filter;
    private final boolean propertyDurable;
    private final boolean temporary;
    private final boolean autoCreated;
    private final PostOffice postOffice;
    private volatile boolean queueDestroyed = false;
    private final PageSubscription pageSubscription;
    private ReferenceCounter refCountForConsumers;
    private final LinkedListIterator<PagedReference> pageIterator;
    private volatile boolean printErrorExpiring = false;
    private final ConcurrentLinkedQueue<MessageReference> intermediateMessageReferences = new ConcurrentLinkedQueue();
    private final PriorityLinkedList<MessageReference> messageReferences = new PriorityLinkedListImpl(10);
    private final AtomicInteger pagedReferences = new AtomicInteger(0);
    private final AtomicInteger queueMemorySize = new AtomicInteger(0);
    private final QueuePendingMessageMetrics pendingMetrics = new QueuePendingMessageMetrics(this);
    private final QueuePendingMessageMetrics deliveringMetrics = new QueuePendingMessageMetrics(this);
    private volatile boolean consumersChanged = true;
    private final List<ConsumerHolder> consumerList = new CopyOnWriteArrayList<ConsumerHolder>();
    private final ScheduledDeliveryHandler scheduledDeliveryHandler;
    private AtomicLong messagesAdded = new AtomicLong(0L);
    private AtomicLong messagesAcknowledged = new AtomicLong(0L);
    private AtomicLong messagesExpired = new AtomicLong(0L);
    private AtomicLong messagesKilled = new AtomicLong(0L);
    private boolean paused;
    private long pauseStatusRecord = -1L;
    private static final int MAX_SCHEDULED_RUNNERS = 2;
    private final AtomicInteger scheduledRunners = new AtomicInteger(0);
    private final Runnable deliverRunner = new DeliverRunner();
    private volatile boolean depagePending = false;
    private final StorageManager storageManager;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ActiveMQServer server;
    private final ScheduledExecutorService scheduledExecutor;
    private final SimpleString address;
    private Redistributor redistributor;
    private ScheduledFuture<?> redistributorFuture;
    private final AtomicInteger consumersCount = new AtomicInteger();
    private final Set<Consumer> consumerSet = new HashSet<Consumer>();
    private final Map<SimpleString, Consumer> groups = new HashMap<SimpleString, Consumer>();
    private volatile SimpleString expiryAddress;
    private int pos;
    private final ArtemisExecutor executor;
    private boolean internalQueue;
    private volatile long lastDirectDeliveryCheck = 0L;
    private volatile boolean directDeliver = true;
    private volatile boolean supportsDirectDeliver = true;
    private AddressSettingsRepositoryListener addressSettingsRepositoryListener;
    private final ExpiryScanner expiryScanner = new ExpiryScanner();
    private final ReusableLatch deliveriesInTransit = new ReusableLatch(0);
    private volatile boolean caused = false;
    private final AtomicLong queueRateCheckTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong messagesAddedSnapshot = new AtomicLong(0L);
    private ScheduledFuture slowConsumerReaperFuture;
    private SlowConsumerReaperRunnable slowConsumerReaperRunnable;
    private volatile int maxConsumers;
    private volatile boolean exclusive;
    private volatile boolean purgeOnNoConsumers;
    private final AddressInfo addressInfo;
    private final AtomicInteger noConsumers = new AtomicInteger(0);
    private volatile RoutingType routingType;
    private final QueueFactory factory;
    private final Object directDeliveryGuard = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SimpleString> getGroupsUsed() {
        final CountDownLatch flush = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                flush.countDown();
            }
        });
        try {
            flush.await(10L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            ArrayList<SimpleString> groupsUsed = new ArrayList<SimpleString>();
            groupsUsed.addAll(this.groups.keySet());
            return groupsUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debug() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("queueMemorySize=" + this.queueMemorySize);
        for (ConsumerHolder holder : this.consumerList) {
            out.println("consumer: " + holder.consumer.debug());
        }
        for (MessageReference reference : this.intermediateMessageReferences) {
            out.print("Intermediate reference:" + reference);
        }
        if (this.intermediateMessageReferences.isEmpty()) {
            out.println("No intermediate references");
        }
        boolean foundRef = false;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            LinkedListIterator iter = this.messageReferences.iterator();
            while (iter.hasNext()) {
                foundRef = true;
                out.println("reference = " + iter.next());
            }
        }
        if (!foundRef) {
            out.println("No permanent references on queue");
        }
        System.out.println(str.toString());
        return str.toString();
    }

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, null, user, durable, temporary, autoCreated, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pageSubscription, user, durable, temporary, autoCreated, RoutingType.MULTICAST, null, null, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        this(id, address, name, filter, pageSubscription, user, durable, temporary, autoCreated, routingType, maxConsumers, null, purgeOnNoConsumers, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    public QueueImpl(long id, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, RoutingType routingType, Integer maxConsumers, Boolean exclusive, Boolean purgeOnNoConsumers, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        super((CriticalAnalyzer)(server == null ? EmptyCriticalAnalyzer.getInstance() : server.getCriticalAnalyzer()), 4);
        this.id = id;
        this.address = address;
        this.addressInfo = postOffice == null ? null : postOffice.getAddressInfo(address);
        this.routingType = routingType;
        this.name = name;
        this.filter = filter;
        this.pageSubscription = pageSubscription;
        this.propertyDurable = durable;
        this.temporary = temporary;
        this.autoCreated = autoCreated;
        this.maxConsumers = maxConsumers == null ? ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers() : maxConsumers;
        this.exclusive = exclusive == null ? ActiveMQDefaultConfiguration.getDefaultExclusive() : exclusive;
        this.purgeOnNoConsumers = purgeOnNoConsumers == null ? ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers() : purgeOnNoConsumers;
        this.postOffice = postOffice;
        this.storageManager = storageManager;
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.server = server;
        this.scheduledDeliveryHandler = new ScheduledDeliveryHandlerImpl(scheduledExecutor, this);
        if (addressSettingsRepository != null) {
            this.addressSettingsRepositoryListener = new AddressSettingsRepositoryListener();
            addressSettingsRepository.registerListener(this.addressSettingsRepositoryListener);
        } else {
            this.expiryAddress = null;
        }
        if (pageSubscription != null) {
            pageSubscription.setQueue(this);
            this.pageIterator = pageSubscription.iterator();
        } else {
            this.pageIterator = null;
        }
        this.executor = executor;
        this.user = user;
        this.factory = factory;
    }

    public SimpleString getRoutingName() {
        return this.name;
    }

    public SimpleString getUniqueName() {
        return this.name;
    }

    @Override
    public SimpleString getUser() {
        return this.user;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public synchronized void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    @Override
    public boolean isLastValue() {
        return false;
    }

    @Override
    public void route(Message message, RoutingContext context) throws Exception {
        if (this.purgeOnNoConsumers && this.getConsumerCount() == 0) {
            return;
        }
        context.addQueue(this.address, this);
    }

    @Override
    public void routeWithAck(Message message, RoutingContext context) {
        context.addQueueWithAck(this.address, this);
    }

    @Override
    public synchronized void setConsumersRefCount(ReferenceCounter referenceCounter) {
        if (this.refCountForConsumers == null) {
            this.refCountForConsumers = referenceCounter;
        }
    }

    @Override
    public ReferenceCounter getConsumersRefCount() {
        return this.refCountForConsumers;
    }

    @Override
    public boolean isDurable() {
        return this.propertyDurable;
    }

    @Override
    public boolean isDurableMessage() {
        return this.propertyDurable && !this.purgeOnNoConsumers;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    @Override
    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    @Override
    public boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    @Override
    public synchronized void setPurgeOnNoConsumers(boolean value) {
        this.purgeOnNoConsumers = value;
    }

    @Override
    public int getMaxConsumers() {
        return this.maxConsumers;
    }

    @Override
    public synchronized void setMaxConsumer(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public PageSubscription getPageSubscription() {
        return this.pageSubscription;
    }

    @Override
    public RoutingType getRoutingType() {
        return this.routingType;
    }

    @Override
    public void setRoutingType(RoutingType routingType) {
        if (this.addressInfo.getRoutingTypes().contains(routingType)) {
            this.routingType = routingType;
        }
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void unproposed(final SimpleString groupID) {
        if (groupID.toString().endsWith("." + this.getName())) {
            final SimpleString groupIDToRemove = (SimpleString)groupID.subSequence(0, groupID.length() - this.getName().length() - 1);
            this.getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    QueueImpl queueImpl = QueueImpl.this;
                    synchronized (queueImpl) {
                        if (QueueImpl.this.groups.remove(groupIDToRemove) != null) {
                            logger.debug((Object)("Removing group after unproposal " + groupID + " from queue " + QueueImpl.this));
                        } else {
                            logger.debug((Object)("Couldn't remove Removing group " + groupIDToRemove + " after unproposal on queue " + QueueImpl.this));
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHead(MessageReference ref, boolean scheduling) {
        this.enterCritical(1);
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            try {
                if (!scheduling && this.scheduledDeliveryHandler.checkAndSchedule(ref, false)) {
                    return;
                }
                this.internalAddHead(ref);
                this.directDeliver = false;
            }
            finally {
                this.leaveCritical(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHead(List<MessageReference> refs, boolean scheduling) {
        this.enterCritical(1);
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            try {
                for (MessageReference ref : refs) {
                    this.addHead(ref, scheduling);
                }
                this.resetAllIterators();
                this.deliverAsync();
            }
            finally {
                this.leaveCritical(1);
            }
        }
    }

    @Override
    public synchronized void reload(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        if (!this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            this.internalAddTail(ref);
        }
        this.directDeliver = false;
        if (!ref.isPaged()) {
            this.messagesAdded.incrementAndGet();
        }
    }

    @Override
    public void addTail(MessageReference ref) {
        this.addTail(ref, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTail(MessageReference ref, boolean direct) {
        this.enterCritical(0);
        try {
            if (this.scheduleIfPossible(ref)) {
                return;
            }
            if (this.supportsDirectDeliver && !this.directDeliver && direct && System.currentTimeMillis() - this.lastDirectDeliveryCheck > 1000L) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Checking to re-enable direct deliver on queue " + this.getName()));
                }
                this.lastDirectDeliveryCheck = System.currentTimeMillis();
                Object object = this.directDeliveryGuard;
                synchronized (object) {
                    if (this.deliveriesInTransit.getCount() == 0 && this.getExecutor().isFlushed() && this.intermediateMessageReferences.isEmpty() && this.messageReferences.isEmpty() && !this.pageIterator.hasNext() && !this.pageSubscription.isPaging()) {
                        this.directDeliver = this.supportsDirectDeliver;
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Setting direct deliverer to " + this.supportsDirectDeliver));
                        }
                    } else if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Couldn't set direct deliver back");
                    }
                }
            }
            if (direct && this.supportsDirectDeliver && this.directDeliver && this.deliveriesInTransit.getCount() == 0 && this.deliverDirect(ref)) {
                return;
            }
            this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
            this.intermediateMessageReferences.add(ref);
            this.directDeliver = false;
            this.deliverAsync();
        }
        finally {
            this.leaveCritical(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scheduleIfPossible(MessageReference ref) {
        if (this.scheduledDeliveryHandler.checkAndSchedule(ref, true)) {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (!ref.isPaged()) {
                    this.messagesAdded.incrementAndGet();
                }
            }
            return true;
        }
        return false;
    }

    private boolean flushDeliveriesInTransit() {
        try {
            if (!this.deliveriesInTransit.await(100L, TimeUnit.MILLISECONDS)) {
                this.caused = true;
                System.err.println("There are currently " + this.deliveriesInTransit.getCount() + " credits");
            }
            if (this.deliveriesInTransit.await(1000L)) {
                return true;
            }
            ActiveMQServerLogger.LOGGER.timeoutFlushInTransit(this.getName().toString(), this.getAddress().toString());
            return false;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToFlushDeliveries(e);
            return false;
        }
    }

    @Override
    public void forceDelivery() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Force delivery scheduling depage");
            }
            this.scheduleDepage(false);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Force delivery delivering async");
        }
        this.deliverAsync();
    }

    @Override
    public void deliverAsync() {
        if (this.scheduledRunners.get() < 2) {
            this.scheduledRunners.incrementAndGet();
            try {
                this.getExecutor().execute(this.deliverRunner);
            }
            catch (RejectedExecutionException ignored) {
                this.scheduledRunners.decrementAndGet();
            }
            this.checkDepage();
        }
    }

    @Override
    public void close() throws Exception {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    QueueImpl.this.cancelRedistributor();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.unableToCancelRedistributor(e);
                }
            }
        });
        if (this.addressSettingsRepository != null) {
            this.addressSettingsRepository.unRegisterListener(this.addressSettingsRepositoryListener);
        }
    }

    public ArtemisExecutor getExecutor() {
        if (this.pageSubscription != null && this.pageSubscription.isPaging()) {
            return this.pageSubscription.getExecutor();
        }
        return this.executor;
    }

    public void deliverNow() {
        this.deliverAsync();
        this.flushExecutor();
    }

    @Override
    public boolean flushExecutor() {
        boolean ok = this.internalFlushExecutor(10000L, true);
        if (!ok) {
            ActiveMQServerLogger.LOGGER.errorFlushingExecutorsOnQueue();
        }
        return ok;
    }

    private boolean internalFlushExecutor(long timeout, boolean log) {
        if (!this.getExecutor().flush(timeout, TimeUnit.MILLISECONDS)) {
            if (log) {
                ActiveMQServerLogger.LOGGER.queueBusy(this.name.toString(), timeout);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(Consumer consumer) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + " adding consumer " + consumer));
        }
        this.enterCritical(3);
        try {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.maxConsumers != -1 && this.noConsumers.get() >= this.maxConsumers) {
                    throw ActiveMQMessageBundle.BUNDLE.maxConsumerLimitReachedForQueue(this.address, this.name);
                }
                this.consumersChanged = true;
                if (!consumer.supportsDirectDelivery()) {
                    this.supportsDirectDeliver = false;
                }
                this.cancelRedistributor();
                this.consumerList.add(new ConsumerHolder(consumer));
                if (this.consumerSet.add(consumer)) {
                    this.consumersCount.incrementAndGet();
                }
                if (this.refCountForConsumers != null) {
                    this.refCountForConsumers.increment();
                }
                this.noConsumers.incrementAndGet();
            }
        }
        finally {
            this.leaveCritical(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(Consumer consumer) {
        this.enterCritical(3);
        try {
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                this.consumersChanged = true;
                for (ConsumerHolder holder : this.consumerList) {
                    if (holder.consumer != consumer) continue;
                    if (holder.iter != null) {
                        holder.iter.close();
                    }
                    this.consumerList.remove(holder);
                    break;
                }
                this.supportsDirectDeliver = this.checkConsumerDirectDeliver();
                if (this.pos > 0 && this.pos >= this.consumerList.size()) {
                    this.pos = this.consumerList.size() - 1;
                }
                if (this.consumerSet.remove(consumer)) {
                    this.consumersCount.decrementAndGet();
                }
                LinkedList<SimpleString> groupsToRemove = null;
                for (SimpleString groupID : this.groups.keySet()) {
                    if (consumer != this.groups.get(groupID)) continue;
                    if (groupsToRemove == null) {
                        groupsToRemove = new LinkedList<SimpleString>();
                    }
                    groupsToRemove.add(groupID);
                }
                if (groupsToRemove != null) {
                    for (SimpleString groupID : groupsToRemove) {
                        this.groups.remove(groupID);
                    }
                }
                if (this.refCountForConsumers != null) {
                    this.refCountForConsumers.decrement();
                }
                this.noConsumers.decrementAndGet();
            }
        }
        finally {
            this.leaveCritical(3);
        }
    }

    private boolean checkConsumerDirectDeliver() {
        boolean supports = true;
        for (ConsumerHolder consumerCheck : this.consumerList) {
            if (consumerCheck.consumer.supportsDirectDelivery()) continue;
            supports = false;
        }
        return supports;
    }

    @Override
    public synchronized void addRedistributor(long delay) {
        this.clearRedistributorFuture();
        if (this.redistributor != null) {
            this.deliverAsync();
        }
        if (delay > 0L) {
            if (this.consumerSet.isEmpty()) {
                DelayedAddRedistributor dar = new DelayedAddRedistributor(this.executor);
                this.redistributorFuture = this.scheduledExecutor.schedule(dar, delay, TimeUnit.MILLISECONDS);
            }
        } else {
            this.internalAddRedistributor(this.executor);
        }
    }

    private void clearRedistributorFuture() {
        ScheduledFuture<?> future = this.redistributorFuture;
        this.redistributorFuture = null;
        if (future != null) {
            future.cancel(false);
        }
    }

    @Override
    public synchronized void cancelRedistributor() throws Exception {
        if (this.redistributor != null) {
            this.redistributor.stop();
            Redistributor redistributorToRemove = this.redistributor;
            this.redistributor = null;
            this.removeConsumer(redistributorToRemove);
        }
        this.clearRedistributorFuture();
    }

    protected void finalize() throws Throwable {
        this.cancelRedistributor();
        super.finalize();
    }

    @Override
    public int getConsumerCount() {
        return this.consumersCount.get();
    }

    public synchronized Set<Consumer> getConsumers() {
        return new HashSet<Consumer>(this.consumerSet);
    }

    @Override
    public synchronized Map<SimpleString, Consumer> getGroups() {
        return new HashMap<SimpleString, Consumer>(this.groups);
    }

    @Override
    public synchronized void resetGroup(SimpleString groupId) {
        this.groups.remove(groupId);
    }

    @Override
    public synchronized void resetAllGroups() {
        this.groups.clear();
    }

    @Override
    public synchronized int getGroupCount() {
        return this.groups.size();
    }

    @Override
    public boolean hasMatchingConsumer(Message message) {
        for (ConsumerHolder holder : this.consumerList) {
            Consumer consumer = holder.consumer;
            if (consumer instanceof Redistributor) continue;
            Filter filter1 = consumer.getFilter();
            if (filter1 == null) {
                return true;
            }
            if (!filter1.match(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedListIterator<MessageReference> iterator() {
        return new SynchronizedIterator((LinkedListIterator<MessageReference>)this.messageReferences.iterator());
    }

    public QueueBrowserIterator browserIterator() {
        return new QueueBrowserIterator();
    }

    @Override
    public synchronized MessageReference removeReferenceWithID(long id1) throws Exception {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            MessageReference removed = null;
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                iterator.remove();
                this.refRemoved(ref);
                removed = ref;
                break;
            }
            if (removed == null) {
                removed = this.scheduledDeliveryHandler.removeReferenceWithID(id1);
            }
            MessageReference messageReference = removed;
            return messageReference;
        }
    }

    @Override
    public synchronized MessageReference getReference(long id1) throws ActiveMQException {
        try (LinkedListIterator<MessageReference> iterator = this.iterator();){
            while (iterator.hasNext()) {
                MessageReference ref = (MessageReference)iterator.next();
                if (ref.getMessage().getMessageID() != id1) continue;
                MessageReference messageReference = ref;
                return messageReference;
            }
            MessageReference messageReference = null;
            return messageReference;
        }
    }

    @Override
    public long getMessageCount() {
        if (this.pageSubscription != null) {
            return (long)(this.pendingMetrics.getMessageCount() + this.getScheduledCount() + this.getDeliveringCount()) + this.pageSubscription.getMessageCount();
        }
        return this.pendingMetrics.getMessageCount() + this.getScheduledCount() + this.getDeliveringCount();
    }

    @Override
    public long getPersistentSize() {
        if (this.pageSubscription != null) {
            return this.pendingMetrics.getPersistentSize() + this.getScheduledSize() + this.getDeliveringSize() + this.pageSubscription.getPersistentSize();
        }
        return this.pendingMetrics.getPersistentSize() + this.getScheduledSize() + this.getDeliveringSize();
    }

    @Override
    public long getDurableMessageCount() {
        if (this.isDurable()) {
            if (this.pageSubscription != null) {
                return (long)(this.pendingMetrics.getDurableMessageCount() + this.getDurableScheduledCount() + this.getDurableDeliveringCount()) + this.pageSubscription.getMessageCount();
            }
            return this.pendingMetrics.getDurableMessageCount() + this.getDurableScheduledCount() + this.getDurableDeliveringCount();
        }
        return 0L;
    }

    @Override
    public long getDurablePersistentSize() {
        if (this.isDurable()) {
            if (this.pageSubscription != null) {
                return this.pendingMetrics.getDurablePersistentSize() + this.getDurableScheduledSize() + this.getDurableDeliveringSize() + this.pageSubscription.getPersistentSize();
            }
            return this.pendingMetrics.getDurablePersistentSize() + this.getDurableScheduledSize() + this.getDurableDeliveringSize();
        }
        return 0L;
    }

    @Override
    public synchronized int getScheduledCount() {
        return this.scheduledDeliveryHandler.getScheduledCount();
    }

    @Override
    public synchronized long getScheduledSize() {
        return this.scheduledDeliveryHandler.getScheduledSize();
    }

    @Override
    public synchronized int getDurableScheduledCount() {
        return this.scheduledDeliveryHandler.getDurableScheduledCount();
    }

    @Override
    public synchronized long getDurableScheduledSize() {
        return this.scheduledDeliveryHandler.getDurableScheduledSize();
    }

    @Override
    public synchronized List<MessageReference> getScheduledMessages() {
        return this.scheduledDeliveryHandler.getScheduledReferences();
    }

    @Override
    public Map<String, List<MessageReference>> getDeliveringMessages() {
        List<ConsumerHolder> consumerListClone = this.cloneConsumersList();
        HashMap<String, List<MessageReference>> mapReturn = new HashMap<String, List<MessageReference>>();
        for (ConsumerHolder holder : consumerListClone) {
            List<MessageReference> msgs = holder.consumer.getDeliveringMessages();
            if (msgs == null || msgs.size() <= 0) continue;
            mapReturn.put(holder.consumer.toManagementString(), msgs);
        }
        return mapReturn;
    }

    @Override
    public int getDeliveringCount() {
        return this.deliveringMetrics.getMessageCount();
    }

    @Override
    public long getDeliveringSize() {
        return this.deliveringMetrics.getPersistentSize();
    }

    @Override
    public int getDurableDeliveringCount() {
        return this.deliveringMetrics.getDurableMessageCount();
    }

    @Override
    public long getDurableDeliveringSize() {
        return this.deliveringMetrics.getDurablePersistentSize();
    }

    @Override
    public void acknowledge(MessageReference ref) throws Exception {
        this.acknowledge(ref, null);
    }

    @Override
    public void acknowledge(MessageReference ref, ServerConsumer consumer) throws Exception {
        this.acknowledge(ref, AckReason.NORMAL, consumer);
    }

    @Override
    public void acknowledge(MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        if (ref.isPaged()) {
            this.pageSubscription.ack((PagedReference)ref);
            this.postAcknowledge(ref);
        } else {
            boolean durableRef;
            Message message = ref.getMessage();
            boolean bl = durableRef = message.isDurable() && this.isDurableMessage();
            if (durableRef) {
                this.storageManager.storeAcknowledge(this.id, message.getMessageID());
            }
            this.postAcknowledge(ref);
        }
        if (reason == AckReason.EXPIRED) {
            this.messagesExpired.incrementAndGet();
        } else if (reason == AckReason.KILLED) {
            this.messagesKilled.incrementAndGet();
        } else {
            this.messagesAcknowledged.incrementAndGet();
        }
        if (this.server != null && this.server.hasBrokerPlugins()) {
            this.server.callBrokerPlugins(plugin -> plugin.messageAcknowledged(ref, reason, consumer));
        }
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref) throws Exception {
        this.acknowledge(tx, ref, AckReason.NORMAL, null);
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        if (ref.isPaged()) {
            this.pageSubscription.ackTx(tx, (PagedReference)ref);
            this.getRefsOperation(tx).addAck(ref);
        } else {
            boolean durableRef;
            Message message = ref.getMessage();
            boolean bl = durableRef = message.isDurable() && this.isDurableMessage();
            if (durableRef) {
                this.storageManager.storeAcknowledgeTransactional(tx.getID(), this.id, message.getMessageID());
                tx.setContainsPersistent();
            }
            this.getRefsOperation(tx).addAck(ref);
        }
        if (reason == AckReason.EXPIRED) {
            this.messagesExpired.incrementAndGet();
        } else if (reason == AckReason.KILLED) {
            this.messagesKilled.incrementAndGet();
        } else {
            this.messagesAcknowledged.incrementAndGet();
        }
        if (this.server != null && this.server.hasBrokerPlugins()) {
            this.server.callBrokerPlugins(plugin -> plugin.messageAcknowledged(ref, reason, consumer));
        }
    }

    @Override
    public void reacknowledge(Transaction tx, MessageReference ref) throws Exception {
        Message message = ref.getMessage();
        if (message.isDurable() && this.isDurableMessage()) {
            tx.setContainsPersistent();
        }
        this.getRefsOperation(tx).addAck(ref);
        this.incDelivering(ref);
        this.messagesAcknowledged.incrementAndGet();
    }

    private RefsOperation getRefsOperation(Transaction tx) {
        return this.getRefsOperation(tx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RefsOperation getRefsOperation(Transaction tx, boolean ignoreRedlieveryCheck) {
        Transaction transaction = tx;
        synchronized (transaction) {
            RefsOperation oper = (RefsOperation)tx.getProperty(6);
            if (oper == null) {
                oper = tx.createRefsOperation(this);
                tx.putProperty(6, oper);
                tx.addOperation(oper);
            }
            if (ignoreRedlieveryCheck) {
                oper.setIgnoreRedeliveryCheck();
            }
            return oper;
        }
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference) {
        this.cancel(tx, reference, false);
    }

    @Override
    public void cancel(Transaction tx, MessageReference reference, boolean ignoreRedeliveryCheck) {
        this.getRefsOperation(tx, ignoreRedeliveryCheck).addAck(reference);
    }

    @Override
    public synchronized void cancel(MessageReference reference, long timeBase) throws Exception {
        if (this.checkRedelivery(reference, timeBase, false)) {
            if (!this.scheduledDeliveryHandler.checkAndSchedule(reference, false)) {
                this.internalAddHead(reference);
            }
            this.resetAllIterators();
        } else {
            this.decDelivering(reference);
        }
    }

    @Override
    public void expire(MessageReference ref) throws Exception {
        this.expire(ref, null);
    }

    @Override
    public void expire(MessageReference ref, ServerConsumer consumer) throws Exception {
        SimpleString messageExpiryAddress = this.expiryAddressFromMessageAddress(ref);
        if (messageExpiryAddress == null) {
            messageExpiryAddress = this.expiryAddressFromAddressSettings(ref);
        }
        if (messageExpiryAddress != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("moving expired reference " + ref + " to address = " + messageExpiryAddress + " from queue=" + this.getName()));
            }
            this.move(null, messageExpiryAddress, null, ref, false, AckReason.EXPIRED, consumer);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("expiry is null, just acking expired message for reference " + ref + " from queue=" + this.getName()));
            }
            this.acknowledge(ref, AckReason.EXPIRED, consumer);
        }
        if (this.server != null && this.server.hasBrokerPlugins()) {
            SimpleString expiryAddress = messageExpiryAddress;
            this.server.callBrokerPlugins(plugin -> plugin.messageExpired(ref, expiryAddress, consumer));
        }
    }

    private SimpleString expiryAddressFromMessageAddress(MessageReference ref) {
        SimpleString messageAddress = this.extractAddress(ref.getMessage());
        SimpleString expiryAddress = null;
        if (messageAddress == null || messageAddress.equals((Object)this.getAddress())) {
            expiryAddress = this.getExpiryAddress();
        }
        return expiryAddress;
    }

    private SimpleString expiryAddressFromAddressSettings(MessageReference ref) {
        SimpleString messageAddress = this.extractAddress(ref.getMessage());
        SimpleString expiryAddress = null;
        if (messageAddress != null) {
            AddressSettings addressSettings = this.addressSettingsRepository.getMatch(messageAddress.toString());
            expiryAddress = addressSettings.getExpiryAddress();
        }
        return expiryAddress;
    }

    private SimpleString extractAddress(Message message) {
        if (message.containsProperty(Message.HDR_ORIG_MESSAGE_ID.toString())) {
            return message.getSimpleStringProperty(Message.HDR_ORIGINAL_ADDRESS.toString());
        }
        return message.getAddressSimpleString();
    }

    @Override
    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    @Override
    public void referenceHandled(MessageReference ref) {
        this.incDelivering(ref);
    }

    @Override
    public void incrementMesssagesAdded() {
        this.messagesAdded.incrementAndGet();
    }

    @Override
    public void deliverScheduledMessages() throws ActiveMQException {
        List<MessageReference> scheduledMessages = this.scheduledDeliveryHandler.cancel(null);
        if (scheduledMessages != null && scheduledMessages.size() > 0) {
            for (MessageReference ref : scheduledMessages) {
                ref.getMessage().setScheduledDeliveryTime(Long.valueOf(ref.getScheduledDeliveryTime()));
                ref.setScheduledDeliveryTime(0L);
            }
            this.addHead(scheduledMessages, true);
        }
    }

    @Override
    public long getMessagesAdded() {
        if (this.pageSubscription != null) {
            return this.messagesAdded.get() + this.pageSubscription.getCounter().getValueAdded();
        }
        return this.messagesAdded.get();
    }

    @Override
    public long getMessagesAcknowledged() {
        return this.messagesAcknowledged.get();
    }

    @Override
    public long getMessagesExpired() {
        return this.messagesExpired.get();
    }

    @Override
    public long getMessagesKilled() {
        return this.messagesKilled.get();
    }

    @Override
    public int deleteAllReferences() throws Exception {
        return this.deleteAllReferences(500);
    }

    @Override
    public int deleteAllReferences(int flushLimit) throws Exception {
        return this.deleteMatchingReferences(flushLimit, null);
    }

    @Override
    public int deleteMatchingReferences(Filter filter) throws Exception {
        return this.deleteMatchingReferences(500, filter);
    }

    @Override
    public synchronized int deleteMatchingReferences(int flushLimit, Filter filter1, final AckReason ackReason) throws Exception {
        return this.iterQueue(flushLimit, filter1, new QueueIterateAction(){

            @Override
            public void actMessage(Transaction tx, MessageReference ref) throws Exception {
                this.actMessage(tx, ref, true);
            }

            @Override
            public void actMessage(Transaction tx, MessageReference ref, boolean fromMessageReferences) throws Exception {
                QueueImpl.this.incDelivering(ref);
                QueueImpl.this.acknowledge(tx, ref, ackReason, null);
                if (fromMessageReferences) {
                    QueueImpl.this.refRemoved(ref);
                }
            }
        });
    }

    private synchronized int iterQueue(int flushLimit, Filter filter1, QueueIterateAction messageAction) throws Exception {
        int count = 0;
        int txCount = 0;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.isPaged() && this.queueDestroyed || filter1 != null && !filter1.match(ref.getMessage())) continue;
                messageAction.actMessage(tx, ref);
                iter.remove();
                ++txCount;
                ++count;
            }
            if (txCount > 0) {
                tx.commit();
                tx = new TransactionImpl(this.storageManager);
                txCount = 0;
            }
            List<MessageReference> cancelled = this.scheduledDeliveryHandler.cancel(filter1);
            for (MessageReference messageReference : cancelled) {
                messageAction.actMessage(tx, messageReference, false);
                ++count;
                ++txCount;
            }
            if (txCount > 0) {
                tx.commit();
                tx = new TransactionImpl(this.storageManager);
                txCount = 0;
            }
            if (this.pageIterator != null && !this.queueDestroyed) {
                while (this.pageIterator.hasNext()) {
                    PagedReference reference = (PagedReference)this.pageIterator.next();
                    this.pageIterator.remove();
                    if (filter1 == null || filter1.match(reference.getMessage())) {
                        ++count;
                        ++txCount;
                        messageAction.actMessage(tx, reference, false);
                    } else {
                        this.addTail(reference, false);
                    }
                    if (txCount <= 0 || txCount % flushLimit != 0) continue;
                    tx.commit();
                    tx = new TransactionImpl(this.storageManager);
                    txCount = 0;
                }
            }
            if (txCount > 0) {
                tx.commit();
                tx = null;
            }
            if (this.filter != null && !this.queueDestroyed && this.pageSubscription != null) {
                this.scheduleDepage(false);
            }
            int n = count;
            return n;
        }
    }

    @Override
    public void destroyPaging() throws Exception {
        if (this.pageSubscription != null) {
            this.pageSubscription.destroy();
            this.pageSubscription.cleanupEntries(true);
        }
    }

    @Override
    public synchronized boolean deleteReference(long messageID) throws Exception {
        boolean deleted = false;
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.acknowledge(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                deleted = true;
                break;
            }
            if (!deleted) {
                deleted = this.scheduledDeliveryHandler.removeReferenceWithID(messageID) != null;
            }
            tx.commit();
            boolean bl = deleted;
            return bl;
        }
    }

    @Override
    public void deleteQueue() throws Exception {
        this.deleteQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQueue(boolean removeConsumers) throws Exception {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.queueDestroyed) {
                return;
            }
            this.queueDestroyed = true;
        }
        BindingsTransactionImpl tx = new BindingsTransactionImpl(this.storageManager);
        try {
            this.deleteAllReferences();
            this.destroyPaging();
            this.postOffice.removeBinding(this.name, tx, true);
            if (removeConsumers) {
                for (ConsumerHolder consumerHolder : this.consumerList) {
                    consumerHolder.consumer.disconnect();
                }
            }
            if (this.isDurable()) {
                this.storageManager.deleteQueueBinding(tx.getID(), this.getID());
                tx.setContainsPersistent();
            }
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            if (this.factory != null) {
                this.factory.queueRemoved(this);
            }
        }
    }

    @Override
    public synchronized boolean expireReference(long messageID) throws Exception {
        if (this.isExpirationRedundant()) {
            return false;
        }
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.expire(ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int expireReferences(Filter filter) throws Exception {
        if (this.isExpirationRedundant()) {
            return 0;
        }
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering(ref);
                this.expire(tx, ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            tx.commit();
            int n = count;
            return n;
        }
    }

    @Override
    public void expireReferences() {
        if (this.isExpirationRedundant()) {
            return;
        }
        if (!this.queueDestroyed && this.expiryScanner.scannerRunning.get() == 0) {
            this.expiryScanner.scannerRunning.incrementAndGet();
            this.getExecutor().execute((Runnable)this.expiryScanner);
        }
    }

    public boolean isExpirationRedundant() {
        if (this.expiryAddress != null && this.expiryAddress.equals((Object)this.address)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Redundant expiration from " + this.address + " to " + this.expiryAddress));
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean sendMessageToDeadLetterAddress(long messageID) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                this.incDelivering(ref);
                this.sendToDeadLetterAddress(null, ref);
                iter.remove();
                this.refRemoved(ref);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int sendMessagesToDeadLetterAddress(Filter filter) throws Exception {
        int count = 0;
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                this.incDelivering(ref);
                this.sendToDeadLetterAddress(null, ref);
                iter.remove();
                this.refRemoved(ref);
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Override
    public synchronized boolean moveReference(long messageID, SimpleString toAddress, Binding binding, boolean rejectDuplicate) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                this.incDelivering(ref);
                try {
                    this.move(null, toAddress, binding, ref, rejectDuplicate, AckReason.NORMAL, null);
                }
                catch (Exception e) {
                    this.decDelivering(ref);
                    throw e;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int moveReferences(Filter filter, SimpleString toAddress, Binding binding) throws Exception {
        return this.moveReferences(500, filter, toAddress, false, binding);
    }

    @Override
    public synchronized int moveReferences(int flushLimit, Filter filter, final SimpleString toAddress, final boolean rejectDuplicates, final Binding binding) throws Exception {
        final DuplicateIDCache targetDuplicateCache = this.postOffice.getDuplicateIDCache(toAddress);
        return this.iterQueue(flushLimit, filter, new QueueIterateAction(){

            @Override
            public void actMessage(Transaction tx, MessageReference ref) throws Exception {
                byte[] duplicateBytes;
                boolean ignored = false;
                QueueImpl.this.incDelivering(ref);
                if (rejectDuplicates && (duplicateBytes = ref.getMessage().getDuplicateIDBytes()) != null && targetDuplicateCache.contains(duplicateBytes)) {
                    ActiveMQServerLogger.LOGGER.messageWithDuplicateID(ref.getMessage().getDuplicateProperty(), toAddress, QueueImpl.this.address, QueueImpl.this.address);
                    QueueImpl.this.acknowledge(tx, ref);
                    ignored = true;
                }
                if (!ignored) {
                    QueueImpl.this.move(null, toAddress, binding, ref, rejectDuplicates, AckReason.NORMAL, null);
                    QueueImpl.this.refRemoved(ref);
                }
            }
        });
    }

    public synchronized int moveReferencesBetweenSnFQueues(final SimpleString queueSuffix) throws Exception {
        return this.iterQueue(500, null, new QueueIterateAction(){

            @Override
            public void actMessage(Transaction tx, MessageReference ref) throws Exception {
                QueueImpl.this.moveBetweenSnFQueues(queueSuffix, tx, ref);
            }
        });
    }

    @Override
    public int retryMessages(Filter filter) throws Exception {
        final HashMap queues = new HashMap();
        return this.iterQueue(500, filter, new QueueIterateAction(){

            @Override
            public void actMessage(Transaction tx, MessageReference ref) throws Exception {
                String originalMessageAddress = ref.getMessage().getAnnotationString(Message.HDR_ORIGINAL_ADDRESS);
                String originalMessageQueue = ref.getMessage().getAnnotationString(Message.HDR_ORIGINAL_QUEUE);
                if (originalMessageAddress != null) {
                    Binding binding;
                    QueueImpl.this.incDelivering(ref);
                    Long targetQueue = null;
                    if (originalMessageQueue != null && !originalMessageQueue.equals(originalMessageAddress) && (targetQueue = (Long)queues.get(originalMessageQueue)) == null && (binding = QueueImpl.this.postOffice.getBinding(SimpleString.toSimpleString((String)originalMessageQueue))) != null && binding instanceof LocalQueueBinding) {
                        targetQueue = ((LocalQueueBinding)binding).getID();
                        queues.put(originalMessageQueue, targetQueue);
                    }
                    if (targetQueue != null) {
                        QueueImpl.this.move(SimpleString.toSimpleString((String)originalMessageAddress), tx, ref, false, false, new long[]{targetQueue});
                    } else {
                        QueueImpl.this.move(SimpleString.toSimpleString((String)originalMessageAddress), tx, ref, false, false, new long[0]);
                    }
                    QueueImpl.this.refRemoved(ref);
                }
            }
        });
    }

    @Override
    public synchronized boolean changeReferencePriority(long messageID, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (ref.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public synchronized int changeReferencesPriority(Filter filter, byte newPriority) throws Exception {
        try (LinkedListIterator<MessageReference> iter = this.iterator();){
            int count = 0;
            while (iter.hasNext()) {
                MessageReference ref = (MessageReference)iter.next();
                if (filter != null && !filter.match(ref.getMessage())) continue;
                ++count;
                iter.remove();
                this.refRemoved(ref);
                ref.getMessage().setPriority(newPriority);
                this.addTail(ref, false);
            }
            int n = count;
            return n;
        }
    }

    @Override
    public synchronized void resetAllIterators() {
        for (ConsumerHolder holder : this.consumerList) {
            if (holder.iter != null) {
                holder.iter.close();
            }
            holder.iter = null;
        }
    }

    @Override
    public synchronized void pause() {
        this.pause(false);
    }

    @Override
    public synchronized void reloadPause(long recordID) {
        this.paused = true;
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToDeleteQueueStatus(e);
            }
        }
        this.pauseStatusRecord = recordID;
    }

    @Override
    public synchronized void pause(boolean persist) {
        try {
            this.flushDeliveriesInTransit();
            if (persist && this.isDurable()) {
                if (this.pauseStatusRecord >= 0L) {
                    this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
                }
                this.pauseStatusRecord = this.storageManager.storeQueueStatus(this.id, QueueStatus.PAUSED);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToPauseQueue(e);
        }
        this.paused = true;
    }

    @Override
    public synchronized void resume() {
        this.paused = false;
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteQueueStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToResumeQueue(e);
            }
            this.pauseStatusRecord = -1L;
        }
        this.deliverAsync();
    }

    @Override
    public synchronized boolean isPaused() {
        return this.paused;
    }

    @Override
    public synchronized boolean isPersistedPause() {
        return this.pauseStatusRecord >= 0L;
    }

    @Override
    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    @Override
    public boolean isInternalQueue() {
        return this.internalQueue;
    }

    @Override
    public void setInternalQueue(boolean internalQueue) {
        this.internalQueue = internalQueue;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QueueImpl)) {
            return false;
        }
        QueueImpl qother = (QueueImpl)other;
        return this.name.equals((Object)qother.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "QueueImpl[name=" + this.name.toString() + ", postOffice=" + this.postOffice + ", temp=" + this.temporary + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private synchronized void internalAddTail(MessageReference ref) {
        this.refAdded(ref);
        this.messageReferences.addTail((Object)ref, this.getPriority(ref));
        this.pendingMetrics.incrementMetrics(ref);
    }

    private void internalAddHead(MessageReference ref) {
        this.queueMemorySize.addAndGet(ref.getMessageMemoryEstimate());
        this.pendingMetrics.incrementMetrics(ref);
        this.refAdded(ref);
        int priority = this.getPriority(ref);
        this.messageReferences.addHead((Object)ref, priority);
    }

    private int getPriority(MessageReference ref) {
        try {
            return ref.getMessage().getPriority();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToGetMessagePriority(e);
            return 4;
        }
    }

    private synchronized void doInternalPoll() {
        MessageReference ref;
        int added = 0;
        while ((ref = this.intermediateMessageReferences.poll()) != null) {
            this.internalAddTail(ref);
            if (!ref.isPaged()) {
                this.messagesAdded.incrementAndGet();
            }
            if (added++ <= 1000) continue;
            this.deliverAsync();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this + " doing deliver. messageReferences=" + this.messageReferences.size()));
        }
        this.doInternalPoll();
        int noDelivery = 0;
        int size = 0;
        int endPos = -1;
        int handled = 0;
        long timeout = System.currentTimeMillis() + 1000L;
        while (true) {
            MessageReference ref;
            if (handled == 1000) {
                this.deliverAsync();
                return;
            }
            if (System.currentTimeMillis() > timeout) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"delivery has been running for too long. Scheduling another delivery task now");
                }
                this.deliverAsync();
                return;
            }
            Consumer handledconsumer = null;
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                if (this.paused || this.consumerList.isEmpty()) {
                    return;
                }
                if (this.messageReferences.size() == 0) {
                    break;
                }
                if (endPos < 0 || this.consumersChanged) {
                    this.consumersChanged = false;
                    size = this.consumerList.size();
                    endPos = this.pos - 1;
                    if (endPos < 0) {
                        endPos = size - 1;
                        noDelivery = 0;
                    }
                }
                ConsumerHolder holder = this.consumerList.get(this.pos);
                Consumer consumer = holder.consumer;
                Consumer groupConsumer = null;
                if (holder.iter == null) {
                    holder.iter = this.messageReferences.iterator();
                }
                if ((ref = holder.iter.hasNext() ? (MessageReference)holder.iter.next() : null) == null) {
                    ++noDelivery;
                } else {
                    HandleStatus status;
                    SimpleString groupID;
                    if (this.checkExpired(ref)) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Reference " + ref + " being expired"));
                        }
                        holder.iter.remove();
                        this.refRemoved(ref);
                        ++handled;
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Queue " + this.getName() + " is delivering reference " + ref));
                    }
                    if ((groupID = this.extractGroupID(ref)) != null && (groupConsumer = this.groups.get(groupID)) != null) {
                        consumer = groupConsumer;
                    }
                    if (this.exclusive) {
                        consumer = this.consumerList.get((int)0).consumer;
                    }
                    if ((status = this.handle(ref, consumer)) == HandleStatus.HANDLED) {
                        this.deliveriesInTransit.countUp();
                        handledconsumer = consumer;
                        holder.iter.remove();
                        this.refRemoved(ref);
                        if (groupID != null && groupConsumer == null) {
                            this.groups.put(groupID, consumer);
                        }
                        ++handled;
                    } else if (status == HandleStatus.BUSY) {
                        try {
                            holder.iter.repeat();
                        }
                        catch (NoSuchElementException e) {
                            logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                        ++noDelivery;
                    } else if (status == HandleStatus.NO_MATCH) {
                        // empty if block
                    }
                }
                if (this.pos == endPos) {
                    if (noDelivery == size) {
                        if (handledconsumer != null) {
                            ActiveMQServerLogger.LOGGER.nonDeliveryHandled();
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)(this + "::All the consumers were busy, giving up now"));
                            }
                            break;
                        }
                    }
                    noDelivery = 0;
                }
                if (!this.exclusive && groupConsumer == null) {
                    ++this.pos;
                }
                if (this.pos >= size) {
                    this.pos = 0;
                }
            }
            if (handledconsumer == null) continue;
            this.proceedDeliver(handledconsumer, ref);
        }
        this.checkDepage();
    }

    private void checkDepage() {
        if (this.pageIterator != null && this.pageSubscription.isPaging() && !this.depagePending && this.needsDepage() && this.pageIterator.hasNext()) {
            this.scheduleDepage(false);
        }
    }

    private boolean needsDepage() {
        return (long)this.queueMemorySize.get() < this.pageSubscription.getPagingStore().getMaxSize();
    }

    private SimpleString extractGroupID(MessageReference ref) {
        if (this.internalQueue) {
            return null;
        }
        try {
            return ref.getMessage().getGroupID();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToExtractGroupID(e);
            return null;
        }
    }

    protected void refRemoved(MessageReference ref) {
        this.queueMemorySize.addAndGet(-ref.getMessageMemoryEstimate());
        this.pendingMetrics.decrementMetrics(ref);
        if (ref.isPaged()) {
            this.pagedReferences.decrementAndGet();
        }
    }

    protected void refAdded(MessageReference ref) {
        if (ref.isPaged()) {
            this.pagedReferences.incrementAndGet();
        }
    }

    private void scheduleDepage(boolean scheduleExpiry) {
        if (!this.depagePending) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Scheduling depage for queue " + this.getName()));
            }
            this.depagePending = true;
            this.pageSubscription.getExecutor().execute((Runnable)new DepageRunner(scheduleExpiry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void depage(boolean scheduleExpiry) {
        this.depagePending = false;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (this.paused || this.pageIterator == null) {
                return;
            }
        }
        long maxSize = this.pageSubscription.getPagingStore().getPageSizeBytes();
        long timeout = System.currentTimeMillis() + 1000L;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("QueueMemorySize before depage on queue=" + this.getName() + " is " + this.queueMemorySize.get()));
        }
        this.directDeliver = false;
        int depaged = 0;
        while (timeout > System.currentTimeMillis() && this.needsDepage() && this.pageIterator.hasNext()) {
            ++depaged;
            PagedReference reference = (PagedReference)this.pageIterator.next();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Depaging reference " + reference + " on queue " + this.getName()));
            }
            this.addTail(reference, false);
            this.pageIterator.remove();
            this.pageSubscription.incrementDeliveredSize(this.getPersistentSize(reference));
        }
        if (logger.isDebugEnabled()) {
            if (depaged == 0 && (long)this.queueMemorySize.get() >= maxSize) {
                logger.debug((Object)"Couldn't depage any message as the maxSize on the queue was achieved. There are too many pending messages to be acked in reference to the page configuration");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Queue Memory Size after depage on queue=" + this.getName() + " is " + this.queueMemorySize.get() + " with maxSize = " + maxSize + ". Depaged " + depaged + " messages, pendingDelivery=" + this.messageReferences.size() + ", intermediateMessageReferences= " + this.intermediateMessageReferences.size() + ", queueDelivering=" + this.deliveringMetrics.getMessageCount()));
            }
        }
        this.deliverAsync();
        if (depaged > 0 && scheduleExpiry) {
            this.expireReferences();
        }
    }

    private void internalAddRedistributor(ArtemisExecutor executor) {
        if (this.consumerSet.isEmpty() && this.redistributor == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("QueueImpl::Adding redistributor on queue " + this.toString()));
            }
            this.redistributor = new Redistributor(this, this.storageManager, this.postOffice, (Executor)executor, 100);
            this.consumerList.add(new ConsumerHolder(this.redistributor));
            this.consumersChanged = true;
            this.redistributor.start();
            this.deliverAsync();
        }
    }

    @Override
    public boolean checkRedelivery(MessageReference reference, long timeBase, boolean ignoreRedeliveryDelay) throws Exception {
        Message message = reference.getMessage();
        if (this.internalQueue) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Queue " + this.getName() + " is an internal queue, no checkRedelivery"));
            }
            return true;
        }
        if (!this.internalQueue && message.isDurable() && this.isDurableMessage() && !reference.isPaged()) {
            this.storageManager.updateDeliveryCount(reference);
        }
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(this.address.toString());
        int maxDeliveries = addressSettings.getMaxDeliveryAttempts();
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        int deliveryCount = reference.getDeliveryCount();
        if (maxDeliveries > 0 && deliveryCount >= maxDeliveries) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Sending reference " + reference + " to DLA = " + addressSettings.getDeadLetterAddress() + " since ref.getDeliveryCount=" + reference.getDeliveryCount() + "and maxDeliveries=" + maxDeliveries + " from queue=" + this.getName()));
            }
            this.sendToDeadLetterAddress(null, reference, addressSettings.getDeadLetterAddress());
            return false;
        }
        if (!ignoreRedeliveryDelay && redeliveryDelay > 0L) {
            redeliveryDelay = this.calculateRedeliveryDelay(addressSettings, deliveryCount);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Setting redeliveryDelay=" + redeliveryDelay + " on reference=" + reference));
            }
            reference.setScheduledDeliveryTime(timeBase + redeliveryDelay);
            if (!reference.isPaged() && message.isDurable() && this.isDurableMessage()) {
                this.storageManager.updateScheduledDeliveryTime(reference);
            }
        }
        this.decDelivering(reference);
        return true;
    }

    public int getNumberOfReferences() {
        return this.messageReferences.size();
    }

    private void move(SimpleString toAddress, Transaction tx, MessageReference ref, boolean expiry, boolean rejectDuplicate, long ... queueIDs) throws Exception {
        Message copyMessage = this.makeCopy(ref, expiry);
        copyMessage.setAddress(toAddress);
        if (queueIDs != null && queueIDs.length > 0) {
            ByteBuffer buffer = ByteBuffer.allocate(8 * queueIDs.length);
            for (long id : queueIDs) {
                buffer.putLong(id);
            }
            copyMessage.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), buffer.array());
        }
        this.postOffice.route(copyMessage, tx, false, rejectDuplicate);
        if (expiry) {
            this.acknowledge(tx, ref, AckReason.EXPIRED, null);
        } else {
            this.acknowledge(tx, ref);
        }
    }

    private void moveBetweenSnFQueues(SimpleString queueSuffix, Transaction tx, MessageReference ref) throws Exception {
        Message copyMessage = this.makeCopy(ref, false, false);
        byte[] oldRouteToIDs = null;
        for (SimpleString propName : copyMessage.getPropertyNames()) {
            if (!propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
            oldRouteToIDs = (byte[])copyMessage.removeProperty(propName.toString());
            String hashcodeToString = oldRouteToIDs.toString();
            logger.debug((Object)("Removed property from message: " + propName + " = " + hashcodeToString + " (" + ByteBuffer.wrap(oldRouteToIDs).getLong() + ")"));
            break;
        }
        ByteBuffer oldBuffer = ByteBuffer.wrap(oldRouteToIDs);
        RoutingContextImpl routingContext = new RoutingContextImpl(tx);
        while (oldBuffer.hasRemaining()) {
            long oldQueueID = oldBuffer.getLong();
            Pair<String, Binding> result = this.locateTargetBinding(queueSuffix, copyMessage, oldQueueID);
            Binding targetBinding = (Binding)result.getB();
            String targetNodeID = (String)result.getA();
            if (targetBinding == null) {
                ActiveMQServerLogger.LOGGER.unableToFindTargetQueue(targetNodeID);
                continue;
            }
            logger.debug((Object)("Routing on binding: " + targetBinding));
            targetBinding.route(copyMessage, routingContext);
        }
        this.postOffice.processRoute(copyMessage, routingContext, false);
        ref.handled();
        this.acknowledge(tx, ref);
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.ioErrorRedistributing(errorCode, errorMessage);
            }

            public void done() {
                QueueImpl.this.deliverAsync();
            }
        });
    }

    private Pair<String, Binding> locateTargetBinding(SimpleString queueSuffix, Message copyMessage, long oldQueueID) {
        String targetNodeID = null;
        RemoteQueueBinding targetBinding = null;
        block0: for (Map.Entry<SimpleString, Binding> entry : this.postOffice.getAllBindings().entrySet()) {
            RemoteQueueBinding remoteQueueBinding;
            Binding binding = entry.getValue();
            if (!(binding instanceof RemoteQueueBinding) || oldQueueID != (remoteQueueBinding = (RemoteQueueBinding)binding).getRemoteQueueID()) continue;
            SimpleString oldQueueName = remoteQueueBinding.getRoutingName();
            String temp = remoteQueueBinding.getQueue().getName().toString();
            targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
            logger.debug((Object)("Message formerly destined for " + oldQueueName + " with ID: " + oldQueueID + " on address " + copyMessage.getAddressSimpleString() + " on node " + targetNodeID));
            for (Map.Entry<SimpleString, Binding> entry2 : this.postOffice.getAllBindings().entrySet()) {
                binding = entry2.getValue();
                if (!(binding instanceof RemoteQueueBinding)) continue;
                remoteQueueBinding = (RemoteQueueBinding)binding;
                temp = remoteQueueBinding.getQueue().getName().toString();
                targetNodeID = temp.substring(temp.lastIndexOf(".") + 1);
                if (oldQueueName.equals((Object)remoteQueueBinding.getRoutingName()) && targetNodeID.equals(queueSuffix.toString())) {
                    targetBinding = remoteQueueBinding;
                    if (!logger.isDebugEnabled()) continue block0;
                    logger.debug((Object)("Message now destined for " + remoteQueueBinding.getRoutingName() + " with ID: " + remoteQueueBinding.getRemoteQueueID() + " on address " + copyMessage.getAddress() + " on node " + targetNodeID));
                    continue block0;
                }
                logger.debug((Object)("Failed to match: " + remoteQueueBinding));
            }
        }
        return new Pair(targetNodeID, targetBinding);
    }

    private Message makeCopy(MessageReference ref, boolean expiry) throws Exception {
        return this.makeCopy(ref, expiry, true);
    }

    private Message makeCopy(MessageReference ref, boolean expiry, boolean copyOriginalHeaders) throws Exception {
        if (ref == null) {
            ActiveMQServerLogger.LOGGER.nullRefMessage();
            throw new ActiveMQNullRefException("Reference to message is null");
        }
        Message message = ref.getMessage();
        long newID = this.storageManager.generateID();
        Message copy = message.copy(newID);
        if (copyOriginalHeaders) {
            copy.referenceOriginalMessage(message, ref.getQueue().getName().toString());
        }
        copy.setExpiration(0L);
        if (expiry) {
            copy.setAnnotation(Message.HDR_ACTUAL_EXPIRY_TIME, (Object)System.currentTimeMillis());
        }
        copy.reencode();
        return copy;
    }

    private void expire(Transaction tx, MessageReference ref) throws Exception {
        SimpleString expiryAddress = this.addressSettingsRepository.getMatch(this.address.toString()).getExpiryAddress();
        if (expiryAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(expiryAddress);
            if (bindingList.getBindings().isEmpty()) {
                ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoBindings(expiryAddress);
                this.acknowledge(tx, ref, AckReason.EXPIRED, null);
            } else {
                this.move(expiryAddress, tx, ref, true, true, new long[0]);
            }
        } else {
            if (!this.printErrorExpiring) {
                this.printErrorExpiring = true;
                ActiveMQServerLogger.LOGGER.errorExpiringReferencesNoQueue(this.name);
            }
            this.acknowledge(tx, ref, AckReason.EXPIRED, null);
        }
    }

    @Override
    public void sendToDeadLetterAddress(Transaction tx, MessageReference ref) throws Exception {
        this.sendToDeadLetterAddress(tx, ref, this.addressSettingsRepository.getMatch(this.address.toString()).getDeadLetterAddress());
    }

    private void sendToDeadLetterAddress(Transaction tx, MessageReference ref, SimpleString deadLetterAddress) throws Exception {
        if (deadLetterAddress != null) {
            Bindings bindingList = this.postOffice.getBindingsForAddress(deadLetterAddress);
            if (bindingList.getBindings().isEmpty()) {
                ActiveMQServerLogger.LOGGER.messageExceededMaxDelivery(ref, deadLetterAddress);
                ref.acknowledge(tx, AckReason.KILLED, null);
            } else {
                ActiveMQServerLogger.LOGGER.messageExceededMaxDeliverySendtoDLA(ref, deadLetterAddress, this.name);
                this.move(tx, deadLetterAddress, null, ref, false, AckReason.KILLED, null);
            }
        } else {
            ActiveMQServerLogger.LOGGER.messageExceededMaxDeliveryNoDLA(ref, this.name);
            ref.acknowledge(tx, AckReason.KILLED, null);
        }
    }

    private void move(Transaction originalTX, SimpleString address, Binding binding, MessageReference ref, boolean rejectDuplicate, AckReason reason, ServerConsumer consumer) throws Exception {
        Transaction tx = originalTX != null ? originalTX : new TransactionImpl(this.storageManager);
        Message copyMessage = this.makeCopy(ref, reason == AckReason.EXPIRED);
        copyMessage.setAddress(address);
        this.postOffice.route(copyMessage, tx, false, rejectDuplicate, binding);
        this.acknowledge(tx, ref, reason, consumer);
        if (originalTX == null) {
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deliverDirect(MessageReference ref) {
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            if (!this.supportsDirectDeliver) {
                return false;
            }
            if (this.paused || this.consumerList.isEmpty()) {
                return false;
            }
            if (this.checkExpired(ref)) {
                return true;
            }
            int startPos = this.pos;
            int size = this.consumerList.size();
            do {
                HandleStatus status;
                ConsumerHolder holder = this.consumerList.get(this.pos);
                Consumer consumer = holder.consumer;
                Consumer groupConsumer = null;
                SimpleString groupID = this.extractGroupID(ref);
                if (groupID != null && (groupConsumer = this.groups.get(groupID)) != null) {
                    consumer = groupConsumer;
                }
                if (this.exclusive) {
                    consumer = this.consumerList.get((int)0).consumer;
                }
                if (!this.exclusive && groupConsumer == null) {
                    ++this.pos;
                }
                if (this.pos == size) {
                    this.pos = 0;
                }
                if ((status = this.handle(ref, consumer)) != HandleStatus.HANDLED) continue;
                if (groupID != null && groupConsumer == null) {
                    this.groups.put(groupID, consumer);
                }
                this.messagesAdded.incrementAndGet();
                this.deliveriesInTransit.countUp();
                this.proceedDeliver(consumer, ref);
                return true;
            } while (this.pos != startPos);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void proceedDeliver(Consumer consumer, MessageReference reference) {
        try {
            consumer.proceedDeliver(reference);
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.removingBadConsumer(t, consumer, reference);
            QueueImpl queueImpl = this;
            synchronized (queueImpl) {
                try {
                    this.removeConsumer(consumer);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
                }
                this.addHead(reference, false);
            }
        }
        finally {
            this.deliveriesInTransit.countDown();
        }
    }

    private boolean checkExpired(MessageReference reference) {
        try {
            if (reference.getMessage().isExpired()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Reference " + reference + " is expired"));
                }
                reference.handled();
                try {
                    this.expire(reference);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorExpiringRef(e);
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToCheckIfMessageExpired(e);
            return false;
        }
    }

    private synchronized HandleStatus handle(MessageReference reference, Consumer consumer) {
        HandleStatus status;
        try {
            status = consumer.handle(reference);
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.removingBadConsumer(t, consumer, reference);
            try {
                this.removeConsumer(consumer);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingConsumer(e);
            }
            return HandleStatus.BUSY;
        }
        if (status == null) {
            throw new IllegalStateException("ClientConsumer.handle() should never return null");
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConsumerHolder> cloneConsumersList() {
        ArrayList<ConsumerHolder> consumerListClone;
        QueueImpl queueImpl = this;
        synchronized (queueImpl) {
            consumerListClone = new ArrayList<ConsumerHolder>(this.consumerList);
        }
        return consumerListClone;
    }

    @Override
    public void postAcknowledge(MessageReference ref) {
        int count;
        Message message;
        QueueImpl queue = (QueueImpl)ref.getQueue();
        queue.decDelivering(ref);
        if (ref.isPaged()) {
            return;
        }
        try {
            message = ref.getMessage();
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.unableToPerformPostAcknowledge(e);
            message = null;
        }
        if (message == null) {
            return;
        }
        boolean durableRef = message.isDurable() && queue.isDurableMessage();
        try {
            message.decrementRefCount();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorDecrementingRefCount(e);
        }
        if (durableRef && (count = message.decrementDurableRefCount()) == 0) {
            try {
                this.storageManager.deleteMessage(message.getMessageID());
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingMessage(e, message.getMessageID());
            }
        }
    }

    void postRollback(LinkedList<MessageReference> refs) {
        if (this.purgeOnNoConsumers && this.getConsumerCount() == 0) {
            this.purgeAfterRollback(refs);
            return;
        }
        this.addHead(refs, false);
    }

    private void purgeAfterRollback(LinkedList<MessageReference> refs) {
        try {
            TransactionImpl transaction = new TransactionImpl(this.storageManager);
            for (MessageReference reference : refs) {
                this.incDelivering(reference);
                this.acknowledge(transaction, reference, AckReason.KILLED, null);
            }
            transaction.commit();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private long calculateRedeliveryDelay(AddressSettings addressSettings, int deliveryCount) {
        int tmpDeliveryCount;
        long redeliveryDelay = addressSettings.getRedeliveryDelay();
        long maxRedeliveryDelay = addressSettings.getMaxRedeliveryDelay();
        double redeliveryMultiplier = addressSettings.getRedeliveryMultiplier();
        long delay = (long)((double)redeliveryDelay * Math.pow(redeliveryMultiplier, tmpDeliveryCount = deliveryCount > 0 ? deliveryCount - 1 : 0));
        if (delay > maxRedeliveryDelay) {
            delay = maxRedeliveryDelay;
        }
        return delay;
    }

    @Override
    public synchronized void resetMessagesAdded() {
        this.messagesAdded.set(0L);
    }

    @Override
    public synchronized void resetMessagesAcknowledged() {
        this.messagesAcknowledged.set(0L);
    }

    @Override
    public synchronized void resetMessagesExpired() {
        this.messagesExpired.set(0L);
    }

    @Override
    public synchronized void resetMessagesKilled() {
        this.messagesKilled.set(0L);
    }

    @Override
    public float getRate() {
        long locaMessageAdded = this.getMessagesAdded();
        float timeSlice = (float)(System.currentTimeMillis() - this.queueRateCheckTime.getAndSet(System.currentTimeMillis())) / 1000.0f;
        if (timeSlice == 0.0f) {
            this.messagesAddedSnapshot.getAndSet(locaMessageAdded);
            return 0.0f;
        }
        return BigDecimal.valueOf((float)(locaMessageAdded - this.messagesAddedSnapshot.getAndSet(locaMessageAdded)) / timeSlice).setScale(2, 0).floatValue();
    }

    @Override
    public void recheckRefCount(OperationContext context) {
        final ReferenceCounter refCount = this.refCountForConsumers;
        if (refCount != null) {
            context.executeOnCompletion(new IOCallback(){

                public void done() {
                    refCount.check();
                }

                public void onError(int errorCode, String errorMessage) {
                }
            });
        }
    }

    private void incDelivering(MessageReference ref) {
        this.deliveringMetrics.incrementMetrics(ref);
    }

    public void decDelivering(MessageReference reference) {
        this.deliveringMetrics.decrementMetrics(reference);
    }

    private long getPersistentSize(MessageReference reference) {
        long size = 0L;
        try {
            size = reference.getPersistentSize() > 0L ? reference.getPersistentSize() : 0L;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
        }
        return size;
    }

    private void configureExpiry(AddressSettings settings) {
        this.expiryAddress = settings == null ? null : settings.getExpiryAddress();
    }

    private void configureSlowConsumerReaper(AddressSettings settings) {
        if (settings == null || settings.getSlowConsumerThreshold() == -1L) {
            if (this.slowConsumerReaperFuture != null) {
                this.slowConsumerReaperFuture.cancel(false);
                this.slowConsumerReaperFuture = null;
                this.slowConsumerReaperRunnable = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cancelled slow-consumer-reaper thread for queue \"" + this.getName() + "\""));
                }
            }
        } else if (this.slowConsumerReaperRunnable == null) {
            this.scheduleSlowConsumerReaper(settings);
        } else if (this.slowConsumerReaperRunnable.checkPeriod != settings.getSlowConsumerCheckPeriod() || this.slowConsumerReaperRunnable.threshold != (float)settings.getSlowConsumerThreshold() || !this.slowConsumerReaperRunnable.policy.equals((Object)settings.getSlowConsumerPolicy())) {
            this.slowConsumerReaperFuture.cancel(false);
            this.scheduleSlowConsumerReaper(settings);
        }
    }

    void scheduleSlowConsumerReaper(AddressSettings settings) {
        this.slowConsumerReaperRunnable = new SlowConsumerReaperRunnable(settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerThreshold(), settings.getSlowConsumerPolicy());
        this.slowConsumerReaperFuture = this.scheduledExecutor.scheduleWithFixedDelay(this.slowConsumerReaperRunnable, settings.getSlowConsumerCheckPeriod(), settings.getSlowConsumerCheckPeriod(), TimeUnit.SECONDS);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scheduled slow-consumer-reaper thread for queue \"" + this.getName() + "\"; slow-consumer-check-period=" + settings.getSlowConsumerCheckPeriod() + ", slow-consumer-threshold=" + settings.getSlowConsumerThreshold() + ", slow-consumer-policy=" + (Object)((Object)settings.getSlowConsumerPolicy())));
        }
    }

    private void checkDeadLetterAddressAndExpiryAddress(AddressSettings settings) {
        if (!(Env.isTestEnv() || this.internalQueue || this.address.equals((Object)this.server.getConfiguration().getManagementNotificationAddress()))) {
            if (settings.getDeadLetterAddress() == null) {
                ActiveMQServerLogger.LOGGER.AddressSettingsNoDLA(this.name);
            }
            if (settings.getExpiryAddress() == null) {
                ActiveMQServerLogger.LOGGER.AddressSettingsNoExpiryAddress(this.name);
            }
        }
    }

    private final class SlowConsumerReaperRunnable
    implements Runnable {
        private final SlowConsumerPolicy policy;
        private final float threshold;
        private final long checkPeriod;

        private SlowConsumerReaperRunnable(long checkPeriod, float threshold, SlowConsumerPolicy policy) {
            this.checkPeriod = checkPeriod;
            this.policy = policy;
            this.threshold = threshold;
        }

        @Override
        public void run() {
            Collection consumersSet;
            float queueRate = QueueImpl.this.getRate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(QueueImpl.this.getAddress() + ":" + QueueImpl.this.getName() + " has " + QueueImpl.this.getConsumerCount() + " consumer(s) and is receiving messages at a rate of " + queueRate + " msgs/second."));
            }
            if ((consumersSet = QueueImpl.this.getConsumers()).size() == 0) {
                logger.debug((Object)"There are no consumers, no need to check slow consumer's rate");
                return;
            }
            if (queueRate < this.threshold * (float)consumersSet.size()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Insufficient messages received on queue \"" + QueueImpl.this.getName() + "\" to satisfy slow-consumer-threshold. Skipping inspection of consumer."));
                }
                return;
            }
            for (Consumer consumer : consumersSet) {
                if (!(consumer instanceof ServerConsumerImpl)) continue;
                ServerConsumerImpl serverConsumer = (ServerConsumerImpl)consumer;
                float consumerRate = serverConsumer.getRate();
                if (queueRate < this.threshold) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Insufficient messages received on queue \"" + QueueImpl.this.getName() + "\" to satisfy slow-consumer-threshold. Skipping inspection of consumer."));
                    continue;
                }
                if (!(consumerRate < this.threshold)) continue;
                RemotingConnection connection = null;
                ActiveMQServer server = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer();
                RemotingService remotingService = server.getRemotingService();
                for (RemotingConnection potentialConnection : remotingService.getConnections()) {
                    if (!potentialConnection.getID().toString().equals(serverConsumer.getConnectionID())) continue;
                    connection = potentialConnection;
                }
                serverConsumer.fireSlowConsumer();
                if (connection == null) continue;
                ActiveMQServerLogger.LOGGER.slowConsumerDetected(serverConsumer.getSessionID(), serverConsumer.getID(), QueueImpl.this.getName().toString(), connection.getRemoteAddress(), this.threshold, consumerRate);
                if (this.policy.equals((Object)SlowConsumerPolicy.KILL)) {
                    connection.killMessage(server.getNodeID());
                    remotingService.removeConnection(connection.getID());
                    connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsClosedByManagement(connection.getRemoteAddress()));
                    continue;
                }
                if (!this.policy.equals((Object)SlowConsumerPolicy.NOTIFY)) continue;
                TypedProperties props = new TypedProperties();
                props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, QueueImpl.this.getConsumerCount());
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, QueueImpl.this.address);
                props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)connection.getRemoteAddress()));
                if (connection.getID() != null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_CONNECTION_NAME, SimpleString.toSimpleString((String)connection.getID().toString()));
                }
                props.putLongProperty(ManagementHelper.HDR_CONSUMER_NAME, serverConsumer.getID());
                props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)serverConsumer.getSessionID()));
                Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_SLOW, props);
                ManagementService managementService = ((PostOfficeImpl)QueueImpl.this.postOffice).getServer().getManagementService();
                try {
                    managementService.sendNotification(notification);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.failedToSendSlowConsumerNotification(notification, e);
                }
            }
        }
    }

    private class AddressSettingsRepositoryListener
    implements HierarchicalRepositoryChangeListener {
        private AddressSettingsRepositoryListener() {
        }

        @Override
        public void onChange() {
            AddressSettings settings = (AddressSettings)QueueImpl.this.addressSettingsRepository.getMatch(QueueImpl.this.address.toString());
            QueueImpl.this.configureExpiry(settings);
            QueueImpl.this.checkDeadLetterAddressAndExpiryAddress(settings);
            QueueImpl.this.configureSlowConsumerReaper(settings);
        }
    }

    private class QueueBrowserIterator
    implements LinkedListIterator<MessageReference> {
        LinkedListIterator<PagedReference> pagingIterator = null;
        LinkedListIterator<MessageReference> messagesIterator = null;
        Iterator lastIterator = null;
        MessageReference cachedNext = null;
        HashSet<PagePosition> previouslyBrowsed = new HashSet();

        private LinkedListIterator<PagedReference> getPagingIterator() {
            if (this.pagingIterator == null) {
                this.pagingIterator = QueueImpl.this.pageSubscription.iterator(true);
            }
            return this.pagingIterator;
        }

        private QueueBrowserIterator() {
            this.messagesIterator = new SynchronizedIterator((LinkedListIterator<MessageReference>)QueueImpl.this.messageReferences.iterator());
        }

        public boolean hasNext() {
            if (this.messagesIterator != null && this.messagesIterator.hasNext()) {
                this.lastIterator = this.messagesIterator;
                return true;
            }
            if (this.getPagingIterator() != null && this.getPagingIterator().hasNext()) {
                this.lastIterator = this.getPagingIterator();
                return true;
            }
            return false;
        }

        public MessageReference next() {
            if (this.cachedNext != null) {
                try {
                    MessageReference messageReference = this.cachedNext;
                    return messageReference;
                }
                finally {
                    this.cachedNext = null;
                }
            }
            if (this.messagesIterator != null && this.messagesIterator.hasNext()) {
                MessageReference msg = (MessageReference)this.messagesIterator.next();
                if (msg.isPaged()) {
                    this.previouslyBrowsed.add(((PagedReference)msg).getPosition());
                }
                return msg;
            }
            if (this.getPagingIterator() != null) {
                while (this.getPagingIterator().hasNext()) {
                    this.lastIterator = this.getPagingIterator();
                    PagedReference ref = (PagedReference)this.getPagingIterator().next();
                    if (this.previouslyBrowsed.contains(ref.getPosition())) continue;
                    return ref;
                }
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastIterator != null) {
                this.lastIterator.remove();
            }
        }

        public void repeat() {
        }

        public void close() {
            if (this.getPagingIterator() != null) {
                this.getPagingIterator().close();
            }
            if (this.messagesIterator != null) {
                this.messagesIterator.close();
            }
        }
    }

    private class SynchronizedIterator
    implements LinkedListIterator<MessageReference> {
        private final LinkedListIterator<MessageReference> iter;

        SynchronizedIterator(LinkedListIterator<MessageReference> iter) {
            this.iter = iter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repeat() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.repeat();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return this.iter.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageReference next() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                return (MessageReference)this.iter.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                this.iter.remove();
            }
        }
    }

    abstract class QueueIterateAction {
        QueueIterateAction() {
        }

        public abstract void actMessage(Transaction var1, MessageReference var2) throws Exception;

        public void actMessage(Transaction tx, MessageReference ref, boolean fromMessageReferences) throws Exception {
            this.actMessage(tx, ref);
        }
    }

    private final class DepageRunner
    implements Runnable {
        final boolean scheduleExpiry;

        private DepageRunner(boolean scheduleExpiry) {
            this.scheduleExpiry = scheduleExpiry;
        }

        @Override
        public void run() {
            try {
                QueueImpl.this.depage(this.scheduleExpiry);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorDelivering(e);
            }
        }
    }

    private final class DeliverRunner
    implements Runnable {
        private DeliverRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                QueueImpl.this.enterCritical(2);
                try {
                    Runnable runnable = QueueImpl.this.deliverRunner;
                    synchronized (runnable) {
                        QueueImpl.this.deliver();
                    }
                }
                finally {
                    QueueImpl.this.leaveCritical(2);
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorDelivering(e);
            }
            finally {
                QueueImpl.this.scheduledRunners.decrementAndGet();
            }
        }
    }

    private class DelayedAddRedistributor
    implements Runnable {
        private final ArtemisExecutor executor1;

        DelayedAddRedistributor(ArtemisExecutor executor) {
            this.executor1 = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                QueueImpl.this.internalAddRedistributor(this.executor1);
                QueueImpl.this.clearRedistributorFuture();
            }
        }
    }

    private static class ConsumerHolder {
        final Consumer consumer;
        LinkedListIterator<MessageReference> iter;

        ConsumerHolder(Consumer consumer) {
            this.consumer = consumer;
        }
    }

    class ExpiryScanner
    implements Runnable {
        public AtomicInteger scannerRunning = new AtomicInteger(0);

        ExpiryScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueueImpl queueImpl = QueueImpl.this;
            synchronized (queueImpl) {
                if (QueueImpl.this.queueDestroyed) {
                    return;
                }
                logger.debug((Object)("Scanning for expires on " + QueueImpl.this.getName()));
                LinkedListIterator<MessageReference> iter = QueueImpl.this.iterator();
                boolean expired = false;
                boolean hasElements = false;
                int elementsExpired = 0;
                try {
                    Transaction tx = null;
                    while (QueueImpl.this.postOffice.isStarted() && iter.hasNext()) {
                        hasElements = true;
                        MessageReference ref = (MessageReference)iter.next();
                        try {
                            if (!ref.getMessage().isExpired()) continue;
                            if (tx == null) {
                                tx = new TransactionImpl(QueueImpl.this.storageManager);
                            }
                            QueueImpl.this.incDelivering(ref);
                            expired = true;
                            QueueImpl.this.expire(tx, ref);
                            iter.remove();
                            QueueImpl.this.refRemoved(ref);
                            if (++elementsExpired < 1000) continue;
                            logger.debug((Object)"Breaking loop of expiring");
                            this.scannerRunning.incrementAndGet();
                            QueueImpl.this.getExecutor().execute((Runnable)this);
                            break;
                        }
                        catch (Exception e) {
                            ActiveMQServerLogger.LOGGER.errorExpiringReferencesOnQueue(e, ref);
                        }
                    }
                    logger.debug((Object)("Expired " + elementsExpired + " references"));
                    try {
                        if (tx != null) {
                            tx.commit();
                        }
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableToCommitTransaction(e);
                    }
                    if ((!hasElements || expired) && QueueImpl.this.pageIterator != null && QueueImpl.this.pageIterator.hasNext()) {
                        QueueImpl.this.scheduleDepage(true);
                    }
                }
                finally {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable) {}
                    this.scannerRunning.decrementAndGet();
                    logger.debug((Object)("Scanning for expires on " + QueueImpl.this.getName() + " done"));
                }
            }
        }
    }
}

