/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.ClusterControl;
import org.apache.activemq.artemis.core.server.cluster.ClusterController;
import org.apache.activemq.artemis.core.server.impl.RefsOperation;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.jboss.logging.Logger;

public class ScaleDownHandler {
    private static final Logger logger = Logger.getLogger(ScaleDownHandler.class);
    final PagingManager pagingManager;
    final PostOffice postOffice;
    private NodeManager nodeManager;
    private final ClusterController clusterController;
    private final StorageManager storageManager;
    private String targetNodeId;

    public ScaleDownHandler(PagingManager pagingManager, PostOffice postOffice, NodeManager nodeManager, ClusterController clusterController, StorageManager storageManager) {
        this.pagingManager = pagingManager;
        this.postOffice = postOffice;
        this.nodeManager = nodeManager;
        this.clusterController = clusterController;
        this.storageManager = storageManager;
    }

    public long scaleDown(ClientSessionFactory sessionFactory, ResourceManager resourceManager, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, SimpleString managementAddress, SimpleString targetNodeId) throws Exception {
        ClusterControl clusterControl = this.clusterController.connectToNodeInCluster((ClientSessionFactoryInternal)sessionFactory);
        clusterControl.authorize();
        long num = this.scaleDownMessages(sessionFactory, targetNodeId, clusterControl.getClusterUser(), clusterControl.getClusterPassword());
        ActiveMQServerLogger.LOGGER.infoScaledDownMessages(num);
        this.scaleDownTransactions(sessionFactory, resourceManager, clusterControl.getClusterUser(), clusterControl.getClusterPassword());
        this.scaleDownDuplicateIDs(duplicateIDMap, sessionFactory, managementAddress, clusterControl.getClusterUser(), clusterControl.getClusterPassword());
        clusterControl.announceScaleDown(new SimpleString(this.targetNodeId), this.nodeManager.getNodeId());
        return num;
    }

    public long scaleDownMessages(ClientSessionFactory sessionFactory, SimpleString nodeId, String user, String password) throws Exception {
        long messageCount = 0L;
        this.targetNodeId = nodeId != null ? nodeId.toString() : this.getTargetNodeId(sessionFactory);
        try (ClientSession session = sessionFactory.createSession(user, password, false, true, true, false, 0);){
            ClientProducer producer = session.createProducer();
            for (SimpleString address : this.postOffice.getAddresses()) {
                logger.debug((Object)("Scaling down address " + address));
                Bindings bindings = this.postOffice.getBindingsForAddress(address);
                TreeSet<Queue> queues = new TreeSet<Queue>(new OrderQueueByNumberOfReferencesComparator());
                for (Binding binding : bindings.getBindings()) {
                    if (!(binding instanceof LocalQueueBinding)) continue;
                    Queue queue = ((LocalQueueBinding)binding).getQueue();
                    queue.deliverScheduledMessages();
                    queues.add(queue);
                }
                String sfPrefix = ((PostOfficeImpl)this.postOffice).getServer().getInternalNamingPrefix() + "sf.";
                if (address.toString().startsWith(sfPrefix)) {
                    messageCount += this.scaleDownSNF(address, queues, producer);
                    continue;
                }
                messageCount += this.scaleDownRegularMessages(address, queues, session, producer);
            }
        }
        return messageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scaleDownRegularMessages(SimpleString address, Set<Queue> queues, ClientSession clientSession, ClientProducer producer) throws Exception {
        logger.debug((Object)("Scaling down messages on address " + address));
        long messageCount = 0L;
        HashMap<Queue, QueuesXRefInnerManager> controls = new HashMap<Queue, QueuesXRefInnerManager>();
        PagingStore pageStore = this.pagingManager.getPageStore(address);
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        pageStore.disableCleanup();
        try {
            for (Queue queue : queues) {
                controls.put(queue, new QueuesXRefInnerManager(clientSession, queue, pageStore));
            }
            for (Queue loopQueue : queues) {
                logger.debug((Object)("Scaling down messages on address " + address + " / performing loop on queue " + loopQueue));
                try {
                    LinkedListIterator<MessageReference> messagesIterator = loopQueue.browserIterator();
                    Throwable throwable = null;
                    try {
                        while (messagesIterator.hasNext()) {
                            MessageReference messageReference = (MessageReference)messagesIterator.next();
                            Message message = messageReference.getMessage().copy();
                            logger.debug((Object)("Reading message " + message + " from queue " + loopQueue));
                            HashSet<QueuesXRefInnerManager> queuesFound = new HashSet<QueuesXRefInnerManager>();
                            for (Map.Entry controlEntry : controls.entrySet()) {
                                if (controlEntry.getKey() == loopQueue) {
                                    queuesFound.add((QueuesXRefInnerManager)controlEntry.getValue());
                                    continue;
                                }
                                if (!((QueuesXRefInnerManager)controlEntry.getValue()).lookup(messageReference)) continue;
                                logger.debug((Object)("Message existed on queue " + ((Queue)controlEntry.getKey()).getID() + " removeID=" + ((QueuesXRefInnerManager)controlEntry.getValue()).getQueueID()));
                                queuesFound.add((QueuesXRefInnerManager)controlEntry.getValue());
                            }
                            ByteBuffer buffer = ByteBuffer.allocate(queuesFound.size() * 8);
                            for (QueuesXRefInnerManager control : queuesFound) {
                                long queueID = control.getQueueID();
                                buffer.putLong(queueID);
                            }
                            message.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), buffer.array());
                            if (logger.isDebugEnabled()) {
                                if (messageReference.isPaged()) {
                                    logger.debug((Object)("*********************<<<<< Scaling down pdgmessage " + message));
                                } else {
                                    logger.debug((Object)("*********************<<<<< Scaling down message " + message));
                                }
                            }
                            producer.send(address, message);
                            ++messageCount;
                            messagesIterator.remove();
                            for (QueuesXRefInnerManager queueFound : queuesFound) {
                                this.ackMessageOnQueue(tx, queueFound.getQueue(), messageReference);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (messagesIterator == null) continue;
                        if (throwable != null) {
                            try {
                                messagesIterator.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        messagesIterator.close();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            tx.commit();
            for (QueuesXRefInnerManager controlRemoved : controls.values()) {
                controlRemoved.close();
            }
            long l = messageCount;
            return l;
        }
        finally {
            pageStore.enableCleanup();
            pageStore.getCursorProvider().scheduleCleanup();
        }
    }

    private long scaleDownSNF(SimpleString address, Set<Queue> queues, ClientProducer producer) throws Exception {
        long messageCount = 0L;
        boolean queueOnTarget = address.toString().endsWith(this.targetNodeId);
        String propertyEnd = queueOnTarget ? this.targetNodeId : address.toString().substring(address.toString().lastIndexOf("."));
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        for (Queue queue : queues) {
            try {
                LinkedListIterator<MessageReference> messagesIterator = queue.browserIterator();
                Throwable throwable = null;
                try {
                    while (messagesIterator.hasNext()) {
                        MessageReference messageRef = (MessageReference)messagesIterator.next();
                        Message message = messageRef.getMessage().copy();
                        byte[] oldRouteToIDs = null;
                        ArrayList<SimpleString> propertiesToRemove = new ArrayList<SimpleString>();
                        message.removeProperty(Message.HDR_ROUTE_TO_IDS.toString());
                        for (SimpleString propName : message.getPropertyNames()) {
                            if (!propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
                            if (propName.toString().endsWith(propertyEnd)) {
                                oldRouteToIDs = message.getBytesProperty(propName.toString());
                            }
                            propertiesToRemove.add(propName);
                        }
                        for (SimpleString propertyToRemove : propertiesToRemove) {
                            message.removeProperty(propertyToRemove.toString());
                        }
                        if (queueOnTarget) {
                            message.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), oldRouteToIDs);
                        } else {
                            message.putBytesProperty(Message.HDR_SCALEDOWN_TO_IDS.toString(), oldRouteToIDs);
                        }
                        logger.debug((Object)("Scaling down message " + message + " from " + address + " to " + message.getAddress() + " on node " + this.targetNodeId));
                        producer.send(message.getAddress(), message);
                        ++messageCount;
                        messagesIterator.remove();
                        this.ackMessageOnQueue(tx, queue, messageRef);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (messagesIterator == null) continue;
                    if (throwable != null) {
                        try {
                            messagesIterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    messagesIterator.close();
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        tx.commit();
        return messageCount;
    }

    private String getTargetNodeId(ClientSessionFactory sessionFactory) {
        return sessionFactory.getServerLocator().getTopology().getMember(sessionFactory.getConnection()).getNodeId();
    }

    public void scaleDownTransactions(ClientSessionFactory sessionFactory, ResourceManager resourceManager, String user, String password) throws Exception {
        ClientSession session = sessionFactory.createSession(user, password, true, false, false, false, 0);
        ClientSession queueCreateSession = sessionFactory.createSession(user, password, false, true, true, false, 0);
        List<Xid> preparedTransactions = resourceManager.getPreparedTransactions();
        HashMap<String, Long> queueIDs = new HashMap<String, Long>();
        for (Xid xid : preparedTransactions) {
            logger.debug((Object)("Scaling down transaction: " + xid));
            Transaction transaction = resourceManager.getTransaction(xid);
            session.start(xid, 0);
            List<TransactionOperation> allOperations = transaction.getAllOperations();
            HashMap<Message, Pair> queuesToSendTo = new HashMap<Message, Pair>();
            for (TransactionOperation operation : allOperations) {
                Pair queueIds;
                long queueID;
                String queueName;
                Queue queue;
                Message message;
                List<MessageReference> refs;
                if (operation instanceof PostOfficeImpl.AddOperation) {
                    PostOfficeImpl.AddOperation addOperation = (PostOfficeImpl.AddOperation)operation;
                    refs = addOperation.getRelatedMessageReferences();
                    for (MessageReference messageReference : refs) {
                        message = messageReference.getMessage();
                        queue = messageReference.getQueue();
                        queueName = queue.getName().toString();
                        if (queueIDs.containsKey(queueName)) {
                            queueID = (Long)queueIDs.get(queueName);
                        } else {
                            queueID = this.createQueueIfNecessaryAndGetID(queueCreateSession, queue, message.getAddressSimpleString());
                            queueIDs.put(queueName, queueID);
                        }
                        queueIds = (Pair)queuesToSendTo.get(message);
                        if (queueIds == null) {
                            queueIds = new Pair(new ArrayList(), new ArrayList());
                            queuesToSendTo.put(message, queueIds);
                        }
                        ((List)queueIds.getA()).add(queueID);
                    }
                    continue;
                }
                if (!(operation instanceof RefsOperation)) continue;
                RefsOperation refsOperation = (RefsOperation)operation;
                refs = refsOperation.getReferencesToAcknowledge();
                for (MessageReference messageReference : refs) {
                    message = messageReference.getMessage();
                    queue = messageReference.getQueue();
                    queueName = queue.getName().toString();
                    if (queueIDs.containsKey(queueName)) {
                        queueID = (Long)queueIDs.get(queueName);
                    } else {
                        queueID = this.createQueueIfNecessaryAndGetID(queueCreateSession, queue, message.getAddressSimpleString());
                        queueIDs.put(queueName, queueID);
                    }
                    queueIds = (Pair)queuesToSendTo.get(message);
                    if (queueIds == null) {
                        queueIds = new Pair(new ArrayList(), new ArrayList());
                        queuesToSendTo.put(message, queueIds);
                    }
                    ((List)queueIds.getA()).add(queueID);
                    ((List)queueIds.getB()).add(queueID);
                }
            }
            ClientProducer producer = session.createProducer();
            for (Map.Entry entry : queuesToSendTo.entrySet()) {
                List ids = (List)((Pair)entry.getValue()).getA();
                ByteBuffer buffer = ByteBuffer.allocate(ids.size() * 8);
                for (Long id : ids) {
                    buffer.putLong(id);
                }
                Message message = (Message)entry.getKey();
                message.putBytesProperty(Message.HDR_ROUTE_TO_IDS.toString(), buffer.array());
                ids = (List)((Pair)entry.getValue()).getB();
                if (ids.size() > 0) {
                    buffer = ByteBuffer.allocate(ids.size() * 8);
                    for (Long id : ids) {
                        buffer.putLong(id);
                    }
                    message.putBytesProperty(Message.HDR_ROUTE_TO_ACK_IDS.toString(), buffer.array());
                }
                producer.send(message.getAddressSimpleString().toString(), message);
            }
            session.end(xid, 0x4000000);
            session.prepare(xid);
        }
    }

    public void scaleDownDuplicateIDs(Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, ClientSessionFactory sessionFactory, SimpleString managementAddress, String user, String password) throws Exception {
        try (ClientSession session = sessionFactory.createSession(user, password, true, false, false, false, 0);
             ClientProducer producer = session.createProducer(managementAddress);){
            for (Map.Entry<SimpleString, List<Pair<byte[], Long>>> entry : duplicateIDMap.entrySet()) {
                ClientMessage message = session.createMessage(false);
                List<Pair<byte[], Long>> list = entry.getValue();
                String[] array = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    Pair<byte[], Long> pair = list.get(i);
                    array[i] = new String((byte[])pair.getA());
                }
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"updateDuplicateIdCache", (Object[])new Object[]{entry.getKey().toString(), array});
                producer.send((Message)message);
            }
        }
    }

    private long createQueueIfNecessaryAndGetID(ClientSession session, Queue queue, SimpleString addressName) throws Exception {
        long queueID = this.getQueueID(session, queue.getName()).intValue();
        if (queueID == -1L) {
            session.createQueue(addressName, queue.getName(), queue.getFilter() == null ? null : queue.getFilter().getFilterString(), queue.isDurable());
            logger.debug((Object)("Failed to get queue ID, creating queue [addressName=" + addressName + ", queueName=" + queue.getName() + ", filter=" + (queue.getFilter() == null ? "" : queue.getFilter().getFilterString()) + ", durable=" + queue.isDurable() + "]"));
            queueID = this.getQueueID(session, queue.getName()).intValue();
        }
        logger.debug((Object)("ID for " + queue + " is: " + queueID));
        return queueID;
    }

    private Integer getQueueID(ClientSession session, SimpleString queueName) throws Exception {
        Object result;
        Integer queueID = -1;
        try (ClientRequestor requestor = new ClientRequestor(session, "activemq.management");){
            ClientMessage managementMessage = session.createMessage(false);
            ManagementHelper.putAttribute((ICoreMessage)managementMessage, (String)("queue." + queueName), (String)"ID");
            session.start();
            logger.debug((Object)("Requesting ID for: " + queueName));
            ClientMessage reply = requestor.request(managementMessage);
            result = ManagementHelper.getResult((ICoreMessage)reply);
        }
        if (result != null && result instanceof Number) {
            queueID = ((Number)result).intValue();
        }
        return queueID;
    }

    private void ackMessageOnQueue(Transaction tx, Queue queue, MessageReference messageRef) throws Exception {
        queue.acknowledge(tx, messageRef);
    }

    private class QueuesXRefInnerManager {
        private final Queue queue;
        private LinkedListIterator<MessageReference> memoryIterator;
        private MessageReference lastRef = null;
        private final PagingStore store;
        private final ClientSession clientSession;
        private long targetQueueID = -1L;

        QueuesXRefInnerManager(ClientSession clientSession, Queue queue, PagingStore store) {
            this.queue = queue;
            this.store = store;
            this.clientSession = clientSession;
        }

        public Queue getQueue() {
            return this.queue;
        }

        public long getQueueID() throws Exception {
            if (this.targetQueueID < 0L) {
                this.targetQueueID = ScaleDownHandler.this.createQueueIfNecessaryAndGetID(this.clientSession, this.queue, this.queue.getAddress());
            }
            return this.targetQueueID;
        }

        public void close() {
            if (this.memoryIterator != null) {
                this.memoryIterator.close();
            }
        }

        public boolean lookup(MessageReference reference) throws Exception {
            if (reference.isPaged()) {
                PageSubscription subscription = this.store.getCursorProvider().getSubscription(this.queue.getID());
                if (subscription.contains((PagedReference)reference)) {
                    return true;
                }
            } else {
                if (this.lastRef != null && this.lastRef.getMessage().equals(reference.getMessage())) {
                    this.lastRef = null;
                    this.memoryIterator.remove();
                    return true;
                }
                int numberOfScans = 2;
                if (this.memoryIterator == null) {
                    numberOfScans = 1;
                }
                MessageReference initialRef = null;
                for (int i = 0; i < numberOfScans; ++i) {
                    logger.debug((Object)("iterating on queue " + this.queue + " while looking for reference " + reference));
                    this.memoryIterator = this.queue.iterator();
                    while (this.memoryIterator.hasNext()) {
                        this.lastRef = (MessageReference)this.memoryIterator.next();
                        logger.debug((Object)("Iterating on message " + this.lastRef));
                        if (this.lastRef.getMessage().equals(reference.getMessage())) {
                            this.memoryIterator.remove();
                            this.lastRef = null;
                            return true;
                        }
                        if (initialRef == null) {
                            initialRef = this.lastRef;
                            continue;
                        }
                        if (!initialRef.equals(this.lastRef)) continue;
                        if (!this.memoryIterator.hasNext()) {
                            this.lastRef = null;
                            this.memoryIterator.close();
                            this.memoryIterator = null;
                        }
                        return false;
                    }
                }
            }
            this.lastRef = null;
            this.memoryIterator.close();
            this.memoryIterator = null;
            return false;
        }
    }

    public static class OrderQueueByNumberOfReferencesComparator
    implements Comparator<Queue> {
        @Override
        public int compare(Queue queue1, Queue queue2) {
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            int result = 0;
            if (queue1 == queue2) {
                return 0;
            }
            if (queue1.getMessageCount() == queue2.getMessageCount()) {
                long tieBreak = queue2.getID() - queue1.getID();
                if (tieBreak > 0L) {
                    return 1;
                }
                if (tieBreak < 0L) {
                    return -1;
                }
                return 0;
            }
            if (queue1.getMessageCount() > queue2.getMessageCount()) {
                return -1;
            }
            if (queue1.getMessageCount() < queue2.getMessageCount()) {
                return 1;
            }
            return result;
        }
    }
}

