/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActivationFailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.PostQueueCreationCallback;
import org.apache.activemq.artemis.core.server.PostQueueDeletionCallback;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.ConnectorsService;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQPluginRunnable;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.core.server.reload.ReloadManager;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;

public interface ActiveMQServer
extends ServiceComponent {
    public void setState(SERVER_STATE var1);

    public SERVER_STATE getState();

    public void setIdentity(String var1);

    public String getIdentity();

    public String describe();

    public void addActivationParam(String var1, Object var2);

    public Configuration getConfiguration();

    public ServiceRegistry getServiceRegistry();

    public RemotingService getRemotingService();

    public StorageManager getStorageManager();

    public PagingManager getPagingManager();

    public ManagementService getManagementService();

    public ActiveMQSecurityManager getSecurityManager();

    public NetworkHealthCheck getNetworkHealthCheck();

    public Version getVersion();

    public NodeManager getNodeManager();

    public CriticalAnalyzer getCriticalAnalyzer();

    public ReplicationEndpoint getReplicationEndpoint();

    public void unlockActivation();

    public void lockActivation();

    public ActiveMQServerControlImpl getActiveMQServerControl();

    public void destroyQueue(SimpleString var1, SecurityAuth var2, boolean var3, boolean var4, boolean var5) throws Exception;

    public void registerActivateCallback(ActivateCallback var1);

    public void unregisterActivateCallback(ActivateCallback var1);

    public void registerActivationFailureListener(ActivationFailureListener var1);

    public void unregisterActivationFailureListener(ActivationFailureListener var1);

    public void callActivationFailureListeners(Exception var1);

    public void registerPostQueueCreationCallback(PostQueueCreationCallback var1);

    public void unregisterPostQueueCreationCallback(PostQueueCreationCallback var1);

    public void callPostQueueCreationCallbacks(SimpleString var1) throws Exception;

    public void registerPostQueueDeletionCallback(PostQueueDeletionCallback var1);

    public void unregisterPostQueueDeletionCallback(PostQueueDeletionCallback var1);

    public void callPostQueueDeletionCallbacks(SimpleString var1, SimpleString var2) throws Exception;

    public void registerBrokerPlugin(ActiveMQServerPlugin var1);

    public void unRegisterBrokerPlugin(ActiveMQServerPlugin var1);

    public void registerBrokerPlugins(List<ActiveMQServerPlugin> var1);

    public List<ActiveMQServerPlugin> getBrokerPlugins();

    public void callBrokerPlugins(ActiveMQPluginRunnable var1) throws ActiveMQException;

    public boolean hasBrokerPlugins();

    public void checkQueueCreationLimit(String var1) throws Exception;

    public ServerSession createSession(String var1, String var2, String var3, int var4, RemotingConnection var5, boolean var6, boolean var7, boolean var8, boolean var9, String var10, SessionCallback var11, boolean var12, OperationContext var13, Map<SimpleString, RoutingType> var14) throws Exception;

    public SecurityStore getSecurityStore();

    public void removeSession(String var1) throws Exception;

    public Set<ServerSession> getSessions();

    public HierarchicalRepository<Set<Role>> getSecurityRepository();

    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository();

    public OperationContext newOperationContext();

    public int getConnectionCount();

    public long getTotalConnectionCount();

    public long getTotalMessageCount();

    public long getTotalMessagesAdded();

    public long getTotalMessagesAcknowledged();

    public long getTotalConsumerCount();

    public PostOffice getPostOffice();

    public QueueFactory getQueueFactory();

    public ResourceManager getResourceManager();

    public List<ServerSession> getSessions(String var1);

    public ServerSession lookupSession(String var1, String var2);

    public ClusterManager getClusterManager();

    public SimpleString getNodeID();

    public boolean isActive();

    public String getUptime();

    public long getUptimeMillis();

    public boolean isReplicaSync();

    public boolean waitForActivation(long var1, TimeUnit var3) throws InterruptedException;

    public void createSharedQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6) throws Exception;

    public void createSharedQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, int var7, boolean var8, boolean var9, boolean var10) throws Exception;

    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6) throws Exception;

    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7) throws Exception;

    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, int var7, boolean var8, boolean var9) throws Exception;

    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, Integer var9, Boolean var10, boolean var11) throws Exception;

    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, boolean var7, Integer var8, Boolean var9, boolean var10) throws Exception;

    public Queue createQueue(AddressInfo var1, SimpleString var2, SimpleString var3, SimpleString var4, boolean var5, boolean var6, boolean var7, Integer var8, Boolean var9, Boolean var10, Boolean var11, boolean var12) throws Exception;

    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, boolean var13) throws Exception;

    public Queue createQueue(SimpleString var1, RoutingType var2, SimpleString var3, SimpleString var4, SimpleString var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, boolean var12, boolean var13, boolean var14, boolean var15) throws Exception;

    @Deprecated
    public Queue createQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    @Deprecated
    public Queue deployQueue(String var1, String var2, String var3, boolean var4, boolean var5) throws Exception;

    @Deprecated
    public Queue deployQueue(SimpleString var1, SimpleString var2, SimpleString var3, boolean var4, boolean var5) throws Exception;

    public Queue locateQueue(SimpleString var1);

    public BindingQueryResult bindingQuery(SimpleString var1) throws Exception;

    public QueueQueryResult queueQuery(SimpleString var1) throws Exception;

    public AddressQueryResult addressQuery(SimpleString var1) throws Exception;

    public void destroyQueue(SimpleString var1) throws Exception;

    public void destroyQueue(SimpleString var1, SecurityAuth var2) throws Exception;

    public void destroyQueue(SimpleString var1, SecurityAuth var2, boolean var3) throws Exception;

    public void destroyQueue(SimpleString var1, SecurityAuth var2, boolean var3, boolean var4) throws Exception;

    public String destroyConnectionWithSessionMetadata(String var1, String var2) throws Exception;

    public ScheduledExecutorService getScheduledPool();

    public ExecutorFactory getExecutorFactory();

    public ExecutorFactory getIOExecutorFactory();

    public void setGroupingHandler(GroupingHandler var1);

    public GroupingHandler getGroupingHandler();

    public ReplicationManager getReplicationManager();

    public void deployDivert(DivertConfiguration var1) throws Exception;

    public void destroyDivert(SimpleString var1) throws Exception;

    public ConnectorsService getConnectorsService();

    public void deployBridge(BridgeConfiguration var1) throws Exception;

    public void destroyBridge(String var1) throws Exception;

    public ServerSession getSessionByID(String var1);

    public void threadDump();

    public boolean isAddressBound(String var1) throws Exception;

    public void fail(boolean var1) throws Exception;

    public void stop(boolean var1, boolean var2) throws Exception;

    public Queue updateQueue(String var1, RoutingType var2, Integer var3, Boolean var4) throws Exception;

    public Queue updateQueue(String var1, RoutingType var2, Integer var3, Boolean var4, Boolean var5) throws Exception;

    public void addProtocolManagerFactory(ProtocolManagerFactory var1);

    public void removeProtocolManagerFactory(ProtocolManagerFactory var1);

    public ReloadManager getReloadManager();

    public ActiveMQServer createBackupServer(Configuration var1);

    public void addScaledDownNode(SimpleString var1);

    public boolean hasScaledDown(SimpleString var1);

    public Activation getActivation();

    public HAPolicy getHAPolicy();

    public void setHAPolicy(HAPolicy var1);

    public void setMBeanServer(MBeanServer var1);

    public void addExternalComponent(ActiveMQComponent var1);

    public List<ActiveMQComponent> getExternalComponents();

    public boolean addClientConnection(String var1, boolean var2);

    public void removeClientConnection(String var1);

    public Executor getThreadPool();

    public AddressInfo getAddressInfo(SimpleString var1);

    public boolean updateAddressInfo(SimpleString var1, EnumSet<RoutingType> var2) throws Exception;

    @Deprecated
    public boolean updateAddressInfo(SimpleString var1, Collection<RoutingType> var2) throws Exception;

    public boolean addAddressInfo(AddressInfo var1) throws Exception;

    public AddressInfo addOrUpdateAddressInfo(AddressInfo var1) throws Exception;

    public void removeAddressInfo(SimpleString var1, SecurityAuth var2) throws Exception;

    public void removeAddressInfo(SimpleString var1, SecurityAuth var2, boolean var3) throws Exception;

    public String getInternalNamingPrefix();

    public static enum SERVER_STATE {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

