/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.LDAPLoginProperty;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.jboss.logging.Logger;

public class LDAPLoginModule
implements LoginModule {
    private static final Logger logger = Logger.getLogger(LDAPLoginModule.class);
    private static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    private static final String CONNECTION_URL = "connectionURL";
    private static final String CONNECTION_USERNAME = "connectionUsername";
    private static final String CONNECTION_PASSWORD = "connectionPassword";
    private static final String CONNECTION_PROTOCOL = "connectionProtocol";
    private static final String AUTHENTICATION = "authentication";
    private static final String USER_BASE = "userBase";
    private static final String USER_SEARCH_MATCHING = "userSearchMatching";
    private static final String USER_SEARCH_SUBTREE = "userSearchSubtree";
    private static final String ROLE_BASE = "roleBase";
    private static final String ROLE_NAME = "roleName";
    private static final String ROLE_SEARCH_MATCHING = "roleSearchMatching";
    private static final String ROLE_SEARCH_SUBTREE = "roleSearchSubtree";
    private static final String USER_ROLE_NAME = "userRoleName";
    private static final String EXPAND_ROLES = "expandRoles";
    private static final String EXPAND_ROLES_MATCHING = "expandRolesMatching";
    private static final String SASL_LOGIN_CONFIG_SCOPE = "saslLoginConfigScope";
    private static final String AUTHENTICATE_USER = "authenticateUser";
    private static final String REFERRAL = "referral";
    private static final String MASK_PASSWORD = "maskPassword";
    private static final String PASSWORD_CODEC = "passwordCodec";
    protected DirContext context;
    private Subject subject;
    private CallbackHandler handler;
    private LDAPLoginProperty[] config;
    private String username;
    private final Set<RolePrincipal> groups = new HashSet<RolePrincipal>();
    private boolean userAuthenticated = false;
    private boolean authenticateUser = true;
    private Subject brokerGssapiIdentity = null;
    private boolean isRoleAttributeSet = false;
    private String roleAttributeName = null;
    private String codecClass = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.config = new LDAPLoginProperty[]{new LDAPLoginProperty(INITIAL_CONTEXT_FACTORY, (String)options.get(INITIAL_CONTEXT_FACTORY)), new LDAPLoginProperty(CONNECTION_URL, (String)options.get(CONNECTION_URL)), new LDAPLoginProperty(CONNECTION_USERNAME, (String)options.get(CONNECTION_USERNAME)), new LDAPLoginProperty(CONNECTION_PASSWORD, (String)options.get(CONNECTION_PASSWORD)), new LDAPLoginProperty(CONNECTION_PROTOCOL, (String)options.get(CONNECTION_PROTOCOL)), new LDAPLoginProperty(AUTHENTICATION, (String)options.get(AUTHENTICATION)), new LDAPLoginProperty(USER_BASE, (String)options.get(USER_BASE)), new LDAPLoginProperty(USER_SEARCH_MATCHING, (String)options.get(USER_SEARCH_MATCHING)), new LDAPLoginProperty(USER_SEARCH_SUBTREE, (String)options.get(USER_SEARCH_SUBTREE)), new LDAPLoginProperty(ROLE_BASE, (String)options.get(ROLE_BASE)), new LDAPLoginProperty(ROLE_NAME, (String)options.get(ROLE_NAME)), new LDAPLoginProperty(ROLE_SEARCH_MATCHING, (String)options.get(ROLE_SEARCH_MATCHING)), new LDAPLoginProperty(ROLE_SEARCH_SUBTREE, (String)options.get(ROLE_SEARCH_SUBTREE)), new LDAPLoginProperty(USER_ROLE_NAME, (String)options.get(USER_ROLE_NAME)), new LDAPLoginProperty(EXPAND_ROLES, (String)options.get(EXPAND_ROLES)), new LDAPLoginProperty(EXPAND_ROLES_MATCHING, (String)options.get(EXPAND_ROLES_MATCHING)), new LDAPLoginProperty(REFERRAL, (String)options.get(REFERRAL))};
        if (this.isLoginPropertySet(AUTHENTICATE_USER)) {
            this.authenticateUser = Boolean.valueOf(this.getLDAPPropertyValue(AUTHENTICATE_USER));
        }
        this.isRoleAttributeSet = this.isLoginPropertySet(ROLE_NAME);
        this.roleAttributeName = this.getLDAPPropertyValue(ROLE_NAME);
        this.codecClass = (String)options.get(PASSWORD_CODEC);
    }

    private String getPlainPassword(String password) {
        try {
            return PasswordMaskingUtil.resolveMask(null, (String)password, (String)this.codecClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decode password", e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (!this.authenticateUser) {
            return false;
        }
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw (LoginException)new LoginException().initCause(e);
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        if (this.username == null) {
            return false;
        }
        String password = ((PasswordCallback)callbacks[1]).getPassword() != null ? new String(((PasswordCallback)callbacks[1]).getPassword()) : "";
        this.authenticate(this.username, password);
        this.userAuthenticated = true;
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.clear();
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.userAuthenticated;
        Set<UserPrincipal> authenticatedUsers = this.subject.getPrincipals(UserPrincipal.class);
        Set<Principal> principals = this.subject.getPrincipals();
        if (result) {
            principals.add(new UserPrincipal(this.username));
        }
        for (UserPrincipal authenticatedUser : authenticatedUsers) {
            ArrayList<String> roles = new ArrayList<String>();
            try {
                String dn = this.resolveDN(authenticatedUser.getName(), roles);
                this.resolveRolesForDN(this.context, dn, authenticatedUser.getName(), roles);
            }
            catch (NamingException e) {
                this.closeContext();
                FailedLoginException ex = new FailedLoginException("Error contacting LDAP");
                ex.initCause(e);
                throw ex;
            }
        }
        for (RolePrincipal gp : this.groups) {
            principals.add(gp);
        }
        this.clear();
        return result;
    }

    private void clear() {
        this.username = null;
        this.userAuthenticated = false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        return true;
    }

    protected void closeContext() {
        if (this.context != null) {
            try {
                this.context.close();
                this.context = null;
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToCloseContext(e);
            }
        }
    }

    protected boolean authenticate(String username, String password) throws LoginException {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            String dn = this.resolveDN(username, roles);
            if (!this.bindUser(this.context, dn, password)) {
                throw new FailedLoginException("Password does not match for user: " + username);
            }
            this.resolveRolesForDN(this.context, dn, username, roles);
        }
        catch (CommunicationException e) {
            this.closeContext();
            FailedLoginException ex = new FailedLoginException("Error contacting LDAP");
            ex.initCause(e);
            throw ex;
        }
        catch (NamingException e) {
            this.closeContext();
            FailedLoginException ex = new FailedLoginException("Error contacting LDAP");
            ex.initCause(e);
            throw ex;
        }
        return true;
    }

    private void resolveRolesForDN(DirContext context, String dn, String username, List<String> roles) throws NamingException {
        this.addRoles(context, dn, username, roles);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Roles " + roles + " for user " + username));
        }
        for (String role : roles) {
            this.groups.add(new RolePrincipal(role));
        }
    }

    private String resolveDN(String username, List<String> roles) throws FailedLoginException {
        String dn;
        block24: {
            dn = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Create the LDAP initial context.");
            }
            try {
                this.openContext();
            }
            catch (Exception ne) {
                FailedLoginException ex = new FailedLoginException("Error opening LDAP connection");
                ex.initCause(ne);
                throw ex;
            }
            if (!this.isLoginPropertySet(USER_SEARCH_MATCHING)) {
                return dn;
            }
            MessageFormat userSearchMatchingFormat = new MessageFormat(this.getLDAPPropertyValue(USER_SEARCH_MATCHING));
            boolean userSearchSubtreeBool = Boolean.valueOf(this.getLDAPPropertyValue(USER_SEARCH_SUBTREE));
            try {
                Attribute roleNames;
                Attributes attrs;
                String filter = userSearchMatchingFormat.format(new String[]{this.doRFC2254Encoding(username)});
                SearchControls constraints = new SearchControls();
                if (userSearchSubtreeBool) {
                    constraints.setSearchScope(2);
                } else {
                    constraints.setSearchScope(1);
                }
                ArrayList<String> list = new ArrayList<String>();
                if (this.isLoginPropertySet(USER_ROLE_NAME)) {
                    list.add(this.getLDAPPropertyValue(USER_ROLE_NAME));
                }
                String[] attribs = new String[list.size()];
                list.toArray(attribs);
                constraints.setReturningAttributes(attribs);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Get the user DN.");
                    logger.debug((Object)"Looking for the user in LDAP with ");
                    logger.debug((Object)("  base DN: " + this.getLDAPPropertyValue(USER_BASE)));
                    logger.debug((Object)("  filter: " + filter));
                }
                NamingEnumeration results = null;
                try {
                    results = Subject.doAs(this.brokerGssapiIdentity, () -> this.context.search(this.getLDAPPropertyValue(USER_BASE), filter, constraints));
                }
                catch (PrivilegedActionException e) {
                    Exception cause = e.getException();
                    FailedLoginException ex = new FailedLoginException("Error executing search query to resolve DN");
                    ex.initCause(cause);
                    throw ex;
                }
                if (results == null || !results.hasMore()) {
                    throw new FailedLoginException("User " + username + " not found in LDAP.");
                }
                SearchResult result = (SearchResult)results.next();
                if (results.hasMore()) {
                    // empty if block
                }
                if (result.isRelative()) {
                    logger.debug((Object)("LDAP returned a relative name: " + result.getName()));
                    NameParser parser = this.context.getNameParser("");
                    Name contextName = parser.parse(this.context.getNameInNamespace());
                    Name baseName = parser.parse(this.getLDAPPropertyValue(USER_BASE));
                    Name entryName = parser.parse(result.getName());
                    Name name = contextName.addAll(baseName);
                    name = name.addAll(entryName);
                    dn = name.toString();
                } else {
                    logger.debug((Object)("LDAP returned an absolute name: " + result.getName()));
                    try {
                        URI uri = new URI(result.getName());
                        String path = uri.getPath();
                        dn = path.startsWith("/") ? path.substring(1) : path;
                    }
                    catch (URISyntaxException e) {
                        this.closeContext();
                        FailedLoginException ex = new FailedLoginException("Error parsing absolute name as URI.");
                        ex.initCause(e);
                        throw ex;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Using DN [" + dn + "] for binding."));
                }
                if ((attrs = result.getAttributes()) == null) {
                    throw new FailedLoginException("User found, but LDAP entry malformed: " + username);
                }
                if (!this.isLoginPropertySet(USER_ROLE_NAME) || (roleNames = attrs.get(this.getLDAPPropertyValue(USER_ROLE_NAME))) == null) break block24;
                NamingEnumeration<?> e = roleNames.getAll();
                while (e.hasMore()) {
                    String roleDnString = (String)e.next();
                    if (this.isRoleAttributeSet) {
                        LdapName ldapRoleName = new LdapName(roleDnString);
                        for (int i = 0; i < ldapRoleName.size(); ++i) {
                            Rdn candidate = ldapRoleName.getRdn(i);
                            if (!this.roleAttributeName.equals(candidate.getType())) continue;
                            roles.add((String)candidate.getValue());
                        }
                        continue;
                    }
                    roles.add(roleDnString);
                }
            }
            catch (CommunicationException e) {
                this.closeContext();
                FailedLoginException ex = new FailedLoginException("Error contacting LDAP");
                ex.initCause(e);
                throw ex;
            }
            catch (NamingException e) {
                this.closeContext();
                FailedLoginException ex = new FailedLoginException("Error contacting LDAP");
                ex.initCause(e);
                throw ex;
            }
        }
        return dn;
    }

    protected void addRoles(DirContext context, String dn, String username, List<String> currentRoles) throws NamingException {
        if (!this.isLoginPropertySet(ROLE_SEARCH_MATCHING)) {
            return;
        }
        MessageFormat roleSearchMatchingFormat = new MessageFormat(this.getLDAPPropertyValue(ROLE_SEARCH_MATCHING));
        boolean roleSearchSubtreeBool = Boolean.valueOf(this.getLDAPPropertyValue(ROLE_SEARCH_SUBTREE));
        boolean expandRolesBool = Boolean.valueOf(this.getLDAPPropertyValue(EXPAND_ROLES));
        String filter = roleSearchMatchingFormat.format(new String[]{this.doRFC2254Encoding(dn), this.doRFC2254Encoding(username)});
        SearchControls constraints = new SearchControls();
        if (roleSearchSubtreeBool) {
            constraints.setSearchScope(2);
        } else {
            constraints.setSearchScope(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Get user roles.");
            logger.debug((Object)"Looking for the user roles in LDAP with ");
            logger.debug((Object)("  base DN: " + this.getLDAPPropertyValue(ROLE_BASE)));
            logger.debug((Object)("  filter: " + filter));
        }
        HashSet<String> haveSeenNames = new HashSet<String>();
        LinkedList<String> pendingNameExpansion = new LinkedList<String>();
        NamingEnumeration results = null;
        try {
            results = Subject.doAs(this.brokerGssapiIdentity, () -> context.search(this.getLDAPPropertyValue(ROLE_BASE), filter, constraints));
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            NamingException ex = new NamingException("Error executing search query to resolve roles");
            ex.initCause(cause);
            throw ex;
        }
        while (results.hasMore()) {
            SearchResult result = (SearchResult)results.next();
            if (expandRolesBool) {
                haveSeenNames.add(result.getNameInNamespace());
                pendingNameExpansion.add(result.getNameInNamespace());
            }
            this.addRoleAttribute(result, currentRoles);
        }
        if (expandRolesBool) {
            MessageFormat expandRolesMatchingFormat = new MessageFormat(this.getLDAPPropertyValue(EXPAND_ROLES_MATCHING));
            while (!pendingNameExpansion.isEmpty()) {
                String name = (String)pendingNameExpansion.remove();
                String expandFilter = expandRolesMatchingFormat.format(new String[]{name});
                try {
                    results = Subject.doAs(this.brokerGssapiIdentity, () -> context.search(this.getLDAPPropertyValue(ROLE_BASE), expandFilter, constraints));
                }
                catch (PrivilegedActionException e) {
                    Exception cause = e.getException();
                    NamingException ex = new NamingException("Error executing search query to expand roles");
                    ex.initCause(cause);
                    throw ex;
                }
                while (results.hasMore()) {
                    SearchResult result = (SearchResult)results.next();
                    name = result.getNameInNamespace();
                    if (haveSeenNames.contains(name)) continue;
                    this.addRoleAttribute(result, currentRoles);
                    haveSeenNames.add(name);
                    pendingNameExpansion.add(name);
                }
            }
        }
    }

    protected String doRFC2254Encoding(String inputString) {
        StringBuffer buf = new StringBuffer(inputString.length());
        block7: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected boolean bindUser(DirContext context, String dn, String password) throws NamingException {
        boolean isValid;
        block8: {
            isValid = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Binding the user.");
            }
            context.addToEnvironment("java.naming.security.principal", dn);
            context.addToEnvironment("java.naming.security.credentials", password);
            try {
                context.getAttributes("", null);
                isValid = true;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("User " + dn + " successfully bound."));
                }
            }
            catch (AuthenticationException e) {
                isValid = false;
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)("Authentication failed for dn=" + dn));
            }
        }
        if (this.isLoginPropertySet(CONNECTION_USERNAME)) {
            context.addToEnvironment("java.naming.security.principal", this.getLDAPPropertyValue(CONNECTION_USERNAME));
        } else {
            context.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.isLoginPropertySet(CONNECTION_PASSWORD)) {
            context.addToEnvironment("java.naming.security.credentials", this.getPlainPassword(this.getLDAPPropertyValue(CONNECTION_PASSWORD)));
        } else {
            context.removeFromEnvironment("java.naming.security.credentials");
        }
        return isValid;
    }

    private void addRoleAttribute(SearchResult searchResult, List<String> roles) throws NamingException {
        if (this.isRoleAttributeSet) {
            Attribute roleAttribute = searchResult.getAttributes().get(this.roleAttributeName);
            if (roleAttribute != null) {
                roles.add((String)roleAttribute.get());
            }
        } else {
            roles.add(searchResult.getNameInNamespace());
        }
    }

    protected void openContext() throws Exception {
        if (this.context == null) {
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", this.getLDAPPropertyValue(INITIAL_CONTEXT_FACTORY));
                env.put("java.naming.security.protocol", this.getLDAPPropertyValue(CONNECTION_PROTOCOL));
                env.put("java.naming.provider.url", this.getLDAPPropertyValue(CONNECTION_URL));
                env.put("java.naming.security.authentication", this.getLDAPPropertyValue(AUTHENTICATION));
                String referral = "ignore";
                if (this.getLDAPPropertyValue(REFERRAL) != null) {
                    referral = this.getLDAPPropertyValue(REFERRAL);
                }
                env.put("java.naming.referral", referral);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Referral handling: " + referral));
                }
                if ("GSSAPI".equalsIgnoreCase(this.getLDAPPropertyValue(AUTHENTICATION))) {
                    String configScope = this.isLoginPropertySet(SASL_LOGIN_CONFIG_SCOPE) ? this.getLDAPPropertyValue(SASL_LOGIN_CONFIG_SCOPE) : "broker-sasl-gssapi";
                    try {
                        LoginContext loginContext = new LoginContext(configScope);
                        loginContext.login();
                        this.brokerGssapiIdentity = loginContext.getSubject();
                    }
                    catch (LoginException e) {
                        e.printStackTrace();
                        FailedLoginException ex = new FailedLoginException("Error contacting LDAP using GSSAPI in JAAS loginConfigScope: " + configScope);
                        ex.initCause(e);
                        throw ex;
                    }
                } else {
                    if (!this.isLoginPropertySet(CONNECTION_USERNAME)) {
                        throw new NamingException("Empty username is not allowed");
                    }
                    env.put("java.naming.security.principal", this.getLDAPPropertyValue(CONNECTION_USERNAME));
                    if (this.isLoginPropertySet(CONNECTION_PASSWORD)) {
                        env.put("java.naming.security.credentials", this.getPlainPassword(this.getLDAPPropertyValue(CONNECTION_PASSWORD)));
                    } else {
                        throw new NamingException("Empty password is not allowed");
                    }
                }
                try {
                    this.context = Subject.doAs(this.brokerGssapiIdentity, () -> new InitialDirContext(env));
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (NamingException e) {
                this.closeContext();
                ActiveMQServerLogger.LOGGER.failedToOpenContext(e);
                throw e;
            }
        }
    }

    private String getLDAPPropertyValue(String propertyName) {
        for (LDAPLoginProperty conf : this.config) {
            if (!conf.getPropertyName().equals(propertyName)) continue;
            return conf.getPropertyValue();
        }
        return null;
    }

    private boolean isLoginPropertySet(String propertyName) {
        for (LDAPLoginProperty conf : this.config) {
            if (!conf.getPropertyName().equals(propertyName) || conf.getPropertyValue() == null || "".equals(conf.getPropertyValue())) continue;
            return true;
        }
        return false;
    }
}

