/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.EnumSet;
import java.util.Map;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.PrefixUtil;

public class AddressInfo {
    private long id;
    private final SimpleString name;
    private boolean autoCreated = false;
    private EnumSet<RoutingType> routingTypes;
    private RoutingType firstSeen;
    private boolean internal = false;

    public AddressInfo(SimpleString name) {
        this(name, EnumSet.noneOf(RoutingType.class));
    }

    public AddressInfo(SimpleString name, EnumSet<RoutingType> routingTypes) {
        this.name = name;
        this.setRoutingTypes(routingTypes);
    }

    public AddressInfo(SimpleString name, RoutingType routingType) {
        this.name = name;
        this.addRoutingType(routingType);
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public AddressInfo setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
        return this;
    }

    public SimpleString getName() {
        return this.name;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public EnumSet<RoutingType> getRoutingTypes() {
        return this.routingTypes;
    }

    public AddressInfo setRoutingTypes(EnumSet<RoutingType> routingTypes) {
        this.routingTypes = routingTypes;
        if (!routingTypes.isEmpty()) {
            this.firstSeen = (RoutingType)this.routingTypes.iterator().next();
        }
        return this;
    }

    public AddressInfo addRoutingType(RoutingType routingType) {
        if (routingType != null) {
            if (this.routingTypes == null) {
                this.routingTypes = EnumSet.of(routingType);
                this.firstSeen = routingType;
            } else {
                if (this.routingTypes.isEmpty()) {
                    this.firstSeen = routingType;
                }
                this.routingTypes.add(routingType);
            }
        }
        return this;
    }

    public RoutingType getRoutingType() {
        return this.firstSeen;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Address [name=" + this.name);
        buff.append(", id=" + this.id);
        buff.append(", routingTypes={");
        for (RoutingType routingType : this.routingTypes) {
            buff.append(routingType.toString() + ",");
        }
        if (buff.charAt(buff.length() - 1) == ',') {
            buff.deleteCharAt(buff.length() - 1);
        }
        buff.append("}");
        buff.append(", autoCreated=" + this.autoCreated);
        buff.append("]");
        return buff.toString();
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public AddressInfo create(SimpleString name, RoutingType routingType) {
        AddressInfo info = new AddressInfo(name, routingType);
        info.setInternal(this.internal);
        return info;
    }

    public AddressInfo getAddressAndRoutingType(Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!this.getName().startsWith(entry.getKey())) continue;
            AddressInfo newAddressInfo = this.create(PrefixUtil.removePrefix((SimpleString)this.getName(), (SimpleString)entry.getKey()), entry.getValue());
            return newAddressInfo;
        }
        return this;
    }
}

