/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin.impl;

import java.io.Serializable;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.plugin.impl.LoggingActiveMQServerPluginLogger;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class LoggingActiveMQServerPluginLogger_$logger
extends DelegatingBasicLogger
implements LoggingActiveMQServerPluginLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LoggingActiveMQServerPluginLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String afterCreateConnection = "AMQ841000: created connection: {0}";
    private static final String afterDestroyConnection = "AMQ841001: destroyed connection: {0}";
    private static final String afterCreateSession = "AMQ841002: created session name: {0}, session connectionID: {1}";
    private static final String afterCloseSession = "AMQ841003: closed session with session name: {0}, failed: {1}";
    private static final String afterSessionMetadataAdded = "AMQ841004: added session metadata for session name : {0}, key: {1}, data: {2}";
    private static final String afterCreateConsumer = "AMQ841005: created consumer with ID: {0}, with session name: {1}";
    private static final String afterCloseConsumer = "AMQ841006: closed consumer ID: {0}, with  consumer Session: {1}, failed: {2}";
    private static final String afterCreateQueue = "AMQ841007: created queue: {0}";
    private static final String afterDestroyQueue = "AMQ841008: destroyed queue: {0}, with args address: {1}, session: {2}, checkConsumerCount: {3}, removeConsumers: {4}, autoDeleteAddress: {5}";
    private static final String afterSend = "AMQ841009: sent message with ID: {0}, session name: {1}, session connectionID: {2}, result: {3}";
    private static final String afterMessageRoute = "AMQ841010: routed message with ID: {0}, result: {1}";
    private static final String afterDeliverNoConsumer = "AMQ841011: delivered message with message ID: {0}, consumer info UNAVAILABLE";
    private static final String afterDeliver = "AMQ841012: delivered message with message ID: {0}, to consumer on address: {1}, queue: {2}, consumer sessionID: {3}, consumerID: {4}";
    private static final String messageExpired = "AMQ841013: expired message: {0}, messageExpiryAddress: {1}";
    private static final String messageAcknowledged = "AMQ841014: acknowledged message ID: {0}, messageRef sessionID: {1}, with messageRef consumerID: {2}, messageRef QueueName: {3},  with ackReason: {4}";
    private static final String afterDeployBridge = "AMQ841015: deployed bridge: {0}";
    private static final String criticalFailure = "AMQ841016: criticalFailure called with criticalComponent: {0}";
    private static final String onSendError = "AMQ841017: error sending message with ID: {0}, session name: {1}, session connectionID: {2}, exception: {3}";
    private static final String onMessageRouteError = "AMQ841018: error routing message with ID: {0}, exception: {1}";
    private static final String beforeCreateSession = "AMQ843000: beforeCreateSession called with name: {0}, username: {1}, minLargeMessageSize: {2}, connection: {3}, autoCommitSends: {4}, autoCommitAcks: {5}, preAcknowledge: {6}, xa: {7}, publicAddress: {8}, context: {9}";
    private static final String beforeCloseSession = "AMQ843001: beforeCloseSession called with session name : {0}, session: {1}, failed: {2}";
    private static final String beforeSessionMetadataAdded = "AMQ843002: beforeSessionMetadataAdded called with session name: {0} , session: {1}, key: {2}, data: {3}";
    private static final String afterSessionMetadataAddedDetails = "AMQ843003: added session metadata for session name : {0}, session: {1}, key: {2}, data: {3}";
    private static final String beforeCreateConsumer = "AMQ843004: beforeCreateConsumer called with ConsumerID: {0}, QueueBinding: {1}, filterString: {2}, browseOnly: {3}, supportLargeMessage: {4}";
    private static final String beforeCloseConsumer = "AMQ843005: beforeCloseConsumer called with consumer: {0}, consumer sessionID: {1}, failed: {2}";
    private static final String beforeCreateQueue = "AMQ843006: beforeCreateQueue called with queueConfig: {0}";
    private static final String beforeDestroyQueue = "AMQ843007: beforeDestroyQueue called with queueName: {0}, session: {1}, checkConsumerCount: {2}, removeConsumers: {3}, autoDeleteAddress: {4}";
    private static final String beforeSend = "AMQ843008: beforeSend called with message: {0}, tx: {1}, session: {2}, direct: {3}, noAutoCreateQueue: {4}";
    private static final String afterSendDetails = "AMQ843009: message ID: {0}, message {1}, session name: {2} with tx: {3}, session: {4}, direct: {5}, noAutoCreateQueue: {6}";
    private static final String beforeMessageRoute = "AMQ843010: beforeMessageRoute called with message: {0}, context: {1}, direct: {2}, rejectDuplicates: {3}";
    private static final String afterMessageRouteDetails = "AMQ843011: afterMessageRoute message: {0}, with context: {1}, direct: {2}, rejectDuplicates: {3}";
    private static final String beforeDeliver = "AMQ843012: beforeDeliver called with consumer: {0}, reference: {1}";
    private static final String afterDeliverDetails = "AMQ843013: delivered message with message ID: {0} to consumer on address: {1}, queue: {2}, consumer sessionID: {3}, consumerID: {4}, full message reference: {5}, full consumer: {6}";
    private static final String messageAcknowledgedDetails = "AMQ843014: acknowledged message: {0}, with ackReason: {1}";
    private static final String beforeDeployBridge = "AMQ843015: beforeDeployBridge called with bridgeConfiguration: {0}";
    private static final String onSendErrorDetails = "AMQ843016: onSendError message ID: {0}, message {1}, session name: {2} with tx: {3}, session: {4}, direct: {5}, noAutoCreateQueue: {6}";
    private static final String onMessageRouteErrorDetails = "AMQ843017: onMessageRouteError message: {0}, with context: {1}, direct: {2}, rejectDuplicates: {3}";

    public LoggingActiveMQServerPluginLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void afterCreateConnection(RemotingConnection connection) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterCreateConnection$str(), (Object)connection);
    }

    protected String afterCreateConnection$str() {
        return afterCreateConnection;
    }

    @Override
    public final void afterDestroyConnection(RemotingConnection connection) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterDestroyConnection$str(), (Object)connection);
    }

    protected String afterDestroyConnection$str() {
        return afterDestroyConnection;
    }

    @Override
    public final void afterCreateSession(String sessionName, Object sesssionConnectionID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterCreateSession$str(), (Object)sessionName, sesssionConnectionID);
    }

    protected String afterCreateSession$str() {
        return afterCreateSession;
    }

    @Override
    public final void afterCloseSession(String sessionName, boolean sesssionConnectionID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterCloseSession$str(), (Object)sessionName, (Object)sesssionConnectionID);
    }

    protected String afterCloseSession$str() {
        return afterCloseSession;
    }

    @Override
    public final void afterSessionMetadataAdded(String sessionName, String key, String data) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterSessionMetadataAdded$str(), (Object)sessionName, (Object)key, (Object)data);
    }

    protected String afterSessionMetadataAdded$str() {
        return afterSessionMetadataAdded;
    }

    @Override
    public final void afterCreateConsumer(String consumerID, String sessionID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterCreateConsumer$str(), (Object)consumerID, (Object)sessionID);
    }

    protected String afterCreateConsumer$str() {
        return afterCreateConsumer;
    }

    @Override
    public final void afterCloseConsumer(String consumerID, String sessionID, boolean failed) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterCloseConsumer$str(), (Object)consumerID, (Object)sessionID, (Object)failed);
    }

    protected String afterCloseConsumer$str() {
        return afterCloseConsumer;
    }

    @Override
    public final void afterCreateQueue(Queue queue) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterCreateQueue$str(), (Object)queue);
    }

    protected String afterCreateQueue$str() {
        return afterCreateQueue;
    }

    @Override
    public final void afterDestroyQueue(Queue queue, SimpleString address, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterDestroyQueue$str(), new Object[]{queue, address, session, checkConsumerCount, removeConsumers, autoDeleteAddress});
    }

    protected String afterDestroyQueue$str() {
        return afterDestroyQueue;
    }

    @Override
    public final void afterSend(String messageID, String sessionName, String sessionConnectionID, RoutingStatus result) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterSend$str(), new Object[]{messageID, sessionName, sessionConnectionID, result});
    }

    protected String afterSend$str() {
        return afterSend;
    }

    @Override
    public final void afterMessageRoute(String messageID, RoutingStatus result) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterMessageRoute$str(), (Object)messageID, (Object)result);
    }

    protected String afterMessageRoute$str() {
        return afterMessageRoute;
    }

    @Override
    public final void afterDeliverNoConsumer(String messageID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterDeliverNoConsumer$str(), (Object)messageID);
    }

    protected String afterDeliverNoConsumer$str() {
        return afterDeliverNoConsumer;
    }

    @Override
    public final void afterDeliver(String messageID, SimpleString queueAddress, SimpleString queueName, String consumerSessionID, long consumerID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterDeliver$str(), new Object[]{messageID, queueAddress, queueName, consumerSessionID, consumerID});
    }

    protected String afterDeliver$str() {
        return afterDeliver;
    }

    @Override
    public final void messageExpired(MessageReference message, SimpleString messageExpiryAddress) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.messageExpired$str(), (Object)message, (Object)messageExpiryAddress);
    }

    protected String messageExpired$str() {
        return messageExpired;
    }

    @Override
    public final void messageAcknowledged(String messageID, String sessionID, String consumerID, String queueName, AckReason reason) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.messageAcknowledged$str(), new Object[]{messageID, sessionID, consumerID, queueName, reason});
    }

    protected String messageAcknowledged$str() {
        return messageAcknowledged;
    }

    @Override
    public final void afterDeployBridge(Bridge config) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.afterDeployBridge$str(), (Object)config);
    }

    protected String afterDeployBridge$str() {
        return afterDeployBridge;
    }

    @Override
    public final void criticalFailure(CriticalComponent components) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.criticalFailure$str(), (Object)components);
    }

    protected String criticalFailure$str() {
        return criticalFailure;
    }

    @Override
    public final void onSendError(String messageID, String sessionName, String sessionConnectionID, Exception e) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.onSendError$str(), new Object[]{messageID, sessionName, sessionConnectionID, e});
    }

    protected String onSendError$str() {
        return onSendError;
    }

    @Override
    public final void onMessageRouteError(String messageID, Exception e) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.onMessageRouteError$str(), (Object)messageID, (Object)e);
    }

    protected String onMessageRouteError$str() {
        return onMessageRouteError;
    }

    @Override
    public final void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String publicAddress, OperationContext context) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeCreateSession$str(), new Object[]{name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, publicAddress, context});
    }

    protected String beforeCreateSession$str() {
        return beforeCreateSession;
    }

    @Override
    public final void beforeCloseSession(String sessionName, ServerSession session, boolean failed) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeCloseSession$str(), (Object)sessionName, (Object)session, (Object)failed);
    }

    protected String beforeCloseSession$str() {
        return beforeCloseSession;
    }

    @Override
    public final void beforeSessionMetadataAdded(String sessionName, ServerSession session, String key, String data) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeSessionMetadataAdded$str(), new Object[]{sessionName, session, key, data});
    }

    protected String beforeSessionMetadataAdded$str() {
        return beforeSessionMetadataAdded;
    }

    @Override
    public final void afterSessionMetadataAddedDetails(String sessionName, ServerSession session, String key, String data) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.afterSessionMetadataAddedDetails$str(), new Object[]{sessionName, session, key, data});
    }

    protected String afterSessionMetadataAddedDetails$str() {
        return afterSessionMetadataAddedDetails;
    }

    @Override
    public final void beforeCreateConsumer(String consumerID, QueueBinding queueBinding, SimpleString filterString, boolean browseOnly, boolean supportLargeMessage) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeCreateConsumer$str(), new Object[]{consumerID, queueBinding, filterString, browseOnly, supportLargeMessage});
    }

    protected String beforeCreateConsumer$str() {
        return beforeCreateConsumer;
    }

    @Override
    public final void beforeCloseConsumer(ServerConsumer consumer, String sessionID, boolean failed) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeCloseConsumer$str(), (Object)consumer, (Object)sessionID, (Object)failed);
    }

    protected String beforeCloseConsumer$str() {
        return beforeCloseConsumer;
    }

    @Override
    public final void beforeCreateQueue(QueueConfig queueConfig) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeCreateQueue$str(), (Object)queueConfig);
    }

    protected String beforeCreateQueue$str() {
        return beforeCreateQueue;
    }

    @Override
    public final void beforeDestroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeDestroyQueue$str(), new Object[]{queueName, session, checkConsumerCount, removeConsumers, autoDeleteAddress});
    }

    protected String beforeDestroyQueue$str() {
        return beforeDestroyQueue;
    }

    @Override
    public final void beforeSend(Message message, Transaction tx, ServerSession session, boolean direct, boolean noAutoCreateQueue) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeSend$str(), new Object[]{message, tx, session, direct, noAutoCreateQueue});
    }

    protected String beforeSend$str() {
        return beforeSend;
    }

    @Override
    public final void afterSendDetails(String messageID, Message message, String sessionName, Transaction tx, ServerSession session, boolean direct, boolean noAutoCreateQueue) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.afterSendDetails$str(), new Object[]{messageID, message, sessionName, tx, session, direct, noAutoCreateQueue});
    }

    protected String afterSendDetails$str() {
        return afterSendDetails;
    }

    @Override
    public final void beforeMessageRoute(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeMessageRoute$str(), new Object[]{message, context, direct, rejectDuplicates});
    }

    protected String beforeMessageRoute$str() {
        return beforeMessageRoute;
    }

    @Override
    public final void afterMessageRouteDetails(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.afterMessageRouteDetails$str(), new Object[]{message, context, direct, rejectDuplicates});
    }

    protected String afterMessageRouteDetails$str() {
        return afterMessageRouteDetails;
    }

    @Override
    public final void beforeDeliver(ServerConsumer consumer, MessageReference reference) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeDeliver$str(), (Object)consumer, (Object)reference);
    }

    protected String beforeDeliver$str() {
        return beforeDeliver;
    }

    @Override
    public final void afterDeliverDetails(String messageID, SimpleString queueAddress, SimpleString queueName, String consumerSessionID, long consumerID, MessageReference reference, ServerConsumer consumer) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.afterDeliverDetails$str(), new Object[]{messageID, queueAddress, queueName, consumerSessionID, consumerID, reference, consumer});
    }

    protected String afterDeliverDetails$str() {
        return afterDeliverDetails;
    }

    @Override
    public final void messageAcknowledgedDetails(MessageReference ref, AckReason reason) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.messageAcknowledgedDetails$str(), (Object)ref, (Object)reason);
    }

    protected String messageAcknowledgedDetails$str() {
        return messageAcknowledgedDetails;
    }

    @Override
    public final void beforeDeployBridge(BridgeConfiguration config) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.beforeDeployBridge$str(), (Object)config);
    }

    protected String beforeDeployBridge$str() {
        return beforeDeployBridge;
    }

    @Override
    public final void onSendErrorDetails(String messageID, Message message, String sessionName, Transaction tx, ServerSession session, boolean direct, boolean noAutoCreateQueue) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.onSendErrorDetails$str(), new Object[]{messageID, message, sessionName, tx, session, direct, noAutoCreateQueue});
    }

    protected String onSendErrorDetails$str() {
        return onSendErrorDetails;
    }

    @Override
    public final void onMessageRouteErrorDetails(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.onMessageRouteErrorDetails$str(), new Object[]{message, context, direct, rejectDuplicates});
    }

    protected String onMessageRouteErrorDetails$str() {
        return onMessageRouteErrorDetails;
    }
}

