/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.utils.Preconditions;

public class QueuePendingMessageMetrics {
    private static final AtomicIntegerFieldUpdater<QueuePendingMessageMetrics> COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QueuePendingMessageMetrics.class, "messageCount");
    private static final AtomicIntegerFieldUpdater<QueuePendingMessageMetrics> DURABLE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QueuePendingMessageMetrics.class, "durableMessageCount");
    private static final AtomicLongFieldUpdater<QueuePendingMessageMetrics> SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(QueuePendingMessageMetrics.class, "persistentSize");
    private static final AtomicLongFieldUpdater<QueuePendingMessageMetrics> DURABLE_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(QueuePendingMessageMetrics.class, "durablePersistentSize");
    private volatile int messageCount;
    private volatile long persistentSize;
    private volatile int durableMessageCount;
    private volatile long durablePersistentSize;
    private final Queue queue;

    public QueuePendingMessageMetrics(Queue queue) {
        Preconditions.checkNotNull((Object)queue);
        this.queue = queue;
    }

    public void incrementMetrics(MessageReference reference) {
        long size = this.getPersistentSize(reference);
        COUNT_UPDATER.incrementAndGet(this);
        SIZE_UPDATER.addAndGet(this, size);
        if (this.queue.isDurable() && reference.isDurable()) {
            DURABLE_COUNT_UPDATER.incrementAndGet(this);
            DURABLE_SIZE_UPDATER.addAndGet(this, size);
        }
    }

    public void decrementMetrics(MessageReference reference) {
        long size = -this.getPersistentSize(reference);
        COUNT_UPDATER.decrementAndGet(this);
        SIZE_UPDATER.addAndGet(this, size);
        if (this.queue.isDurable() && reference.isDurable()) {
            DURABLE_COUNT_UPDATER.decrementAndGet(this);
            DURABLE_SIZE_UPDATER.addAndGet(this, size);
        }
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public long getPersistentSize() {
        return this.persistentSize;
    }

    public void setPersistentSize(long persistentSize) {
        this.persistentSize = persistentSize;
    }

    public int getDurableMessageCount() {
        return this.durableMessageCount;
    }

    public void setDurableMessageCount(int durableMessageCount) {
        this.durableMessageCount = durableMessageCount;
    }

    public long getDurablePersistentSize() {
        return this.durablePersistentSize;
    }

    public void setDurablePersistentSize(long durablePersistentSize) {
        this.durablePersistentSize = durablePersistentSize;
    }

    private long getPersistentSize(MessageReference reference) {
        long size = 0L;
        try {
            size = reference.getPersistentSize() > 0L ? reference.getPersistentSize() : 0L;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
        }
        return size;
    }
}

