package org.apache.activemq.artemis.service.extensions.xa.recovery;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.w3c.dom.Node;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Runnable;
import java.lang.Throwable;
import java.lang.Object;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-08-24T20:36:43+0200")
public class ActiveMQXARecoveryLogger_$logger extends DelegatingBasicLogger implements ActiveMQXARecoveryLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQXARecoveryLogger_$logger.class.getName();
    public ActiveMQXARecoveryLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverRunningCachedCommand(final Runnable run) {
        super.log.logv(FQCN, INFO, null, serverRunningCachedCommand$str(), run);
    }
    protected String serverRunningCachedCommand$str() {
        return "AMQ171003: JMS Server Manager Running cached command for {0}";
    }
    @Override
    public final void serverCachingCommand(final Object runnable) {
        super.log.logv(FQCN, INFO, null, serverCachingCommand$str(), runnable);
    }
    protected String serverCachingCommand$str() {
        return "AMQ171004: JMS Server Manager Caching command for {0} since the JMS Server is not active.";
    }
    @Override
    public final void invalidHostForConnector(final String name, final String newHost) {
        super.log.logv(FQCN, WARN, null, invalidHostForConnector$str(), name, newHost);
    }
    protected String invalidHostForConnector$str() {
        return "AMQ172005: Invalid \"host\" value \"0.0.0.0\" detected for \"{0}\" connector. Switching to \"{1}\". If this new address is incorrect please manually configure the connector to use the proper one.";
    }
    @Override
    public final void noQueueOnTopic(final String queueName, final String name) {
        super.log.logv(FQCN, WARN, null, noQueueOnTopic$str(), queueName, name);
    }
    protected String noQueueOnTopic$str() {
        return "AMQ172007: Queue {0} does not exist on the topic {1}. It was deleted manually probably.";
    }
    @Override
    public final void recoveryConnectFailed(final String s) {
        super.log.logv(FQCN, WARN, null, recoveryConnectFailed$str(), s);
    }
    protected String recoveryConnectFailed$str() {
        return "AMQ172008: XA Recovery can not connect to any broker on recovery {0}";
    }
    @Override
    public final void jndiUnbindError(final Exception e, final String key) {
        super.log.logv(FQCN, WARN, e, jndiUnbindError$str(), key);
    }
    protected String jndiUnbindError$str() {
        return "AMQ172011: error unbinding {0} from JNDI";
    }
    @Override
    public final void jmsServerError(final Exception e) {
        super.log.logv(FQCN, WARN, e, jmsServerError$str());
    }
    protected String jmsServerError$str() {
        return "AMQ172012: JMS Server Manager error";
    }
    @Override
    public final void xaRecoverError(final Exception e) {
        super.log.logv(FQCN, WARN, e, xaRecoverError$str());
    }
    protected String xaRecoverError$str() {
        return "AMQ172013: Error in XA Recovery recover";
    }
    @Override
    public final void xaRecoverConnectionError(final Exception e, final ClientSessionFactory csf) {
        super.log.logv(FQCN, WARN, e, xaRecoverConnectionError$str(), csf);
    }
    protected String xaRecoverConnectionError$str() {
        return "AMQ172014: Notified of connection failure in xa recovery connectionFactory for provider {0} will attempt reconnect on next pass";
    }
    @Override
    public final void xaRecoverAutoConnectionError(final Throwable e, final org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig csf) {
        super.log.logv(FQCN, WARN, e, xaRecoverAutoConnectionError$str(), csf);
    }
    protected String xaRecoverAutoConnectionError$str() {
        return "AMQ172015: Can not connect to {0} on auto-generated resource recovery";
    }
    @Override
    public final void xaRecoveryError(final Exception e) {
        super.log.logv(FQCN, DEBUG, e, xaRecoveryError$str());
    }
    protected String xaRecoveryError$str() {
        return "AMQ172016: Error in XA Recovery";
    }
    @Override
    public final void failedToCorrectHost(final Exception e, final String name) {
        super.log.logv(FQCN, WARN, e, failedToCorrectHost$str(), name);
    }
    protected String failedToCorrectHost$str() {
        return "AMQ172017: Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{0}\" connector, but received an exception.";
    }
    @Override
    public final void xaRecoveryStartError(final org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig e) {
        super.log.logv(FQCN, WARN, null, xaRecoveryStartError$str(), e);
    }
    protected String xaRecoveryStartError$str() {
        return "AMQ172018: Could not start recovery discovery on {0}, we will retry every recovery scan until the server is available";
    }
    @Override
    public final void jmsConfigMissingKey(final Node e) {
        super.log.logv(FQCN, ERROR, null, jmsConfigMissingKey$str(), e);
    }
    protected String jmsConfigMissingKey$str() {
        return "AMQ174000: key attribute missing for JMS configuration {0}";
    }
    @Override
    public final void jmsDeployerStartError(final Exception e) {
        super.log.logv(FQCN, ERROR, e, jmsDeployerStartError$str());
    }
    protected String jmsDeployerStartError$str() {
        return "AMQ174002: Failed to start JMS deployer";
    }
}
