/* This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
   and it inherits whatever license is declared at org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXARecoveryLogger */

package org.apache.activemq.artemis.service.extensions.xa.recovery;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(retiredIDs={171003, 171004, 172005, 172011, 172012, 172017, 172018, 174000, 174002}, regexID="17[0-9]{4}", projectCode="AMQ")
public class ActiveMQXARecoveryLogger_impl implements ActiveMQXARecoveryLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQXARecoveryLogger_impl(Logger logger) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=172007, value=\"Queue {} does not exist on the topic {}. It was deleted manually probably.\", level=WARN)
   @Override
   public void noQueueOnTopic(java.lang.String queueName, java.lang.String name) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172007: Queue {} does not exist on the topic {}. It was deleted manually probably.", queueName, name);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=172008, value=\"XA Recovery can not connect to any broker on recovery {}\", level=WARN)
   @Override
   public void recoveryConnectFailed(java.lang.String s) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172008: XA Recovery can not connect to any broker on recovery {}", s);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=172013, value=\"Error in XA Recovery recover\", level=WARN)
   @Override
   public void xaRecoverError(java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172013: Error in XA Recovery recover", e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=172014, value=\"Notified of connection failure in xa recovery connectionFactory for provider {} will attempt reconnect on next pass\", level=WARN)
   @Override
   public void xaRecoverConnectionError(org.apache.activemq.artemis.api.core.client.ClientSessionFactory csf, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172014: Notified of connection failure in xa recovery connectionFactory for provider {} will attempt reconnect on next pass", csf, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=172015, value=\"Can not connect to {} on auto-generated resource recovery\", level=WARN)
   @Override
   public void xaRecoverAutoConnectionError(org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig csf, java.lang.Throwable e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ172015: Can not connect to {} on auto-generated resource recovery", csf, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=172016, value=\"Error in XA Recovery\", level=DEBUG)
   @Override
   public void xaRecoveryError(java.lang.Exception e) {
      if (logger.isDebugEnabled()) {
         logger.debug("AMQ172016: Error in XA Recovery", e);
      }
   }

}
