package org.apache.activemq.artemis.core.protocol.stomp;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.jboss.logging.DelegatingBasicLogger;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-08-09T13:00:06-0400")
public class ActiveMQStompProtocolLogger_$logger extends DelegatingBasicLogger implements ActiveMQStompProtocolLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQStompProtocolLogger_$logger.class.getName();
    public ActiveMQStompProtocolLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void connectionClosed(final org.apache.activemq.artemis.core.protocol.stomp.StompConnection connection) {
        super.log.logv(FQCN, WARN, null, connectionClosed$str(), connection);
    }
    protected String connectionClosed$str() {
        return "AMQ332068: connection closed {0}";
    }
    @Override
    public final void sentErrorToClient(final String address, final String message) {
        super.log.logv(FQCN, WARN, null, sentErrorToClient$str(), address, message);
    }
    protected String sentErrorToClient$str() {
        return "AMQ332069: Sent ERROR frame to STOMP client {0}: {1}";
    }
    @Override
    public final void errorSendingFrame(final Exception e, final org.apache.activemq.artemis.core.protocol.stomp.StompFrame frame) {
        super.log.logv(FQCN, ERROR, e, errorSendingFrame$str(), frame);
    }
    protected String errorSendingFrame$str() {
        return "AMQ334023: Unable to send frame {0}";
    }
}
