package org.apache.activemq.artemis.core.protocol.stomp;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.apache.activemq.artemis.api.core.Message;
import java.lang.Long;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import java.lang.String;
import java.util.Arrays;
import java.lang.Exception;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2022-07-26T12:05:18-0400")
public class ActiveMQStompProtocolMessageBundle_$bundle implements ActiveMQStompProtocolMessageBundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQStompProtocolMessageBundle_$bundle() {}
    public static final ActiveMQStompProtocolMessageBundle_$bundle INSTANCE = new ActiveMQStompProtocolMessageBundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String negativeConnectionTTL$str() {
        return "AMQ339000: Stomp Connection TTL cannot be negative: {0}";
    }
    @Override
    public final IllegalStateException negativeConnectionTTL(final Long ttl) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(negativeConnectionTTL$str(), ttl));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String destinationNotExist$str() {
        return "AMQ339001: Destination does not exist: {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException destinationNotExist(final String destination) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(destinationNotExist$str(), destination));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String versionNotSupported$str() {
        return "AMQ339002: Stomp versions not supported: {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException versionNotSupported(final String acceptVersion) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(versionNotSupported$str(), acceptVersion));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullHostHeader$str() {
        return "AMQ339003: Header host is null";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException nullHostHeader() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), nullHostHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hostCannotBeNull$str() {
        return "AMQ339004: Cannot accept null as host";
    }
    @Override
    public final String hostCannotBeNull() {
        return String.format(getLoggingLocale(), hostCannotBeNull$str());
    }
    protected String hostNotMatch$str() {
        return "AMQ339005: Header host does not match server host";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException hostNotMatch() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), hostNotMatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hostNotMatchDetails$str() {
        return "AMQ339006: host {0} does not match server host name";
    }
    @Override
    public final String hostNotMatchDetails(final String host) {
        return _formatMessage(hostNotMatchDetails$str(), host);
    }
    protected String connectionDestroyed$str() {
        return "AMQ339007: Connection was destroyed.";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException connectionDestroyed() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), connectionDestroyed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionNotEstablished$str() {
        return "AMQ339008: Connection has not been established.";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException connectionNotEstablished() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), connectionNotEstablished$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorGetSession$str() {
        return "AMQ339009: Exception getting session";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorGetSession(final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), errorGetSession$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidConnection$str() {
        return "AMQ339010: Connection is not valid.";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException invalidConnection() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), invalidConnection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorSendMessage$str() {
        return "AMQ339011: Error sending message {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorSendMessage(final Message message, final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(errorSendMessage$str(), message), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorBeginTx$str() {
        return "AMQ339012: Error beginning a transaction {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorBeginTx(final String txID, final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(errorBeginTx$str(), txID), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCommitTx$str() {
        return "AMQ339013: Error committing {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorCommitTx(final String txID, final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(errorCommitTx$str(), txID), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorAbortTx$str() {
        return "AMQ339014: Error aborting {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorAbortTx(final String txID, final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(errorAbortTx$str(), txID), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDestination$str() {
        return "AMQ339015: Client must set destination or id header to a SUBSCRIBE command";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException noDestination() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), noDestination$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingSubscription$str() {
        return "AMQ339016: Error creating subscription {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorCreatingSubscription(final String subscriptionID, final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(errorCreatingSubscription$str(), subscriptionID), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorUnsubscribing$str() {
        return "AMQ339017: Error unsubscribing {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorUnsubscribing(final String subscriptionID, final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(errorUnsubscribing$str(), subscriptionID), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorAck$str() {
        return "AMQ339018: Error acknowledging message {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorAck(final String messageID, final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(errorAck$str(), messageID), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTwoCRs$str() {
        return "AMQ339019: Invalid char sequence: two consecutive CRs.";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException invalidTwoCRs() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), invalidTwoCRs$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String badCRs$str() {
        return "AMQ339020: Invalid char sequence: There is a CR not followed by an LF";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException badCRs() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), badCRs$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notValidNewLine$str() {
        return "AMQ339021: Expect new line char but is {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException notValidNewLine(final byte b) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(notValidNewLine$str(), b));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedNewLine$str() {
        return "AMQ339022: Expect new line char but is {0}";
    }
    @Override
    public final String unexpectedNewLine(final byte b) {
        return _formatMessage(unexpectedNewLine$str(), b);
    }
    protected String invalidCommand$str() {
        return "AMQ339023: Invalid STOMP frame: {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException invalidCommand(final String dumpByteArray) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(invalidCommand$str(), dumpByteArray));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidFrame$str() {
        return "AMQ339024: Invalid STOMP frame: {0}";
    }
    @Override
    public final String invalidFrame(final String dumpByteArray) {
        return _formatMessage(invalidFrame$str(), dumpByteArray);
    }
    protected String failToAckMissingID$str() {
        return "AMQ339025: failed to ack because no message with id: {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException failToAckMissingID(final long id) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(failToAckMissingID$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String subscriptionIDMismatch$str() {
        return "AMQ339026: subscription id {0} does not match {1}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException subscriptionIDMismatch(final String subscriptionID, final String actualID) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(subscriptionIDMismatch$str(), subscriptionID, actualID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingClientID$str() {
        return "AMQ339027: Cannot create a subscriber on the durable subscription if the client-id of the connection is not set";
    }
    @Override
    public final IllegalStateException missingClientID() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingClientID$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String headerTooBig$str() {
        return "AMQ339028: Message header too big, increase minLargeMessageSize please.";
    }
    @Override
    public final Exception headerTooBig() {
        final Exception result = new Exception(String.format(getLoggingLocale(), headerTooBig$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownCommand$str() {
        return "AMQ339029: Unsupported command: {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException unknownCommand(final String command) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(unknownCommand$str(), command));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String needTxIDHeader$str() {
        return "AMQ339030: transaction header is mandatory to COMMIT a transaction";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException needTxIDHeader() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), needTxIDHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorHandleSend$str() {
        return "AMQ339031: Error handling send";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException errorHandleSend(final Exception e) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), errorHandleSend$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beginTxNoID$str() {
        return "AMQ339032: Need a transaction id to begin";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException beginTxNoID() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), beginTxNoID$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String abortTxNoID$str() {
        return "AMQ339033: transaction header is mandatory to ABORT a transaction";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException abortTxNoID() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), abortTxNoID$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCall$str() {
        return "AMQ339034: This method should not be called";
    }
    @Override
    public final IllegalStateException invalidCall() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidCall$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String needIDorDestination$str() {
        return "AMQ339035: Must specify the subscription''s id or the destination you are unsubscribing from";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException needIDorDestination() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), needIDorDestination$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String needSubscriptionID$str() {
        return "AMQ339037: Must specify the subscription''s id";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException needSubscriptionID() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), needSubscriptionID$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noIDInAck$str() {
        return "AMQ339039: No id header in ACK/NACK frame.";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException noIDInAck() {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(String.format(getLoggingLocale(), noIDInAck$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String undefinedEscapeSequence$str() {
        return "AMQ339040: Undefined escape sequence: {0}";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException undefinedEscapeSequence(final String sequence) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(undefinedEscapeSequence$str(), sequence));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalSemantics$str() {
        return "AMQ339041: Not allowed to specify {0} semantics on {1} address.";
    }
    @Override
    public final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException illegalSemantics(final String requested, final String exists) {
        final org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException result = new org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException(_formatMessage(illegalSemantics$str(), requested, exists));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
