/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.util.Arrays;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolLogger;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.slf4j.Logger;

public class ActiveMQStompProtocolLogger_impl
implements ActiveMQStompProtocolLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQStompProtocolLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void connectionClosed(StompConnection connection) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ332068: connection closed {}", (Object)connection);
        }
    }

    @Override
    public void sentErrorToClient(String address, String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ332069: Sent ERROR frame to STOMP client {}: {}", (Object)address, (Object)message);
        }
    }

    @Override
    public void errorSendingFrame(StompFrame frame, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ332070: Unable to send frame {}", (Object)frame, (Object)e);
        }
    }
}

