/* This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
   and it inherits whatever license is declared at org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolLogger */

package org.apache.activemq.artemis.core.protocol.stomp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(retiredIDs={}, regexID="33[0-8][0-9]{3}", projectCode="AMQ")
public class ActiveMQStompProtocolLogger_impl implements ActiveMQStompProtocolLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQStompProtocolLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=332068, value=\"connection closed {}\", level=WARN)
   @Override
   public void connectionClosed(org.apache.activemq.artemis.core.protocol.stomp.StompConnection connection) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ332068: connection closed {}", connection);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=332069, value=\"Sent ERROR frame to STOMP client {}: {}\", level=WARN)
   @Override
   public void sentErrorToClient(java.lang.String address, java.lang.String message) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ332069: Sent ERROR frame to STOMP client {}: {}", address, message);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=332070, value=\"Unable to send frame {}\", level=ERROR)
   @Override
   public void errorSendingFrame(org.apache.activemq.artemis.core.protocol.stomp.StompFrame frame, java.lang.Exception e) {
      if (logger.isErrorEnabled()) {
         logger.error("AMQ332070: Unable to send frame {}", frame, e);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(loggerName=\"\", id=332071, value=\"Unable to send message to client: {}\", level=WARN)
   @Override
   public void unableToSendMessageToClient(org.apache.activemq.artemis.api.core.ICoreMessage message, java.lang.Exception e) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ332071: Unable to send message to client: {}", message, e);
      }
   }

}
