/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.logs;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="AssertionLoggerHandler", category="Core", elementType="appender")
public class AssertionLoggerHandler
extends AbstractAppender {
    private static final Map<String, LogEvent> messages = new ConcurrentHashMap<String, LogEvent>();
    private static List<String> traceMessages;
    private static volatile boolean capture;
    private static volatile boolean captureStackTrace;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    protected AssertionLoggerHandler(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent event) {
        if (capture) {
            Object formattedMessage = event.getMessage().getFormattedMessage();
            if (captureStackTrace && event.getThrown() != null) {
                StringWriter stackOutput = new StringWriter();
                event.getThrown().printStackTrace(new PrintWriter(stackOutput));
                formattedMessage = (String)formattedMessage + stackOutput.toString();
            }
            messages.put((String)formattedMessage, event);
            if (traceMessages != null) {
                traceMessages.add((String)formattedMessage);
            }
        }
    }

    public static boolean hasLevel(LogLevel level) {
        Level implLevel = level.toImplLevel();
        for (LogEvent event : messages.values()) {
            if (!implLevel.equals((Object)event.getLevel())) continue;
            return true;
        }
        return false;
    }

    public static LogLevel setLevel(String loggerName, LogLevel level) {
        Level newLevel;
        Logger logger = LogManager.getLogger((String)loggerName);
        Level existingLevel = logger.getLevel();
        if (!existingLevel.equals((Object)(newLevel = level.toImplLevel()))) {
            Configurator.setLevel((Logger)logger, (Level)newLevel);
        }
        return LogLevel.fromImplLevel(existingLevel);
    }

    public static boolean findText(long mstimeout, String ... text) {
        long timeMax = System.currentTimeMillis() + mstimeout;
        do {
            if (!AssertionLoggerHandler.findText(text)) continue;
            return true;
        } while (timeMax > System.currentTimeMillis());
        return false;
    }

    public static boolean findText(String ... text) {
        for (Map.Entry<String, LogEvent> entry : messages.entrySet()) {
            Throwable throwable;
            String txtCheck;
            String key = entry.getKey();
            boolean found = true;
            String[] stringArray = text;
            int n = stringArray.length;
            for (int i = 0; i < n && ((found = key.contains(txtCheck = stringArray[i])) || (throwable = entry.getValue().getThrown()) != null && throwable.getMessage() != null && (found = throwable.getMessage().contains(txtCheck))); ++i) {
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static int countText(String ... text) {
        int found = 0;
        if (traceMessages != null) {
            for (String str : traceMessages) {
                for (String txtCheck : text) {
                    if (!str.contains(txtCheck)) continue;
                    ++found;
                }
            }
        } else {
            for (Map.Entry<String, LogEvent> entry : messages.entrySet()) {
                String key = entry.getKey();
                for (String txtCheck : text) {
                    if (!key.contains(txtCheck)) continue;
                    ++found;
                }
            }
        }
        return found;
    }

    public static boolean matchText(String pattern) {
        Pattern r = Pattern.compile(pattern);
        for (Map.Entry<String, LogEvent> entry : messages.entrySet()) {
            if (r.matcher(entry.getKey()).matches()) {
                return true;
            }
            Throwable throwable = entry.getValue().getThrown();
            if (throwable == null || throwable.getMessage() == null || !r.matcher(throwable.getMessage()).matches()) continue;
            return true;
        }
        return false;
    }

    public static final void clear() {
        messages.clear();
        if (traceMessages != null) {
            traceMessages.clear();
        }
    }

    public static final void startCapture() {
        AssertionLoggerHandler.startCapture(false);
    }

    public static final void startCapture(boolean individualMessages) {
        AssertionLoggerHandler.startCapture(individualMessages, captureStackTrace);
    }

    public static final void startCapture(boolean individualMessages, boolean captureStackTrace) {
        AssertionLoggerHandler.clear();
        if (individualMessages) {
            traceMessages = new LinkedList<String>();
        }
        capture = true;
        AssertionLoggerHandler.captureStackTrace = captureStackTrace;
    }

    public static final void stopCapture() {
        capture = false;
        captureStackTrace = false;
        AssertionLoggerHandler.clear();
        traceMessages = null;
    }

    static {
        capture = false;
        captureStackTrace = false;
    }

    public static enum LogLevel {
        OFF(Level.OFF),
        FATAL(Level.FATAL),
        ERROR(Level.ERROR),
        WARN(Level.WARN),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG),
        TRACE(Level.TRACE);

        Level implLevel;

        private LogLevel(Level implLevel) {
            this.implLevel = implLevel;
        }

        private Level toImplLevel() {
            return this.implLevel;
        }

        private static LogLevel fromImplLevel(Level implLevel) {
            if (Level.FATAL.equals((Object)implLevel)) {
                return FATAL;
            }
            if (Level.ERROR.equals((Object)implLevel)) {
                return ERROR;
            }
            if (Level.WARN.equals((Object)implLevel)) {
                return WARN;
            }
            if (Level.INFO.equals((Object)implLevel)) {
                return INFO;
            }
            if (Level.DEBUG.equals((Object)implLevel)) {
                return DEBUG;
            }
            if (Level.TRACE.equals((Object)implLevel)) {
                return TRACE;
            }
            if (Level.OFF.equals((Object)implLevel)) {
                return OFF;
            }
            throw new IllegalArgumentException("Unexpected level:" + implLevel);
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<AssertionLoggerHandler> {
        public AssertionLoggerHandler build() {
            return new AssertionLoggerHandler(this.getName(), this.getFilter(), (Layout<? extends Serializable>)this.getOrCreateLayout(), this.isIgnoreExceptions(), this.getPropertyArray());
        }
    }
}

