/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class PortCheckRule
extends TestWatcher {
    final int[] port;

    public PortCheckRule(int ... port) {
        this.port = port;
    }

    protected void starting(Description description) {
        for (int p : this.port) {
            if (PortCheckRule.checkAvailable(p)) continue;
            Assert.fail((String)("a previous test is using port " + p + " on " + description));
        }
    }

    protected void finished(Description description) {
        for (int p : this.port) {
            if (PortCheckRule.checkAvailable(p)) continue;
            Assert.fail((String)(description + " has left a server socket open on port " + p));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAvailable(int port) {
        ServerSocket s = null;
        try {
            s = new ServerSocket();
            s.bind(new InetSocketAddress("localhost", 61616));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

