/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.rules;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.nativo.jlibaio.LibaioContext;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibaioContextCheck
extends TestWatcher {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int INTERVAL = 100;
    private static final int WAIT = 20000;
    private static String previouslyFailedTotalMaxIoMessage;

    protected void starting(Description description) {
        LibaioContextCheck.checkLibaioBefore(description.getClassName());
    }

    protected void finished(Description description) {
        LibaioContextCheck.checkLibaioAfter(description.getClassName());
    }

    public static void checkLibaioBefore(String testClassName) {
        long totalMaxIO;
        if (previouslyFailedTotalMaxIoMessage != null) {
            Assert.fail((String)previouslyFailedTotalMaxIoMessage);
        }
        if ((totalMaxIO = LibaioContext.getTotalMaxIO()) != 0L) {
            LibaioContextCheck.failDueToLibaioContextCheck("LibaioContext TotalMaxIO > 0 leak detected BEFORE class %s, TotalMaxIO=%s. Check prior test classes for issue (not possible to be sure of which here).", testClassName, totalMaxIO);
        }
    }

    public static void checkLibaioAfter(String testClassName) {
        if (previouslyFailedTotalMaxIoMessage != null) {
            return;
        }
        try {
            if (!LibaioContextCheck.waitForLibaioContextTotalMaxIo(testClassName)) {
                long totalMaxIO = LibaioContext.getTotalMaxIO();
                LibaioContextCheck.failDueToLibaioContextCheck("LibaioContext TotalMaxIO > 0 leak detected AFTER class %s, TotalMaxIO=%s.", testClassName, totalMaxIO);
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Exception while checking Libaio after tests in class: " + testClassName));
        }
    }

    private static boolean waitForLibaioContextTotalMaxIo(String testClassName) {
        AtomicBoolean firstCheck = new AtomicBoolean();
        return Wait.waitFor(() -> {
            boolean totalIsZero;
            boolean bl = totalIsZero = LibaioContext.getTotalMaxIO() == 0L;
            if (!totalIsZero && firstCheck.compareAndSet(false, true)) {
                logger.info("Waiting for LibaioContext TotalMaxIO to become 0 after class {}", (Object)testClassName);
            }
            return totalIsZero;
        }, 20000L, 100L);
    }

    private static void failDueToLibaioContextCheck(String currentFailureMessageFormat, String testClassName, long totalMaxIO) {
        previouslyFailedTotalMaxIoMessage = String.format("Aborting, LibaioContext TotalMaxIO > 0 issue previously detected by test class %s, see its output.", testClassName);
        String message = String.format(currentFailureMessageFormat, testClassName, totalMaxIO);
        logger.error(message);
        Assert.fail((String)message);
    }
}

