/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.rules;

import java.io.File;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class NoFilesBehind
extends TestWatcher {
    private final String[] filesToCheck;

    public NoFilesBehind(String ... filesToCheck) {
        this.filesToCheck = filesToCheck;
    }

    private File checkFiles() {
        for (String f : this.filesToCheck) {
            File fileCheck = new File(f);
            if (!fileCheck.exists()) continue;
            return fileCheck;
        }
        return null;
    }

    protected void starting(Description description) {
        File leaked = this.checkFiles();
        if (leaked != null) {
            Assert.fail((String)("A previous test left a folder around:: " + leaked.getAbsolutePath()));
        }
    }

    protected void finished(Description description) {
        File leaked = this.checkFiles();
        if (leaked != null) {
            Assert.fail((String)(leaked.getAbsolutePath() + "A directory is being left behind: " + leaked.getAbsolutePath()));
        }
    }
}

