/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.rules;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class NoProcessFilesBehind
extends TestWatcher {
    private long maxFiles;
    static OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();

    public NoProcessFilesBehind(long maxFiles) {
        this.maxFiles = maxFiles;
    }

    public static long getOpenFD() {
        if (os instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount();
        }
        return 0L;
    }

    public static List<String> getOpenFiles(boolean filtered) {
        ArrayList<String> openFiles = new ArrayList<String>();
        try {
            int processId = NoProcessFilesBehind.getProcessId();
            Process child = Runtime.getRuntime().exec("lsof -a -p " + processId + " -d ^txt,^mem,^cwd,^rtd,^DEL", new String[0]);
            try (BufferedReader processInput = new BufferedReader(new InputStreamReader(child.getInputStream()));){
                String outputLine;
                processInput.readLine();
                while ((outputLine = processInput.readLine()) != null) {
                    if (filtered && (outputLine.endsWith(".jar") || outputLine.endsWith(".so") || outputLine.contains("type=STREAM"))) continue;
                    openFiles.add(outputLine);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return openFiles;
    }

    private static int getProcessId() throws ReflectiveOperationException {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        Field jvmField = runtime.getClass().getDeclaredField("jvm");
        jvmField.setAccessible(true);
        Object jvm = jvmField.get(runtime);
        Method getProcessIdMethod = jvm.getClass().getDeclaredMethod("getProcessId", new Class[0]);
        getProcessIdMethod.setAccessible(true);
        return (Integer)getProcessIdMethod.invoke(jvm, new Object[0]);
    }

    protected void finished(Description description) {
        if (!Wait.waitFor(() -> NoProcessFilesBehind.getOpenFD() < this.maxFiles, 10000L, 0L)) {
            String fileList = this.getOpenList();
            Assert.fail((String)("Too many files open (" + NoProcessFilesBehind.getOpenFD() + ">" + this.maxFiles + "). A possible list: " + fileList));
        }
    }

    private String getOpenList() {
        List<String> openFiles = NoProcessFilesBehind.getOpenFiles(true);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        boolean first = true;
        for (String str : openFiles) {
            if (!first) {
                printWriter.print("\n");
            }
            first = false;
            printWriter.print(str);
        }
        return stringWriter.toString();
    }
}

