/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.apache.activemq.artemis.tests.rules.NoFilesBehind;
import org.apache.activemq.artemis.tests.rules.NoProcessFilesBehind;
import org.apache.activemq.artemis.utils.CleanupSystemPropertiesRule;
import org.apache.activemq.artemis.utils.ThreadLeakCheckRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArtemisTestCase
extends Assert {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static String testClassName = "not-yet-set";
    @ClassRule
    public static ThreadLeakCheckRule leakCheckRule = new ThreadLeakCheckRule();
    @ClassRule
    public static NoProcessFilesBehind noProcessFilesBehind = new NoProcessFilesBehind(1000L);
    @ClassRule
    public static TestRule classWatcher = new TestWatcher(){

        protected void starting(Description description) {
            testClassName = description.getClassName();
        }
    };
    @Rule
    public NoFilesBehind noFilesBehind = new NoFilesBehind("data", "null");
    @Rule
    public CleanupSystemPropertiesRule propertiesRule = new CleanupSystemPropertiesRule();
    @Rule
    public TestName name = new TestName();
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            logger.info("**** start #test {}() ***", (Object)description.getMethodName());
        }

        protected void finished(Description description) {
            logger.info("**** end #test {}() ***", (Object)description.getMethodName());
        }
    };
    private List<TestCompletionTask> runAfter;

    protected void runAfter(TestCompletionTask completionTask) {
        Assert.assertNotNull((Object)completionTask);
        this.runAfterEx(() -> {
            try {
                completionTask.run();
            }
            catch (Throwable e) {
                logger.warn("Lambda {} is throwing an exception", (Object)completionTask.toString(), (Object)e);
            }
        });
    }

    protected synchronized void runAfterEx(TestCompletionTask completionTask) {
        Assert.assertNotNull((Object)completionTask);
        if (this.runAfter == null) {
            this.runAfter = new ArrayList<TestCompletionTask>();
        }
        this.runAfter.add(completionTask);
    }

    @After
    public synchronized void runAfter() throws Throwable {
        ArrayList throwables = new ArrayList();
        List<TestCompletionTask> localRunAfter = this.runAfter;
        this.runAfter = null;
        if (localRunAfter != null) {
            localRunAfter.forEach(r -> {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage(), e);
                    throwables.add(e);
                }
            });
        }
        if (!throwables.isEmpty()) {
            throw (Throwable)throwables.get(0);
        }
    }

    public static void forceGC() {
        ThreadLeakCheckRule.forceGC();
    }

    public MBeanServer createMBeanServer() {
        MBeanServer mBeanServer = MBeanServerFactory.createMBeanServer();
        this.runAfter(() -> MBeanServerFactory.releaseMBeanServer(mBeanServer));
        return mBeanServer;
    }

    public static String getTestClassName() {
        return testClassName;
    }

    public static interface TestCompletionTask {
        public void run() throws Exception;
    }
}

