/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.activemq.artemis.ActiveMQWebLogger;
import org.apache.activemq.artemis.component.WebTmpCleaner;
import org.apache.activemq.artemis.components.ExternalComponent;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.logging.Logger;

public class WebServerComponent
implements ExternalComponent {
    private static final Logger logger = Logger.getLogger(WebServerComponent.class);
    private Server server;
    private HandlerList handlers;
    private WebServerDTO webServerConfig;
    private URI uri;
    private String consoleUrl;
    private List<WebAppContext> webContexts;
    private ServerConnector connector;
    private Path artemisHomePath;

    public void configure(ComponentDTO config, String artemisInstance, String artemisHome) throws Exception {
        this.webServerConfig = (WebServerDTO)config;
        this.uri = new URI(this.webServerConfig.bind);
        this.server = new Server();
        String scheme = this.uri.getScheme();
        if ("https".equals(scheme)) {
            SslContextFactory sslFactory = new SslContextFactory();
            sslFactory.setKeyStorePath(this.webServerConfig.keyStorePath == null ? artemisInstance + "/etc/keystore.jks" : this.webServerConfig.keyStorePath);
            sslFactory.setKeyStorePassword(this.webServerConfig.getKeyStorePassword() == null ? "password" : this.webServerConfig.getKeyStorePassword());
            if (this.webServerConfig.clientAuth != null) {
                sslFactory.setNeedClientAuth(this.webServerConfig.clientAuth.booleanValue());
                if (this.webServerConfig.clientAuth.booleanValue()) {
                    sslFactory.setTrustStorePath(this.webServerConfig.trustStorePath);
                    sslFactory.setTrustStorePassword(this.webServerConfig.getTrustStorePassword());
                }
            }
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslFactory, "HTTP/1.1");
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            https.setSendServerVersion(false);
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(https);
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{sslConnectionFactory, httpFactory});
        } else {
            HttpConfiguration configuration = new HttpConfiguration();
            configuration.setSendServerVersion(false);
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(configuration);
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{connectionFactory});
        }
        this.connector.setPort(this.uri.getPort());
        this.connector.setHost(this.uri.getHost());
        this.server.setConnectors(new Connector[]{this.connector});
        this.handlers = new HandlerList();
        this.artemisHomePath = Paths.get(artemisHome != null ? artemisHome : ".", new String[0]);
        Path homeWarDir = this.artemisHomePath.resolve(this.webServerConfig.path).toAbsolutePath();
        Path instanceWarDir = Paths.get(artemisInstance != null ? artemisInstance : ".", new String[0]).resolve(this.webServerConfig.path).toAbsolutePath();
        if (this.webServerConfig.apps != null && this.webServerConfig.apps.size() > 0) {
            this.webContexts = new ArrayList<WebAppContext>();
            for (AppDTO app : this.webServerConfig.apps) {
                Path dirToUse = homeWarDir;
                if (new File(instanceWarDir.toFile().toString() + File.separator + app.war).exists()) {
                    dirToUse = instanceWarDir;
                }
                WebAppContext webContext = this.deployWar(app.url, app.war, dirToUse);
                this.webContexts.add(webContext);
                if (!app.war.startsWith("console")) continue;
                this.consoleUrl = this.webServerConfig.bind + "/" + app.url;
            }
        }
        ResourceHandler homeResourceHandler = new ResourceHandler();
        homeResourceHandler.setResourceBase(homeWarDir.toString());
        homeResourceHandler.setDirectoriesListed(false);
        homeResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        ContextHandler homeContext = new ContextHandler();
        homeContext.setContextPath("/");
        homeContext.setResourceBase(homeWarDir.toString());
        homeContext.setHandler((Handler)homeResourceHandler);
        homeContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        ResourceHandler instanceResourceHandler = new ResourceHandler();
        instanceResourceHandler.setResourceBase(instanceWarDir.toString());
        instanceResourceHandler.setDirectoriesListed(false);
        instanceResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        ContextHandler instanceContext = new ContextHandler();
        instanceContext.setContextPath("/");
        instanceContext.setResourceBase(instanceWarDir.toString());
        instanceContext.setHandler((Handler)instanceResourceHandler);
        homeContext.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServeIcon(false);
        if (this.webServerConfig.requestLog != null) {
            this.handlers.addHandler((Handler)this.getLogHandler());
        }
        this.handlers.addHandler((Handler)homeContext);
        this.handlers.addHandler((Handler)instanceContext);
        this.handlers.addHandler((Handler)defaultHandler);
        this.server.setHandler((Handler)this.handlers);
    }

    private RequestLogHandler getLogHandler() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        NCSARequestLog requestLog = new NCSARequestLog();
        requestLog.setFilename(this.webServerConfig.requestLog.filename);
        if (this.webServerConfig.requestLog.append != null) {
            requestLog.setAppend(this.webServerConfig.requestLog.append.booleanValue());
        }
        if (this.webServerConfig.requestLog.extended != null) {
            requestLog.setExtended(this.webServerConfig.requestLog.extended.booleanValue());
        }
        if (this.webServerConfig.requestLog.logCookies != null) {
            requestLog.setLogCookies(this.webServerConfig.requestLog.logCookies.booleanValue());
        }
        if (this.webServerConfig.requestLog.logTimeZone != null) {
            requestLog.setLogTimeZone(this.webServerConfig.requestLog.logTimeZone);
        }
        if (this.webServerConfig.requestLog.filenameDateFormat != null) {
            requestLog.setFilenameDateFormat(this.webServerConfig.requestLog.filenameDateFormat);
        }
        if (this.webServerConfig.requestLog.retainDays != null) {
            requestLog.setRetainDays(this.webServerConfig.requestLog.retainDays.intValue());
        }
        if (this.webServerConfig.requestLog.ignorePaths != null && this.webServerConfig.requestLog.ignorePaths.length() > 0) {
            String[] split = this.webServerConfig.requestLog.ignorePaths.split(",");
            String[] ignorePaths = new String[split.length];
            for (int i = 0; i < ignorePaths.length; ++i) {
                ignorePaths[i] = split[i].trim();
            }
            requestLog.setIgnorePaths(ignorePaths);
        }
        if (this.webServerConfig.requestLog.logDateFormat != null) {
            requestLog.setLogDateFormat(this.webServerConfig.requestLog.logDateFormat);
        }
        if (this.webServerConfig.requestLog.logLocale != null) {
            requestLog.setLogLocale(Locale.forLanguageTag(this.webServerConfig.requestLog.logLocale));
        }
        if (this.webServerConfig.requestLog.logLatency != null) {
            requestLog.setLogLatency(this.webServerConfig.requestLog.logLatency.booleanValue());
        }
        if (this.webServerConfig.requestLog.logServer != null) {
            requestLog.setLogServer(this.webServerConfig.requestLog.logServer.booleanValue());
        }
        if (this.webServerConfig.requestLog.preferProxiedForAddress != null) {
            requestLog.setPreferProxiedForAddress(this.webServerConfig.requestLog.preferProxiedForAddress.booleanValue());
        }
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        return requestLogHandler;
    }

    public void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this.server.start();
        ActiveMQWebLogger.LOGGER.webserverStarted(this.webServerConfig.bind);
        if (this.consoleUrl != null) {
            ActiveMQWebLogger.LOGGER.jolokiaAvailable(this.consoleUrl + "/jolokia");
            ActiveMQWebLogger.LOGGER.consoleAvailable(this.consoleUrl);
        }
    }

    public void internalStop() throws Exception {
        this.server.stop();
        if (this.webContexts != null) {
            this.cleanupWebTemporaryFiles(this.webContexts);
            this.webContexts.clear();
        }
    }

    private File getLibFolder() {
        Path lib = this.artemisHomePath.resolve("lib");
        File libFolder = new File(lib.toUri());
        return libFolder;
    }

    public void cleanupWebTemporaryFiles(List<WebAppContext> webContexts) throws Exception {
        ArrayList<File> temporaryFiles = new ArrayList<File>();
        for (WebAppContext context : webContexts) {
            File tmpdir = context.getTempDirectory();
            temporaryFiles.add(tmpdir);
        }
        if (!temporaryFiles.isEmpty()) {
            WebTmpCleaner.cleanupTmpFiles(this.getLibFolder(), temporaryFiles);
        }
    }

    public boolean isStarted() {
        return this.server != null && this.server.isStarted();
    }

    public int getPort() {
        return this.connector != null ? this.connector.getLocalPort() : -1;
    }

    private WebAppContext deployWar(String url, String warFile, Path warDirectory) throws IOException {
        WebAppContext webapp = new WebAppContext();
        if (url.startsWith("/")) {
            webapp.setContextPath(url);
        } else {
            webapp.setContextPath("/" + url);
        }
        webapp.setWar(warDirectory.resolve(warFile).toString());
        this.handlers.addHandler((Handler)webapp);
        return webapp;
    }

    public void stop() throws Exception {
        this.stop(false);
    }

    public void stop(boolean isShutdown) throws Exception {
        if (isShutdown) {
            this.internalStop();
        }
    }
}

