/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.jboss.logging.Logger;

public class WebTmpCleaner {
    private static final Logger logger = Logger.getLogger(WebTmpCleaner.class);

    public static void main(String[] filesToClean) throws Exception {
        WebTmpCleaner.cleanupFilesWithRetry(filesToClean, 100);
    }

    private static boolean cleanupFilesWithRetry(String[] filesToClean, int maxRetries) throws Exception {
        boolean allCleaned = false;
        while (!allCleaned && maxRetries-- > 0) {
            allCleaned = true;
            for (String f : filesToClean) {
                URI url;
                File file;
                if (f.trim().isEmpty() || !(file = new File(url = new URI(f))).exists()) continue;
                WebTmpCleaner.deleteFolder(file);
                allCleaned = false;
            }
            Thread.sleep(200L);
        }
        if (!allCleaned) {
            logger.warn((Object)("Some files in web temp dir are not cleaned up after " + maxRetries + " retries."));
        }
        return allCleaned;
    }

    public static Process cleanupTmpFiles(File libFolder, List<File> temporaryFiles) throws Exception {
        return WebTmpCleaner.cleanupTmpFiles(libFolder, temporaryFiles, false);
    }

    public static Process cleanupTmpFiles(File libFolder, List<File> temporaryFiles, boolean invm) throws Exception {
        ArrayList<String> files = new ArrayList<String>(temporaryFiles.size());
        for (File f : temporaryFiles) {
            files.add(f.toURI().toString());
        }
        if (!invm) {
            String classPath = SpawnedVMSupport.getClassPath((File)libFolder);
            return SpawnedVMSupport.spawnVM((String)classPath, (String)WebTmpCleaner.class.getName(), (boolean)false, (String[])files.toArray(new String[files.size()]));
        }
        WebTmpCleaner.cleanupFilesWithRetry(files.toArray(new String[files.size()]), 2);
        return null;
    }

    public static final void deleteFolder(File file) {
        String[] files;
        if (file.isDirectory() && (files = file.list()) != null) {
            for (String path : files) {
                File f = new File(file, path);
                WebTmpCleaner.deleteFolder(f);
            }
        }
        file.delete();
    }
}

