/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.component;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.eclipse.jetty.server.Request;

public class JolokiaFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (AuditLogger.isAnyLoggingEnabled() && servletRequest != null) {
            String remoteHost = servletRequest.getRemoteHost();
            AuditLogger.setRemoteAddress((String)(remoteHost + ":" + servletRequest.getRemotePort()));
        }
        filterChain.doFilter(servletRequest, servletResponse);
        if (AuditLogger.isAnyLoggingEnabled()) {
            try {
                HttpSession session = ((Request)servletRequest).getSession();
                Subject subject = (Subject)session.getAttribute("subject");
                AuditLogger.setCurrentCaller((Subject)subject);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void destroy() {
    }
}

