/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class ExpiryExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setTimeToLive(1000L);
            TextMessage message = session.createTextMessage("this is a text message");
            producer.send((Message)message);
            System.out.println("Sent message to " + queue.getQueueName() + ": " + message.getText());
            System.out.println("Sleep a little bit to let the message expire...");
            Thread.sleep(5000L);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Received message from " + queue.getQueueName() + ": " + messageReceived);
            Queue expiryQueue = (Queue)initialContext.lookup("queue/expiryQueue");
            MessageConsumer expiryConsumer = session.createConsumer((Destination)expiryQueue);
            messageReceived = (TextMessage)expiryConsumer.receive(5000L);
            System.out.println("Received message from " + expiryQueue.getQueueName() + ": " + messageReceived.getText());
            System.out.println();
            System.out.println("Destination of the expired message: " + ((Queue)messageReceived.getJMSDestination()).getQueueName());
            System.out.println("Expiration time of the expired message (relative to the expiry queue): " + messageReceived.getJMSExpiration());
            System.out.println();
            System.out.println("*Origin destination* of the expired message: " + messageReceived.getStringProperty("_AMQ_ORIG_ADDRESS"));
            System.out.println("*Actual expiration time* of the expired message: " + messageReceived.getLongProperty("_AMQ_ACTUAL_EXPIRY"));
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

