/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.example;

import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.EventBus;
import org.vertx.java.platform.PlatformLocator;
import org.vertx.java.platform.PlatformManager;
import org.vertx.java.spi.cluster.impl.hazelcast.HazelcastClusterManagerFactory;

public class VertxConnectorExample {
    public static final String INCOMING = "incoming.vertx.address";
    public static final String OUTGOING = "outgoing.vertx.address";
    public static final String MSG = "Welcome to Vertx world!";
    public static final CountDownLatch latch = new CountDownLatch(1);
    public static final AtomicBoolean result = new AtomicBoolean(false);
    private static final String HOST = "127.0.0.1";
    private static final int PORT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.setProperty("vertx.clusterManagerFactory", HazelcastClusterManagerFactory.class.getName());
        PlatformManager platformManager = null;
        try {
            platformManager = PlatformLocator.factory.createPlatformManager(0, HOST);
            final CountDownLatch latch0 = new CountDownLatch(1);
            String verticle = "org.apache.activemq.artemis.core.example.ExampleVerticle";
            platformManager.deployVerticle(verticle, null, new URL[0], 1, null, (Handler)new Handler<AsyncResult<String>>(){

                public void handle(AsyncResult<String> result) {
                    if (!result.succeeded()) {
                        throw new RuntimeException("failed to deploy verticle", result.cause());
                    }
                    latch0.countDown();
                }
            });
            latch0.await();
            EventBus bus = platformManager.vertx().eventBus();
            bus.send(INCOMING, MSG);
            latch.await(10000L, TimeUnit.MILLISECONDS);
        }
        finally {
            if (platformManager != null) {
                platformManager.undeployAll(null);
                platformManager.stop();
            }
            VertxConnectorExample.reportResultAndExit();
        }
    }

    private static void reportResultAndExit() {
        if (!result.get()) {
            System.err.println();
            System.err.println("#####################");
            System.err.println("###    FAILURE!   ###");
            System.err.println("#####################");
            System.exit(1);
        } else {
            System.out.println();
            System.out.println("#####################");
            System.out.println("###    SUCCESS!   ###");
            System.out.println("#####################");
            System.exit(0);
        }
    }
}

