/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class StompExample {
    private static final String END_OF_FRAME = "\u0000";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            Socket socket = new Socket("localhost", 61613);
            String connectFrame = "CONNECT\naccept-version:1.1\nhost:localhost\nlogin:guest\npasscode:guest\nrequest-id:1\n\n\u0000";
            StompExample.sendFrame(socket, connectFrame);
            String response = StompExample.receiveFrame(socket);
            System.out.println("response: " + response);
            String text = "Hello World from Stomp 1.1 !";
            String message = "SEND\ndestination:jms.queue.exampleQueue\n\n" + text + END_OF_FRAME;
            StompExample.sendFrame(socket, message);
            System.out.println("Sent Stomp message: " + text);
            String disconnectFrame = "DISCONNECT\n\n\u0000";
            StompExample.sendFrame(socket, disconnectFrame);
            socket.close();
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage messageReceived = (TextMessage)consumer.receive(5000L);
            System.out.println("Received JMS message: " + messageReceived.getText());
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void sendFrame(Socket socket, String data) throws Exception {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        OutputStream outputStream = socket.getOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            outputStream.write(bytes[i]);
        }
        outputStream.flush();
    }

    private static String receiveFrame(Socket socket) throws Exception {
        InputStream inputStream = socket.getInputStream();
        byte[] buffer = new byte[1024];
        int size = inputStream.read(buffer);
        byte[] data = new byte[size];
        System.arraycopy(buffer, 0, data, 0, size);
        String frame = new String(data, StandardCharsets.UTF_8);
        return frame;
    }
}

