package org.apache.activemq.artemis.rest;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.apache.activemq.artemis.rest.queue.push.xml.XmlLink;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-03-22T14:07:52-0400")
public class ActiveMQRestLogger_$logger extends DelegatingBasicLogger implements ActiveMQRestLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQRestLogger_$logger.class.getName();
    public ActiveMQRestLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void loadingRestStore(final String path) {
        super.log.logv(FQCN, INFO, null, loadingRestStore$str(), path);
    }
    protected String loadingRestStore$str() {
        return "AMQ181000: Loading REST push store from: {0}";
    }
    @Override
    public final void addingPushRegistration(final String id) {
        super.log.logv(FQCN, INFO, null, addingPushRegistration$str(), id);
    }
    protected String addingPushRegistration$str() {
        return "AMQ181001: adding REST push registration: {0}";
    }
    @Override
    public final void startingPushConsumer(final XmlLink link) {
        super.log.logv(FQCN, INFO, null, startingPushConsumer$str(), link);
    }
    protected String startingPushConsumer$str() {
        return "AMQ181002: Push consumer started for: {0}";
    }
    @Override
    public final void shutdownRestConsumer(final String id) {
        super.log.logv(FQCN, WARN, null, shutdownRestConsumer$str(), id);
    }
    protected String shutdownRestConsumer$str() {
        return "AMQ182000: shutdown REST consumer because of timeout for: {0}";
    }
    @Override
    public final void shutdownRestSubscription(final String id) {
        super.log.logv(FQCN, WARN, null, shutdownRestSubscription$str(), id);
    }
    protected String shutdownRestSubscription$str() {
        return "AMQ182001: shutdown REST subscription because of timeout for: {0}";
    }
    @Override
    public final void failedToPushMessageToUri(final String uri, final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToPushMessageToUri$str(), uri);
    }
    protected String failedToPushMessageToUri$str() {
        return "AMQ182002: Failed to push message to {0}";
    }
    @Override
    public final void failedToBuildMessageFromObject(final Exception e) {
        super.log.logv(FQCN, WARN, e, failedToBuildMessageFromObject$str());
    }
    protected String failedToBuildMessageFromObject$str() {
        return "AMQ182003: Failed to build Message from object";
    }
    @Override
    public final void deprecatedConfiguration(final String oldConfigParameter, final String newConfigParameter) {
        super.log.logv(FQCN, WARN, null, deprecatedConfiguration$str(), oldConfigParameter, newConfigParameter);
    }
    protected String deprecatedConfiguration$str() {
        return "AMQ182004: REST configuration parameter ''{0}'' is deprecated. Use ''{1}'' instead.";
    }
    @Override
    public final void errorLoadingStore(final Exception e, final String name) {
        super.log.logv(FQCN, ERROR, e, errorLoadingStore$str(), name);
    }
    protected String errorLoadingStore$str() {
        return "AMQ184000: Failed to load push store {0}, it is probably corrupted";
    }
    @Override
    public final void errorUpdatingStore(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorUpdatingStore$str());
    }
    protected String errorUpdatingStore$str() {
        return "AMQ184001: Error updating store";
    }
    @Override
    public final void errorPushingMessage(final XmlLink link) {
        super.log.logv(FQCN, ERROR, null, errorPushingMessage$str(), link);
    }
    protected String errorPushingMessage$str() {
        return "AMQ184002: Failed to push message to {0} disabling push registration...";
    }
    @Override
    public final void errorDeletingSubscriberQueue(final ActiveMQException e) {
        super.log.logv(FQCN, ERROR, e, errorDeletingSubscriberQueue$str());
    }
    protected String errorDeletingSubscriberQueue$str() {
        return "AMQ184003: Error deleting Subscriber queue";
    }
}
