/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.sink.timeline.SingleValuedTimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;

@XmlRootElement(name="metrics")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineMetrics {
    private List<TimelineMetric> allMetrics = new ArrayList<TimelineMetric>();

    @XmlElement(name="metrics")
    public List<TimelineMetric> getMetrics() {
        return this.allMetrics;
    }

    public void setMetrics(List<TimelineMetric> allMetrics) {
        this.allMetrics = allMetrics;
    }

    private boolean isEqualTimelineMetrics(TimelineMetric metric1, TimelineMetric metric2) {
        boolean isEqual = true;
        if (!metric1.getMetricName().equals(metric2.getMetricName())) {
            return false;
        }
        if (metric1.getHostName() != null) {
            isEqual = metric1.getHostName().equals(metric2.getHostName());
        }
        if (metric1.getAppId() != null) {
            isEqual = metric1.getAppId().equals(metric2.getAppId());
        }
        return isEqual;
    }

    public void addOrMergeTimelineMetric(TimelineMetric metric) {
        TimelineMetric metricToMerge = null;
        if (!this.allMetrics.isEmpty()) {
            for (TimelineMetric timelineMetric : this.allMetrics) {
                if (!timelineMetric.equalsExceptTime(metric)) continue;
                metricToMerge = timelineMetric;
                break;
            }
        }
        if (metricToMerge != null) {
            metricToMerge.addMetricValues(metric.getMetricValues());
            if (metricToMerge.getTimestamp() > metric.getTimestamp()) {
                metricToMerge.setTimestamp(metric.getTimestamp());
            }
            if (metricToMerge.getStartTime() > metric.getStartTime()) {
                metricToMerge.setStartTime(metric.getStartTime());
            }
        } else {
            this.allMetrics.add(metric);
        }
    }

    public void addOrMergeTimelineMetric(SingleValuedTimelineMetric metric) {
        TimelineMetric metricToMerge = null;
        if (!this.allMetrics.isEmpty()) {
            for (TimelineMetric timelineMetric : this.allMetrics) {
                if (!metric.equalsExceptTime(timelineMetric)) continue;
                metricToMerge = timelineMetric;
                break;
            }
        }
        if (metricToMerge != null) {
            metricToMerge.getMetricValues().put(metric.getTimestamp(), metric.getValue());
            if (metricToMerge.getTimestamp() > metric.getTimestamp()) {
                metricToMerge.setTimestamp(metric.getTimestamp());
            }
            if (metricToMerge.getStartTime() > metric.getStartTime()) {
                metricToMerge.setStartTime(metric.getStartTime());
            }
        } else {
            this.allMetrics.add(metric.getTimelineMetric());
        }
    }
}

