/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline.availability;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.relocated.curator.CuratorZookeeperClient;
import org.apache.hadoop.metrics2.sink.relocated.curator.RetryLoop;
import org.apache.hadoop.metrics2.sink.relocated.curator.RetryPolicy;
import org.apache.hadoop.metrics2.sink.relocated.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.hadoop.metrics2.sink.relocated.zookeeper.ZooKeeper;
import org.apache.hadoop.metrics2.sink.relocated.zookeeper.data.Stat;

public class MetricCollectorHAHelper {
    private final String zookeeperQuorum;
    private final int tryCount;
    private final int sleepMsBetweenRetries;
    private static final int CONNECTION_TIMEOUT = 2000;
    private static final int SESSION_TIMEOUT = 10000;
    private static final String ZNODE = "/ambari-metrics-cluster";
    private static final String ZK_PATH = "/ambari-metrics-cluster/LIVEINSTANCES";
    private static final String INSTANCE_NAME_DELIMITER = "_";
    private static final Log LOG = LogFactory.getLog(MetricCollectorHAHelper.class);

    public MetricCollectorHAHelper(String zookeeperQuorum, int tryCount, int sleepMsBetweenRetries) {
        this.zookeeperQuorum = zookeeperQuorum;
        this.tryCount = tryCount;
        this.sleepMsBetweenRetries = sleepMsBetweenRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> findLiveCollectorHostsFromZNode() {
        HashSet<String> collectors = new HashSet<String>();
        BoundedExponentialBackoffRetry retryPolicy = new BoundedExponentialBackoffRetry(this.sleepMsBetweenRetries, 10 * this.sleepMsBetweenRetries, this.tryCount);
        final CuratorZookeeperClient client = new CuratorZookeeperClient(this.zookeeperQuorum, 10000, 2000, null, (RetryPolicy)retryPolicy);
        List<String> liveInstances = null;
        try {
            client.start();
            Stat stat = client.getZooKeeper().exists(ZNODE, false);
            if (stat == null) {
                LOG.info("/ambari-metrics-cluster znode does not exist. Skipping requesting live instances from zookeeper");
                HashSet<String> hashSet = collectors;
                return hashSet;
            }
            liveInstances = RetryLoop.callWithRetry(client, new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    ZooKeeper zookeeper = client.getZooKeeper();
                    return zookeeper.getChildren(MetricCollectorHAHelper.ZK_PATH, false);
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Unable to connect to zookeeper.", e);
            LOG.debug(e);
        }
        finally {
            try {
                client.close();
            }
            catch (Exception e) {
                LOG.error("Caught exception while trying to close Zk connection.", e);
            }
        }
        if (liveInstances != null && !liveInstances.isEmpty()) {
            for (String instanceStr : liveInstances) {
                collectors.add(instanceStr.substring(0, instanceStr.indexOf(INSTANCE_NAME_DELIMITER)));
            }
        }
        return collectors;
    }
}

