/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.relocated.apache.http.client.protocol;

import java.io.IOException;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.Header;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpException;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpRequest;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpRequestInterceptor;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.auth.AuthOption;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.auth.AuthScheme;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.auth.AuthState;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.auth.AuthenticationException;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.auth.ContextAwareAuthScheme;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.auth.Credentials;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.protocol.HttpContext;

abstract class RequestAuthenticationBase
implements HttpRequestInterceptor {
    final Log log = LogFactory.getLog(this.getClass());

    void process(AuthState authState, HttpRequest request, HttpContext context) throws HttpException, IOException {
        block13: {
            AuthScheme authScheme = authState.getAuthScheme();
            Credentials creds = authState.getCredentials();
            switch (authState.getState()) {
                case FAILURE: {
                    return;
                }
                case SUCCESS: {
                    this.ensureAuthScheme(authScheme);
                    if (!authScheme.isConnectionBased()) break;
                    return;
                }
                case CHALLENGED: {
                    Queue<AuthOption> authOptions = authState.getAuthOptions();
                    if (authOptions != null) {
                        while (!authOptions.isEmpty()) {
                            AuthOption authOption = authOptions.remove();
                            authScheme = authOption.getAuthScheme();
                            creds = authOption.getCredentials();
                            authState.update(authScheme, creds);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Generating response to an authentication challenge using " + authScheme.getSchemeName() + " scheme");
                            }
                            try {
                                Header header = this.authenticate(authScheme, creds, request, context);
                                request.addHeader(header);
                                break;
                            }
                            catch (AuthenticationException ex) {
                                if (!this.log.isWarnEnabled()) continue;
                                this.log.warn(authScheme + " authentication error: " + ex.getMessage());
                            }
                        }
                        return;
                    }
                    this.ensureAuthScheme(authScheme);
                }
            }
            if (authScheme != null) {
                try {
                    Header header = this.authenticate(authScheme, creds, request, context);
                    request.addHeader(header);
                }
                catch (AuthenticationException ex) {
                    if (!this.log.isErrorEnabled()) break block13;
                    this.log.error(authScheme + " authentication error: " + ex.getMessage());
                }
            }
        }
    }

    private void ensureAuthScheme(AuthScheme authScheme) {
        if (authScheme == null) {
            throw new IllegalStateException("Auth scheme is not set");
        }
    }

    private Header authenticate(AuthScheme authScheme, Credentials creds, HttpRequest request, HttpContext context) throws AuthenticationException {
        if (authScheme == null) {
            throw new IllegalStateException("Auth state object is null");
        }
        if (authScheme instanceof ContextAwareAuthScheme) {
            return ((ContextAwareAuthScheme)authScheme).authenticate(creds, request, context);
        }
        return authScheme.authenticate(creds, request);
    }
}

