/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.relocated.apache.http.protocol;

import java.io.IOException;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpException;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpRequest;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpRequestInterceptor;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.annotation.Immutable;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.params.HttpProtocolParams;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.protocol.HttpContext;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        String useragent;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (!request.containsHeader("User-Agent") && (useragent = HttpProtocolParams.getUserAgent(request.getParams())) != null) {
            request.addHeader("User-Agent", useragent);
        }
    }
}

