/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.Header;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HeaderElement;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpEntity;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpHost;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.HttpResponse;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.auth.AuthScope;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.auth.Credentials;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.client.methods.HttpGet;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.client.methods.HttpOptions;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.impl.client.DefaultHttpClient;
import org.apache.hadoop.metrics2.sink.relocated.apache.http.util.EntityUtils;

public class AppCookieManager {
    static final String HADOOP_AUTH = "hadoop.auth";
    private static final String HADOOP_AUTH_EQ = "hadoop.auth=";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final EmptyJaasCredentials EMPTY_JAAS_CREDENTIALS = new EmptyJaasCredentials();
    private Map<String, String> endpointCookieMap = new ConcurrentHashMap<String, String>();
    private static Log LOG = LogFactory.getLog(AppCookieManager.class);

    public static void main(String[] args) throws IOException {
        new AppCookieManager().getAppCookie(args[0], false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAppCookie(String endpoint, boolean refresh) throws IOException {
        String appCookie;
        HttpGet outboundRequest = new HttpGet(endpoint);
        URI uri = outboundRequest.getURI();
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        if (!refresh && (appCookie = this.endpointCookieMap.get(endpoint)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("got cached cookie");
            }
            return appCookie;
        }
        this.clearAppCookie(endpoint);
        DefaultHttpClient client = new DefaultHttpClient();
        SPNegoSchemeFactory spNegoSF = new SPNegoSchemeFactory(true);
        client.getAuthSchemes().register("negotiate", spNegoSF);
        client.getCredentialsProvider().setCredentials(new AuthScope(null, -1, null), EMPTY_JAAS_CREDENTIALS);
        String hadoopAuthCookie = null;
        HttpResponse httpResponse = null;
        try {
            HttpHost httpHost = new HttpHost(host, port, scheme);
            HttpOptions httpRequest = new HttpOptions(path);
            httpResponse = client.execute(httpHost, httpRequest);
            Header[] headers = httpResponse.getHeaders(SET_COOKIE);
            if (LOG.isDebugEnabled()) {
                for (Header header : headers) {
                    LOG.debug(header.getName() + " : " + header.getValue());
                }
            }
            if ((hadoopAuthCookie = AppCookieManager.getHadoopAuthCookieValue(headers)) == null) {
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                HttpEntity entity = httpResponse.getEntity();
                String responseBody = entity != null ? EntityUtils.toString(entity) : null;
                LOG.error("SPNego authentication failed with statusCode = " + statusCode + ", responseBody = " + responseBody + ", can not get hadoop.auth cookie for URL: " + endpoint);
                String string = null;
                return string;
            }
        }
        finally {
            HttpEntity entity;
            if (httpResponse != null && (entity = httpResponse.getEntity()) != null) {
                entity.getContent().close();
            }
        }
        hadoopAuthCookie = HADOOP_AUTH_EQ + AppCookieManager.quote(hadoopAuthCookie);
        this.setAppCookie(endpoint, hadoopAuthCookie);
        if (LOG.isInfoEnabled()) {
            LOG.info("Successful SPNego authentication to URL:" + uri.toString());
        }
        return hadoopAuthCookie;
    }

    public String getCachedAppCookie(String endpoint) {
        return this.endpointCookieMap.get(endpoint);
    }

    private void setAppCookie(String endpoint, String appCookie) {
        this.endpointCookieMap.put(endpoint, appCookie);
    }

    private void clearAppCookie(String endpoint) {
        this.endpointCookieMap.remove(endpoint);
    }

    static String quote(String s) {
        return s == null ? s : "\"" + s + "\"";
    }

    static String getHadoopAuthCookieValue(Header[] headers) {
        if (headers == null) {
            return null;
        }
        for (Header header : headers) {
            HeaderElement[] elements;
            for (HeaderElement element : elements = header.getElements()) {
                String trimmedVal;
                String cookieName = element.getName();
                if (!cookieName.equals(HADOOP_AUTH) || element.getValue() == null || (trimmedVal = element.getValue().trim()).isEmpty()) continue;
                return trimmedVal;
            }
        }
        return null;
    }

    private static class EmptyJaasCredentials
    implements Credentials {
        private EmptyJaasCredentials() {
        }

        @Override
        public String getPassword() {
            return null;
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }
    }
}

