/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.jackson.map.deser.std;

import java.io.IOException;
import org.apache.ambari.metrics.sink.relocated.jackson.JsonParser;
import org.apache.ambari.metrics.sink.relocated.jackson.JsonProcessingException;
import org.apache.ambari.metrics.sink.relocated.jackson.JsonToken;
import org.apache.ambari.metrics.sink.relocated.jackson.map.DeserializationContext;
import org.apache.ambari.metrics.sink.relocated.jackson.map.annotate.JacksonStdImpl;
import org.apache.ambari.metrics.sink.relocated.jackson.map.deser.std.StdScalarDeserializer;
import org.apache.ambari.metrics.sink.relocated.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class ClassDeserializer
extends StdScalarDeserializer<Class<?>> {
    public ClassDeserializer() {
        super(Class.class);
    }

    @Override
    public Class<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String className = jp.getText();
            try {
                return ClassUtil.findClass(className);
            }
            catch (ClassNotFoundException e) {
                throw ctxt.instantiationException(this._valueClass, e);
            }
        }
        throw ctxt.mappingException(this._valueClass, curr);
    }
}

