/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.jackson.map.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.ambari.metrics.sink.relocated.jackson.JsonGenerationException;
import org.apache.ambari.metrics.sink.relocated.jackson.JsonGenerator;
import org.apache.ambari.metrics.sink.relocated.jackson.JsonNode;
import org.apache.ambari.metrics.sink.relocated.jackson.map.JsonMappingException;
import org.apache.ambari.metrics.sink.relocated.jackson.map.JsonSerializableWithType;
import org.apache.ambari.metrics.sink.relocated.jackson.map.ObjectMapper;
import org.apache.ambari.metrics.sink.relocated.jackson.map.SerializerProvider;
import org.apache.ambari.metrics.sink.relocated.jackson.map.TypeSerializer;
import org.apache.ambari.metrics.sink.relocated.jackson.map.annotate.JacksonStdImpl;
import org.apache.ambari.metrics.sink.relocated.jackson.map.ser.std.SerializerBase;
import org.apache.ambari.metrics.sink.relocated.jackson.map.type.TypeFactory;
import org.apache.ambari.metrics.sink.relocated.jackson.node.ObjectNode;
import org.apache.ambari.metrics.sink.relocated.jackson.schema.JsonSerializableSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class SerializableWithTypeSerializer
extends SerializerBase<JsonSerializableWithType> {
    public static final SerializableWithTypeSerializer instance = new SerializableWithTypeSerializer();

    protected SerializableWithTypeSerializer() {
        super(JsonSerializableWithType.class);
    }

    @Override
    public void serialize(JsonSerializableWithType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        value.serialize(jgen, provider);
    }

    @Override
    public final void serializeWithType(JsonSerializableWithType value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        value.serializeWithType(jgen, provider, typeSer);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Class<?> rawClass;
        ObjectNode objectNode = this.createObjectNode();
        String schemaType = "any";
        String objectProperties = null;
        String itemDefinition = null;
        if (typeHint != null && (rawClass = TypeFactory.rawClass(typeHint)).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema schemaInfo = rawClass.getAnnotation(JsonSerializableSchema.class);
            schemaType = schemaInfo.schemaType();
            if (!"##irrelevant".equals(schemaInfo.schemaObjectPropertiesDefinition())) {
                objectProperties = schemaInfo.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(schemaInfo.schemaItemDefinition())) {
                itemDefinition = schemaInfo.schemaItemDefinition();
            }
        }
        objectNode.put("type", schemaType);
        if (objectProperties != null) {
            try {
                objectNode.put("properties", new ObjectMapper().readValue(objectProperties, JsonNode.class));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (itemDefinition != null) {
            try {
                objectNode.put("items", new ObjectMapper().readValue(itemDefinition, JsonNode.class));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return objectNode;
    }
}

