/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ambari.metrics.sink.relocated.jute.BinaryInputArchive;
import org.apache.ambari.metrics.sink.relocated.jute.BinaryOutputArchive;
import org.apache.ambari.metrics.sink.relocated.jute.Record;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.WatchedEvent;
import org.apache.ambari.metrics.sink.relocated.zookeeper.data.Id;
import org.apache.ambari.metrics.sink.relocated.zookeeper.proto.ReplyHeader;
import org.apache.ambari.metrics.sink.relocated.zookeeper.proto.RequestHeader;
import org.apache.ambari.metrics.sink.relocated.zookeeper.proto.WatcherEvent;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.NIOServerCnxnFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ServerCnxn;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ServerCnxnFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ServerStats;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ZooKeeperSaslServer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ZooKeeperServer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ZooTrace;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.command.CommandExecutor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.command.FourLetterCommands;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.command.NopCommand;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.command.SetTraceMaskCommand;

public class NIOServerCnxn
extends ServerCnxn {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxn.class);
    private final NIOServerCnxnFactory factory;
    private final SocketChannel sock;
    private final NIOServerCnxnFactory.SelectorThread selectorThread;
    private final SelectionKey sk;
    private boolean initialized;
    private final ByteBuffer lenBuffer;
    private ByteBuffer incomingBuffer;
    private final Queue<ByteBuffer> outgoingBuffers;
    private int sessionTimeout;
    private final ZooKeeperServer zkServer;
    private final AtomicInteger outstandingRequests;
    private long sessionId;
    private final int outstandingLimit;
    private final AtomicBoolean selectable;
    private final AtomicBoolean throttled;
    private static final byte[] fourBytes = new byte[4];

    public NIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, NIOServerCnxnFactory factory, NIOServerCnxnFactory.SelectorThread selectorThread) throws IOException {
        this.incomingBuffer = this.lenBuffer = ByteBuffer.allocate(4);
        this.outgoingBuffers = new LinkedBlockingQueue<ByteBuffer>();
        this.outstandingRequests = new AtomicInteger(0);
        this.selectable = new AtomicBoolean(true);
        this.throttled = new AtomicBoolean(false);
        this.zkServer = zk;
        this.sock = sock;
        this.sk = sk;
        this.factory = factory;
        this.selectorThread = selectorThread;
        if (this.factory.login != null) {
            this.zooKeeperSaslServer = new ZooKeeperSaslServer(factory.login);
        }
        this.outstandingLimit = zk != null ? zk.getGlobalOutstandingLimit() : 1;
        sock.socket().setTcpNoDelay(true);
        sock.socket().setSoLinger(false, -1);
        InetAddress addr = ((InetSocketAddress)sock.socket().getRemoteSocketAddress()).getAddress();
        this.authInfo.add(new Id("ip", addr.getHostAddress()));
        this.sessionTimeout = factory.sessionlessCnxnTimeout;
    }

    @Override
    public void sendCloseSession() {
        this.sendBuffer(ServerCnxnFactory.closeConn);
    }

    void sendBufferSync(ByteBuffer bb) {
        try {
            if (bb != ServerCnxnFactory.closeConn) {
                if (this.sock.isOpen()) {
                    this.sock.configureBlocking(true);
                    this.sock.write(bb);
                }
                this.packetSent();
            }
        }
        catch (IOException ie) {
            LOG.error("Error sending data synchronously ", ie);
        }
    }

    @Override
    public void sendBuffer(ByteBuffer bb) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Add a buffer to outgoingBuffers, sk " + this.sk + " is valid: " + this.sk.isValid());
        }
        this.outgoingBuffers.add(bb);
        this.requestInterestOpsUpdate();
    }

    private void readPayload() throws IOException, InterruptedException {
        int rc;
        if (this.incomingBuffer.remaining() != 0 && (rc = this.sock.read(this.incomingBuffer)) < 0) {
            throw new ServerCnxn.EndOfStreamException("Unable to read additional data from client sessionid 0x" + Long.toHexString(this.sessionId) + ", likely client has closed socket");
        }
        if (this.incomingBuffer.remaining() == 0) {
            this.packetReceived();
            this.incomingBuffer.flip();
            if (!this.initialized) {
                this.readConnectRequest();
            } else {
                this.readRequest();
            }
            this.lenBuffer.clear();
            this.incomingBuffer = this.lenBuffer;
        }
    }

    public boolean isSelectable() {
        return this.sk.isValid() && this.selectable.get();
    }

    public void disableSelectable() {
        this.selectable.set(false);
    }

    public void enableSelectable() {
        this.selectable.set(true);
    }

    private void requestInterestOpsUpdate() {
        if (this.isSelectable()) {
            this.selectorThread.addInterestOpsUpdateRequest(this.sk);
        }
    }

    void handleWrite(SelectionKey k) throws IOException, ServerCnxn.CloseRequestException {
        if (this.outgoingBuffers.isEmpty()) {
            return;
        }
        ByteBuffer directBuffer = NIOServerCnxnFactory.getDirectBuffer();
        if (directBuffer == null) {
            ByteBuffer bb;
            ByteBuffer[] bufferList = new ByteBuffer[this.outgoingBuffers.size()];
            this.sock.write(this.outgoingBuffers.toArray(bufferList));
            while ((bb = this.outgoingBuffers.peek()) != null) {
                if (bb == ServerCnxnFactory.closeConn) {
                    throw new ServerCnxn.CloseRequestException("close requested");
                }
                if (bb.remaining() <= 0) {
                    this.packetSent();
                    this.outgoingBuffers.remove();
                    continue;
                }
                break;
            }
        } else {
            ByteBuffer bb;
            directBuffer.clear();
            for (ByteBuffer b : this.outgoingBuffers) {
                if (directBuffer.remaining() < b.remaining()) {
                    b = (ByteBuffer)b.slice().limit(directBuffer.remaining());
                }
                int p = b.position();
                directBuffer.put(b);
                b.position(p);
                if (directBuffer.remaining() != 0) continue;
                break;
            }
            directBuffer.flip();
            int sent = this.sock.write(directBuffer);
            while ((bb = this.outgoingBuffers.peek()) != null) {
                if (bb == ServerCnxnFactory.closeConn) {
                    throw new ServerCnxn.CloseRequestException("close requested");
                }
                if (sent < bb.remaining()) {
                    bb.position(bb.position() + sent);
                    break;
                }
                this.packetSent();
                sent -= bb.remaining();
                this.outgoingBuffers.remove();
            }
        }
    }

    protected boolean isSocketOpen() {
        return this.sock.isOpen();
    }

    void doIO(SelectionKey k) throws InterruptedException {
        try {
            if (!this.isSocketOpen()) {
                LOG.warn("trying to do i/o on a null socket for session:0x" + Long.toHexString(this.sessionId));
                return;
            }
            if (k.isReadable()) {
                int rc = this.sock.read(this.incomingBuffer);
                if (rc < 0) {
                    throw new ServerCnxn.EndOfStreamException("Unable to read additional data from client sessionid 0x" + Long.toHexString(this.sessionId) + ", likely client has closed socket");
                }
                if (this.incomingBuffer.remaining() == 0) {
                    boolean isPayload;
                    if (this.incomingBuffer == this.lenBuffer) {
                        this.incomingBuffer.flip();
                        isPayload = this.readLength(k);
                        this.incomingBuffer.clear();
                    } else {
                        isPayload = true;
                    }
                    if (isPayload) {
                        this.readPayload();
                    } else {
                        return;
                    }
                }
            }
            if (k.isWritable()) {
                this.handleWrite(k);
                if (!(this.initialized || this.getReadInterest() || this.getWriteInterest())) {
                    throw new ServerCnxn.CloseRequestException("responded to info probe");
                }
            }
        }
        catch (CancelledKeyException e) {
            LOG.warn("CancelledKeyException causing close of session 0x" + Long.toHexString(this.sessionId));
            if (LOG.isDebugEnabled()) {
                LOG.debug("CancelledKeyException stack trace", e);
            }
            this.close();
        }
        catch (ServerCnxn.CloseRequestException e) {
            this.close();
        }
        catch (ServerCnxn.EndOfStreamException e) {
            LOG.warn(e.getMessage());
            this.close();
        }
        catch (IOException e) {
            LOG.warn("Exception causing close of session 0x" + Long.toHexString(this.sessionId) + ": " + e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug("IOException stack trace", e);
            }
            this.close();
        }
    }

    private void readRequest() throws IOException {
        this.zkServer.processPacket(this, this.incomingBuffer);
    }

    @Override
    protected void incrOutstandingRequests(RequestHeader h) {
        if (h.getXid() >= 0) {
            this.outstandingRequests.incrementAndGet();
            int inProcess = this.zkServer.getInProcess();
            if (inProcess > this.outstandingLimit) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Throttling recv " + inProcess);
                }
                this.disableRecv();
            }
        }
    }

    private boolean getWriteInterest() {
        return !this.outgoingBuffers.isEmpty();
    }

    private boolean getReadInterest() {
        return !this.throttled.get();
    }

    @Override
    public void disableRecv() {
        if (this.throttled.compareAndSet(false, true)) {
            this.requestInterestOpsUpdate();
        }
    }

    @Override
    public void enableRecv() {
        if (this.throttled.compareAndSet(true, false)) {
            this.requestInterestOpsUpdate();
        }
    }

    private void readConnectRequest() throws IOException, InterruptedException {
        if (!this.isZKServerRunning()) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.zkServer.processConnectRequest(this, this.incomingBuffer);
        this.initialized = true;
    }

    private boolean checkFourLetterWord(SelectionKey k, int len) throws IOException {
        if (!FourLetterCommands.isKnown(len)) {
            return false;
        }
        String cmd = FourLetterCommands.getCommandString(len);
        this.packetReceived();
        if (k != null) {
            try {
                k.cancel();
            }
            catch (Exception e) {
                LOG.error("Error cancelling command selection key ", e);
            }
        }
        PrintWriter pwriter = new PrintWriter(new BufferedWriter(new SendBufferWriter()));
        if (!FourLetterCommands.isEnabled(cmd)) {
            LOG.debug("Command {} is not executed because it is not in the whitelist.", (Object)cmd);
            NopCommand nopCmd = new NopCommand(pwriter, this, cmd + " is not executed because it is not in the whitelist.");
            nopCmd.start();
            return true;
        }
        LOG.info("Processing " + cmd + " command from " + this.sock.socket().getRemoteSocketAddress());
        if (len == FourLetterCommands.setTraceMaskCmd) {
            this.incomingBuffer = ByteBuffer.allocate(8);
            int rc = this.sock.read(this.incomingBuffer);
            if (rc < 0) {
                throw new IOException("Read error");
            }
            this.incomingBuffer.flip();
            long traceMask = this.incomingBuffer.getLong();
            ZooTrace.setTextTraceLevel(traceMask);
            SetTraceMaskCommand setMask = new SetTraceMaskCommand(pwriter, this, traceMask);
            setMask.start();
            return true;
        }
        CommandExecutor commandExecutor = new CommandExecutor();
        return commandExecutor.execute(this, pwriter, len, this.zkServer, this.factory);
    }

    private boolean readLength(SelectionKey k) throws IOException {
        int len = this.lenBuffer.getInt();
        if (!this.initialized && this.checkFourLetterWord(this.sk, len)) {
            return false;
        }
        if (len < 0 || len > BinaryInputArchive.maxBuffer) {
            throw new IOException("Len error " + len);
        }
        if (!this.isZKServerRunning()) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.incomingBuffer = ByteBuffer.allocate(len);
        return true;
    }

    boolean isZKServerRunning() {
        return this.zkServer != null && this.zkServer.isRunning();
    }

    @Override
    public long getOutstandingRequests() {
        return this.outstandingRequests.get();
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public String toString() {
        return "ip: " + this.sock.socket().getRemoteSocketAddress() + " sessionId: 0x" + Long.toHexString(this.sessionId);
    }

    @Override
    public void close() {
        block5: {
            if (!this.factory.removeCnxn(this)) {
                return;
            }
            if (this.zkServer != null) {
                this.zkServer.removeCnxn(this);
            }
            if (this.sk != null) {
                try {
                    this.sk.cancel();
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("ignoring exception during selectionkey cancel", e);
                }
            }
        }
        this.closeSock();
    }

    private void closeSock() {
        if (!this.sock.isOpen()) {
            return;
        }
        LOG.info("Closed socket connection for client " + this.sock.socket().getRemoteSocketAddress() + (this.sessionId != 0L ? " which had sessionid 0x" + Long.toHexString(this.sessionId) : " (no session established for client)"));
        NIOServerCnxn.closeSock(this.sock);
    }

    public static void closeSock(SocketChannel sock) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        if (!sock.isOpen()) {
                            return;
                        }
                        try {
                            sock.socket().shutdownOutput();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block9;
                            LOG.debug("ignoring exception during output shutdown", e);
                        }
                    }
                    try {
                        sock.socket().shutdownInput();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block10;
                        LOG.debug("ignoring exception during input shutdown", e);
                    }
                }
                try {
                    sock.socket().close();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("ignoring exception during socket close", e);
                }
            }
            try {
                sock.close();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug("ignoring exception during socketchannel close", e);
            }
        }
    }

    @Override
    public void sendResponse(ReplyHeader h, Record r, String tag) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            try {
                baos.write(fourBytes);
                bos.writeRecord(h, "header");
                if (r != null) {
                    bos.writeRecord(r, tag);
                }
                baos.close();
            }
            catch (IOException e) {
                LOG.error("Error serializing response");
            }
            byte[] b = baos.toByteArray();
            ByteBuffer bb = ByteBuffer.wrap(b);
            bb.putInt(b.length - 4).rewind();
            this.sendBuffer(bb);
            if (h.getXid() > 0 && (this.outstandingRequests.decrementAndGet() < 1 || this.zkServer.getInProcess() < this.outstandingLimit)) {
                this.enableRecv();
            }
        }
        catch (Exception e) {
            LOG.warn("Unexpected exception. Destruction averted.", e);
        }
    }

    @Override
    public void process(WatchedEvent event) {
        ReplyHeader h = new ReplyHeader(-1, -1L, 0);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "Deliver event " + event + " to 0x" + Long.toHexString(this.sessionId) + " through " + this);
        }
        WatcherEvent e = event.getWrapper();
        this.sendResponse(h, e, "notification");
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.factory.addSession(sessionId, this);
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        this.factory.touchCnxn(this);
    }

    @Override
    public int getInterestOps() {
        if (!this.isSelectable()) {
            return 0;
        }
        int interestOps = 0;
        if (this.getReadInterest()) {
            interestOps |= 1;
        }
        if (this.getWriteInterest()) {
            interestOps |= 4;
        }
        return interestOps;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        if (!this.sock.isOpen()) {
            return null;
        }
        return (InetSocketAddress)this.sock.socket().getRemoteSocketAddress();
    }

    public InetAddress getSocketAddress() {
        if (!this.sock.isOpen()) {
            return null;
        }
        return this.sock.socket().getInetAddress();
    }

    @Override
    protected ServerStats serverStats() {
        if (this.zkServer == null) {
            return null;
        }
        return this.zkServer.serverStats();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public Certificate[] getClientCertificateChain() {
        throw new UnsupportedOperationException("SSL is unsupported in NIOServerCnxn");
    }

    @Override
    public void setClientCertificateChain(Certificate[] chain) {
        throw new UnsupportedOperationException("SSL is unsupported in NIOServerCnxn");
    }

    private class SendBufferWriter
    extends Writer {
        private StringBuffer sb = new StringBuffer();

        private SendBufferWriter() {
        }

        private void checkFlush(boolean force) {
            if (force && this.sb.length() > 0 || this.sb.length() > 2048) {
                NIOServerCnxn.this.sendBufferSync(ByteBuffer.wrap(this.sb.toString().getBytes()));
                this.sb.setLength(0);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.sb == null) {
                return;
            }
            this.checkFlush(true);
            this.sb = null;
        }

        @Override
        public void flush() throws IOException {
            this.checkFlush(true);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
            this.checkFlush(false);
        }
    }
}

