/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.command;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ServerCnxn;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ServerCnxnFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ZooKeeperServer;

public abstract class AbstractFourLetterCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFourLetterCommand.class);
    protected static final String ZK_NOT_SERVING = "This ZooKeeper instance is not currently serving requests";
    protected PrintWriter pw;
    protected ServerCnxn serverCnxn;
    protected ZooKeeperServer zkServer;
    protected ServerCnxnFactory factory;

    public AbstractFourLetterCommand(PrintWriter pw, ServerCnxn serverCnxn) {
        this.pw = pw;
        this.serverCnxn = serverCnxn;
    }

    public void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.commandRun();
        }
        catch (IOException ie) {
            LOG.error("Error in running command ", ie);
        }
        finally {
            this.serverCnxn.cleanupWriterSocket(this.pw);
        }
    }

    public void setZkServer(ZooKeeperServer zkServer) {
        this.zkServer = zkServer;
    }

    boolean isZKServerRunning() {
        return this.zkServer != null && this.zkServer.isRunning();
    }

    public void setFactory(ServerCnxnFactory factory) {
        this.factory = factory;
    }

    public abstract void commandRun() throws IOException;
}

