/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.command;

import java.io.PrintWriter;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.Version;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ServerCnxn;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.command.AbstractFourLetterCommand;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.command.FourLetterCommands;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.ReadOnlyZooKeeperServer;

public class StatCommand
extends AbstractFourLetterCommand {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFourLetterCommand.class);
    private int len;

    public StatCommand(PrintWriter pw, ServerCnxn serverCnxn, int len) {
        super(pw, serverCnxn);
        this.len = len;
    }

    @Override
    public void commandRun() {
        if (!this.isZKServerRunning()) {
            this.pw.println("This ZooKeeper instance is not currently serving requests");
        } else {
            this.pw.print("Zookeeper version: ");
            this.pw.println(Version.getFullVersion());
            if (this.zkServer instanceof ReadOnlyZooKeeperServer) {
                this.pw.println("READ-ONLY mode; serving only read-only clients");
            }
            if (this.len == FourLetterCommands.statCmd) {
                LOG.info("Stat command output");
                this.pw.println("Clients:");
                for (ServerCnxn c : this.factory.getConnections()) {
                    c.dumpConnectionInfo(this.pw, true);
                    this.pw.println();
                }
                this.pw.println();
            }
            this.pw.print(this.zkServer.serverStats().toString());
            this.pw.print("Node count: ");
            this.pw.println(this.zkServer.getZKDatabase().getNodeCount());
        }
    }
}

