/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.ambari.metrics.sink.relocated.jute.Record;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.FinalRequestProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.Request;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.SyncRequestProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ZKDatabase;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.CommitProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.Follower;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.FollowerRequestProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.Learner;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.QuorumPeer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.SendAckRequestProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.txn.TxnHeader;

public class FollowerZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(FollowerZooKeeperServer.class);
    ConcurrentLinkedQueue<Request> pendingSyncs;
    LinkedBlockingQueue<Request> pendingTxns = new LinkedBlockingQueue();

    FollowerZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, zkDb, self);
        this.pendingSyncs = new ConcurrentLinkedQueue();
    }

    public Follower getFollower() {
        return this.self.follower;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        this.firstProcessor = new FollowerRequestProcessor(this, this.commitProcessor);
        ((FollowerRequestProcessor)this.firstProcessor).start();
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getFollower()));
        this.syncProcessor.start();
    }

    public void logRequest(TxnHeader hdr, Record txn) {
        Request request = new Request(hdr.getClientId(), hdr.getCxid(), hdr.getType(), hdr, txn, hdr.getZxid());
        if ((request.zxid & 0xFFFFFFFFL) != 0L) {
            this.pendingTxns.add(request);
        }
        this.syncProcessor.processRequest(request);
    }

    public void commit(long zxid) {
        if (this.pendingTxns.size() == 0) {
            LOG.warn("Committing " + Long.toHexString(zxid) + " without seeing txn");
            return;
        }
        long firstElementZxid = ((Request)this.pendingTxns.element()).zxid;
        if (firstElementZxid != zxid) {
            LOG.error("Committing zxid 0x" + Long.toHexString(zxid) + " but next pending txn 0x" + Long.toHexString(firstElementZxid));
            System.exit(12);
        }
        Request request = (Request)this.pendingTxns.remove();
        this.commitProcessor.commit(request);
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    @Override
    public int getGlobalOutstandingLimit() {
        int divisor = this.self.getQuorumSize() > 2 ? this.self.getQuorumSize() - 1 : 1;
        return super.getGlobalOutstandingLimit() / divisor;
    }

    @Override
    public String getState() {
        return "follower";
    }

    @Override
    public Learner getLearner() {
        return this.getFollower();
    }
}

