/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.FinalRequestProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.Request;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.SyncRequestProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ZKDatabase;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.CommitProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.Learner;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.Observer;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.ObserverRequestProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.QuorumPeer;

public class ObserverZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverZooKeeperServer.class);
    private boolean syncRequestProcessorEnabled;
    ConcurrentLinkedQueue<Request> pendingSyncs;

    ObserverZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, zkDb, self);
        this.syncRequestProcessorEnabled = this.self.getSyncEnabled();
        this.pendingSyncs = new ConcurrentLinkedQueue();
        LOG.info("syncEnabled =" + this.syncRequestProcessorEnabled);
    }

    public Observer getObserver() {
        return this.self.observer;
    }

    @Override
    public Learner getLearner() {
        return this.self.observer;
    }

    public void commitRequest(Request request) {
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor.processRequest(request);
        }
        this.commitProcessor.commit(request);
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        this.firstProcessor = new ObserverRequestProcessor(this, this.commitProcessor);
        ((ObserverRequestProcessor)this.firstProcessor).start();
        if (this.syncRequestProcessorEnabled) {
            this.syncProcessor = new SyncRequestProcessor(this, null);
            this.syncProcessor.start();
        }
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    @Override
    public String getState() {
        return "observer";
    }

    @Override
    public synchronized void shutdown() {
        if (!this.canShutdown()) {
            LOG.debug("ZooKeeper server is not running, so not proceeding to shutdown!");
            return;
        }
        super.shutdown();
        if (this.syncRequestProcessorEnabled && this.syncProcessor != null) {
            this.syncProcessor.shutdown();
        }
    }
}

