/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum;

import java.io.Flushable;
import java.io.IOException;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.Request;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.RequestProcessor;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.Learner;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.QuorumPacket;

public class SendAckRequestProcessor
implements RequestProcessor,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(SendAckRequestProcessor.class);
    Learner learner;

    SendAckRequestProcessor(Learner peer) {
        this.learner = peer;
    }

    @Override
    public void processRequest(Request si) {
        if (si.type != 9) {
            QuorumPacket qp = new QuorumPacket(3, si.getHdr().getZxid(), null, null);
            try {
                this.learner.writePacket(qp, false);
            }
            catch (IOException e) {
                LOG.warn("Closing connection to leader, exception during packet send", e);
                try {
                    if (!this.learner.sock.isClosed()) {
                        this.learner.sock.close();
                    }
                }
                catch (IOException e1) {
                    LOG.debug("Ignoring error closing the connection", e1);
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.learner.writePacket(null, true);
        }
        catch (IOException e) {
            LOG.warn("Closing connection to leader, exception during packet send", e);
            try {
                if (!this.learner.sock.isClosed()) {
                    this.learner.sock.close();
                }
            }
            catch (IOException e1) {
                LOG.debug("Ignoring error closing the connection", e1);
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

