/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ambari.metrics.sink.relocated.slf4j.Logger;
import org.apache.ambari.metrics.sink.relocated.slf4j.LoggerFactory;
import org.apache.ambari.metrics.sink.relocated.zookeeper.KeeperException;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.SessionTracker;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.ZooKeeperServerListener;
import org.apache.ambari.metrics.sink.relocated.zookeeper.server.quorum.LocalSessionTracker;

public abstract class UpgradeableSessionTracker
implements SessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeableSessionTracker.class);
    private ConcurrentMap<Long, Integer> localSessionsWithTimeouts;
    protected LocalSessionTracker localSessionTracker;

    public void start() {
    }

    public void createLocalSessionTracker(SessionTracker.SessionExpirer expirer, int tickTime, long id, ZooKeeperServerListener listener) {
        this.localSessionsWithTimeouts = new ConcurrentHashMap<Long, Integer>();
        this.localSessionTracker = new LocalSessionTracker(expirer, this.localSessionsWithTimeouts, tickTime, id, listener);
    }

    @Override
    public boolean isTrackingSession(long sessionId) {
        return this.isLocalSession(sessionId) || this.isGlobalSession(sessionId);
    }

    public boolean isLocalSession(long sessionId) {
        return this.localSessionTracker != null && this.localSessionTracker.isTrackingSession(sessionId);
    }

    public abstract boolean isGlobalSession(long var1);

    public int upgradeSession(long sessionId) {
        if (this.localSessionsWithTimeouts == null) {
            return -1;
        }
        Integer timeout = (Integer)this.localSessionsWithTimeouts.remove(sessionId);
        if (timeout != null) {
            LOG.info("Upgrading session 0x" + Long.toHexString(sessionId));
            this.addGlobalSession(sessionId, timeout);
            this.localSessionTracker.removeSession(sessionId);
            return timeout;
        }
        return -1;
    }

    @Override
    public void checkGlobalSession(long sessionId, Object owner) throws KeeperException.SessionExpiredException, KeeperException.SessionMovedException {
        throw new UnsupportedOperationException();
    }
}

