/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import org.apache.ambari.metrics.sink.relocated.jackson.annotate.JsonCreator;
import org.apache.ambari.metrics.sink.relocated.jackson.annotate.JsonProperty;
import org.apache.hadoop.metrics2.sink.timeline.MetricAggregate;

public class MetricClusterAggregate
extends MetricAggregate {
    private int numberOfHosts;

    @JsonCreator
    public MetricClusterAggregate() {
    }

    public MetricClusterAggregate(Double sum, int numberOfHosts, Double deviation, Double max, Double min) {
        super(sum, deviation, max, min);
        this.numberOfHosts = numberOfHosts;
    }

    @JsonProperty(value="numberOfHosts")
    public int getNumberOfHosts() {
        return this.numberOfHosts;
    }

    public void updateNumberOfHosts(int count) {
        this.numberOfHosts += count;
    }

    public void setNumberOfHosts(int numberOfHosts) {
        this.numberOfHosts = numberOfHosts;
    }

    public void updateAggregates(MetricClusterAggregate hostAggregate) {
        this.updateMax(hostAggregate.getMax());
        this.updateMin(hostAggregate.getMin());
        this.updateSum(hostAggregate.getSum());
        this.updateNumberOfHosts(hostAggregate.getNumberOfHosts());
    }

    public String toString() {
        return "MetricAggregate{sum=" + this.sum + ", numberOfHosts=" + this.numberOfHosts + ", deviation=" + this.deviation + ", max=" + this.max + ", min=" + this.min + '}';
    }
}

