/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import org.apache.ant.compress.resources.CommonsCompressArchiveScanner;
import org.apache.ant.compress.resources.CpioResource;
import org.apache.ant.compress.util.CpioStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;

public class CpioFileSet
extends ArchiveFileSet {
    private boolean userIdSet;
    private boolean groupIdSet;
    private int uid;
    private int gid;
    private boolean skipUnreadable = false;

    public CpioFileSet() {
    }

    protected CpioFileSet(FileSet fileset) {
        super(fileset);
    }

    protected CpioFileSet(CpioFileSet fileset) {
        super((ArchiveFileSet)fileset);
    }

    public void setUid(int uid) {
        this.checkCpioFileSetAttributesAllowed();
        this.userIdSet = true;
        this.uid = uid;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((CpioFileSet)((Object)this.getCheckedRef())).getUid();
        }
        return this.uid;
    }

    public boolean hasUserIdBeenSet() {
        return this.userIdSet;
    }

    public void setGid(int gid) {
        this.checkCpioFileSetAttributesAllowed();
        this.groupIdSet = true;
        this.gid = gid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((CpioFileSet)((Object)this.getCheckedRef())).getGid();
        }
        return this.gid;
    }

    public boolean hasGroupIdBeenSet() {
        return this.groupIdSet;
    }

    public void setSkipUnreadableEntries(boolean b) {
        this.skipUnreadable = b;
    }

    protected ArchiveScanner newArchiveScanner() {
        return new CommonsCompressArchiveScanner(new CpioStreamFactory(), new CommonsCompressArchiveScanner.ResourceBuilder(){

            public Resource buildResource(Resource archive, String encoding, ArchiveEntry entry) {
                return new CpioResource(archive, (CpioArchiveEntry)entry);
            }
        }, this.skipUnreadable, this.getProject());
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.userIdSet || this.groupIdSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    protected AbstractFileSet getRef(Project p) {
        this.dieOnCircularReference(p);
        Object o = this.getRefid().getReferencedObject(p);
        if (o instanceof CpioFileSet) {
            return (AbstractFileSet)o;
        }
        if (o instanceof FileSet) {
            CpioFileSet zfs = new CpioFileSet((FileSet)o);
            this.configureFileSet(zfs);
            return zfs;
        }
        String msg = this.getRefid().getRefId() + " doesn't denote a cpiofileset or a fileset";
        throw new BuildException(msg);
    }

    protected void configureFileSet(ArchiveFileSet zfs) {
        super.configureFileSet(zfs);
        if (zfs instanceof CpioFileSet) {
            CpioFileSet tfs = (CpioFileSet)zfs;
            tfs.setUid(this.uid);
            tfs.setGid(this.gid);
        }
    }

    public Object clone() {
        if (this.isReference()) {
            return ((CpioFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    private void checkCpioFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof CpioFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

